/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.bo.busi.UccCommdOverViewAmountQryReqBO;
import com.tydic.commodity.bo.busi.UccCommdOverViewAmountQryRspBO;
import com.tydic.commodity.busi.api.UccCommdOverViewAmountQryBusiService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccCommdStatusCountPo;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccCommdOverViewAmountQryBusiService.class)
public class UccCommdOverViewAmountQryBusiServiceImpl
implements UccCommdOverViewAmountQryBusiService {
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommdOverViewAmountQryBusiServiceImpl.class);

    public UccCommdOverViewAmountQryRspBO queryCommdAmount(UccCommdOverViewAmountQryReqBO reqBO) {
        UccCommdOverViewAmountQryRspBO rspBO = new UccCommdOverViewAmountQryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setDepotItemNum(Long.valueOf(0L));
        rspBO.setSaleNum(Long.valueOf(0L));
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        if (reqBO.getOrgIdIn() == null) {
            throw new BusinessException("8888", "\u8bf7\u8f93\u5165\u673a\u6784ID");
        }
        reqBO.setSupplierId(reqBO.getOrgIdIn());
        if (reqBO.getRootOrgIdIn() != null) {
            reqBO.setSupplierId(reqBO.getRootOrgIdIn());
        }
        ArrayList<Long> commodityTypeIds = new ArrayList();
        if (reqBO.getSceneId() != null && CollectionUtils.isEmpty(commodityTypeIds = this.getCommodityTypeIds(reqBO.getSceneId()))) {
            return rspBO;
        }
        List<Object> poList = new ArrayList();
        poList = CollectionUtils.isEmpty(commodityTypeIds) ? this.uccSkuMapper.qryCommdCountGourpBySkuStaus(reqBO.getSupplierId()) : this.uccSkuMapper.qryCommdCountGourpBySkuStausAndSceneId(reqBO.getSupplierId(), commodityTypeIds);
        if (poList.size() == 0) {
            return rspBO;
        }
        Long count = 0L;
        for (UccCommdStatusCountPo uccCommdStatusCountPo : poList) {
            if (uccCommdStatusCountPo.getSkuStatus() == 3) {
                rspBO.setSaleNum(uccCommdStatusCountPo.getCount());
                continue;
            }
            if (uccCommdStatusCountPo.getSkuStatus() == 6 || uccCommdStatusCountPo.getSkuStatus() == 10 || uccCommdStatusCountPo.getSkuStatus() == 0) continue;
            count = count + uccCommdStatusCountPo.getCount();
        }
        rspBO.setDepotItemNum(count);
        return rspBO;
    }

    private List<Long> getCommodityTypeIds(Long sceneId) {
        try {
            List<Long> commodityTypeIds = this.uccCatalogDealMapper.qryCommodityTypeBySceneId(sceneId);
            if (CollectionUtils.isNotEmpty(commodityTypeIds)) {
                return commodityTypeIds;
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5931\u8d25");
        }
        return null;
    }
}

