/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.bo.ability.SaleSkuPropEntityBo;
import com.tydic.commodity.bo.busi.UccCommdQrySalePropBO;
import com.tydic.commodity.bo.busi.UccCommdQrySalePropReqBO;
import com.tydic.commodity.bo.busi.UccCommdQrySalePropRspBO;
import com.tydic.commodity.busi.api.UccCommdQrySalePropBusiService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccSceneSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.dao.UccSkuStockMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccSceneSkuPricePo;
import com.tydic.commodity.dao.po.UccSkuPicPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.dao.po.UccSkuSpecPo;
import com.tydic.commodity.dao.po.UccSkuStockPo;
import com.tydic.commodity.dao.po.UccVendorPo;
import com.tydic.commodity.external.bo.CommdStockBO;
import com.tydic.commodity.external.bo.UccTmCommdStockQryReqBO;
import com.tydic.commodity.external.bo.UccTmCommdStockQryRspBO;
import com.tydic.commodity.external.bo.UccTmStockBO;
import com.tydic.commodity.external.service.UccTmCommdStockQryService;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccCommdQrySalePropBusiService.class)
public class UccCommdQrySalePropBusiServiceImpl
implements UccCommdQrySalePropBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommdQrySalePropBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccSkuStockMapper uccSkuStockMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccVendorMapper uccVendorMapper;
    @Autowired
    private UccTmCommdStockQryService uccTmCommdStockQryService;
    @Autowired
    private UccSceneSkuPriceMapper uccSceneSkuPriceMapper;

    public UccCommdQrySalePropRspBO qryProp(UccCommdQrySalePropReqBO reqBO) {
        List<UccSceneSkuPricePo> list;
        UccCommodityPo uccCommodityPo;
        UccCommdQrySalePropRspBO rspBO = new UccCommdQrySalePropRspBO();
        if (reqBO == null || reqBO.getCommodityId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        if (reqBO.getRootOrgIdIn() != null) {
            reqBO.setSupplierShopId(reqBO.getRootOrgIdIn());
        }
        if ((uccCommodityPo = this.uccCommodityMapper.qryCommdByCommdId(reqBO.getCommodityId(), reqBO.getSupplierShopId())) == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        UccVendorPo uccVendorPo = new UccVendorPo();
        uccVendorPo.setVendorId(uccCommodityPo.getVendorId());
        List<UccVendorPo> comdVendorPoList = this.uccVendorMapper.queryVerdor(uccVendorPo);
        UccSkuPo skuPo = new UccSkuPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)skuPo);
        List<UccSkuPo> skuPoList = this.uccSkuMapper.qerySku(skuPo);
        if (skuPoList == null || skuPoList.size() == 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        ArrayList<UccCommdQrySalePropBO> result = new ArrayList<UccCommdQrySalePropBO>();
        ArrayList<Long> skus = new ArrayList<Long>();
        ArrayList<Long> commdIds = new ArrayList<Long>();
        UccCommdQrySalePropBO skuBo = null;
        for (UccSkuPo uccSkuPo : skuPoList) {
            if (ModelRuleConstant.SKU_STATUS_INVALID.equals(uccSkuPo.getSkuStatus())) continue;
            skuBo = new UccCommdQrySalePropBO();
            skuBo.setStatus(uccSkuPo.getSkuStatus());
            if (!CollectionUtils.isEmpty(comdVendorPoList)) {
                skuBo.setVendorCode(comdVendorPoList.get(0).getVendorCode());
            }
            skuBo.setExtSkuId(uccCommodityPo.getExtSkuId());
            if (uccSkuPo.getExtSkuId().equals(uccCommodityPo.getExtSkuId()) && comdVendorPoList != null && comdVendorPoList.size() > 0 && "tianmao".equals(comdVendorPoList.get(0).getVendorCode())) {
                skuBo.setExtralSkuId("-1");
            } else {
                skuBo.setExtralSkuId(uccSkuPo.getExtSkuId());
            }
            skuBo.setSkuId(uccSkuPo.getSkuId());
            skuBo.setCommodityId(uccSkuPo.getCommodityId());
            skuBo.setSkuName(uccSkuPo.getSkuName());
            skuBo.setSupplierShopId(uccSkuPo.getSupplierShopId());
            result.add(skuBo);
            skus.add(uccSkuPo.getSkuId());
        }
        commdIds.add(skuPoList.get(0).getCommodityId());
        List<UccSkuPricePo> skuPricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(skus, skuPoList.get(0).getSupplierShopId());
        block1: for (UccCommdQrySalePropBO each : result) {
            for (UccSkuPricePo uccSkuPricePo : skuPricePos) {
                if (!each.getSkuId().equals(uccSkuPricePo.getSkuId())) continue;
                each.setSalePrice(MoneyUtils.haoToYuan((Long)uccSkuPricePo.getSalePrice()));
                each.setAgreementPrice(MoneyUtils.haoToYuan((Long)uccSkuPricePo.getAgreementPrice()));
                each.setMarketPrice(MoneyUtils.haoToYuan((Long)uccSkuPricePo.getMarketPrice()));
                if (uccSkuPricePo.getWholesalePrice() != null) {
                    each.setWholesalePrice(MoneyUtils.haoToYuan((Long)uccSkuPricePo.getWholesalePrice()));
                } else {
                    each.setWholesalePrice(new BigDecimal(0));
                }
                if (uccSkuPricePo.getDistributionPrice() != null) {
                    each.setDistributionPrice(MoneyUtils.haoToYuan((Long)uccSkuPricePo.getDistributionPrice()));
                } else {
                    each.setDistributionPrice(new BigDecimal(0));
                }
                if (uccSkuPricePo.getSupplyPrice1() != null) {
                    each.setSupplyPrice1(MoneyUtils.haoToYuan((Long)uccSkuPricePo.getSupplyPrice1()));
                    continue block1;
                }
                each.setSupplyPrice1(new BigDecimal(0));
                continue block1;
            }
        }
        if (reqBO.getSceneId() != null && !CollectionUtils.isEmpty(list = this.uccSceneSkuPriceMapper.qrySKuBySceneandCommd(reqBO.getCommodityId(), reqBO.getSceneId()))) {
            Map<Long, UccSceneSkuPricePo> sceneSkuMap = list.stream().collect(Collectors.toMap(UccSceneSkuPricePo::getSkuId, UccSceneSkuPricePo2 -> UccSceneSkuPricePo2));
            for (UccCommdQrySalePropBO uccCommdQrySalePropBO : result) {
                if (!sceneSkuMap.containsKey(uccCommdQrySalePropBO.getSkuId())) continue;
                uccCommdQrySalePropBO.setSalePrice(MoneyUtils.haoToYuan((Long)sceneSkuMap.get(uccCommdQrySalePropBO.getSkuId()).getSalePrice()));
                uccCommdQrySalePropBO.setWholesalePrice(MoneyUtils.haoToYuan((Long)sceneSkuMap.get(uccCommdQrySalePropBO.getSkuId()).getWholesalePrice()));
                uccCommdQrySalePropBO.setMarketPrice(MoneyUtils.haoToYuan((Long)sceneSkuMap.get(uccCommdQrySalePropBO.getSkuId()).getMarketPrice()));
                uccCommdQrySalePropBO.setDistributionPrice(MoneyUtils.haoToYuan((Long)sceneSkuMap.get(uccCommdQrySalePropBO.getSkuId()).getDistributionPrice()));
            }
        }
        this.queryImg(result);
        List<UccSkuStockPo> list2 = this.uccSkuStockMapper.batchQryById(skus, ((UccCommdQrySalePropBO)result.get(0)).getSupplierShopId());
        Map<Long, BigDecimal> stockMap = list2.stream().collect(Collectors.toMap(UccSkuStockPo::getSkuId, UccSkuStockPo::getStockNum));
        for (UccCommdQrySalePropBO uccCommdQrySalePropBO : result) {
            if (!stockMap.containsKey(uccCommdQrySalePropBO.getSkuId())) continue;
            uccCommdQrySalePropBO.setSoldNumber(stockMap.get(uccCommdQrySalePropBO.getSkuId()));
        }
        if (reqBO.getCounty() != null && "tianmao".equals(comdVendorPoList.get(0).getVendorCode())) {
            ArrayList<UccCommdQrySalePropBO> tianmaoSource = new ArrayList<UccCommdQrySalePropBO>();
            for (UccCommdQrySalePropBO each : result) {
                if (!ModelRuleConstant.SKU_STATUS_ON_SHELF.equals(each.getStatus())) continue;
                tianmaoSource.add(each);
            }
            this.queryTianmaoStock(tianmaoSource, String.valueOf(reqBO.getCounty()));
        }
        for (UccCommdQrySalePropBO uccCommdQrySalePropBO : result) {
            if (reqBO.getSkuId() != null) {
                if (!uccCommdQrySalePropBO.getSkuId().equals(reqBO.getSkuId())) continue;
                this.querySkuProperties(uccCommdQrySalePropBO);
                break;
            }
            this.querySkuProperties(uccCommdQrySalePropBO);
        }
        if (reqBO.getRootOrgIdIn() != null) {
            for (UccCommdQrySalePropBO uccCommdQrySalePropBO : result) {
                uccCommdQrySalePropBO.setSupplierShopId(reqBO.getOrgIdIn());
            }
        }
        rspBO.setSalePropList(result);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f!");
        return rspBO;
    }

    public void queryImg(List<UccCommdQrySalePropBO> bo) {
        ArrayList<Long> skus = new ArrayList<Long>();
        for (UccCommdQrySalePropBO each : bo) {
            skus.add(each.getSkuId());
        }
        ArrayList<Long> noSkuPic = new ArrayList<Long>();
        List<UccSkuPicPo> picPos = this.uccSkuPicMapper.queryBatchLesCloum(skus, bo.get(0).getSupplierShopId(), ModelRuleConstant.COMMD_IMG_MAIN);
        Map<Long, String> SkuImg = picPos.stream().collect(Collectors.toMap(UccSkuPicPo::getSkuId, UccSkuPicPo::getSkuPicUrl));
        for (UccCommdQrySalePropBO each : bo) {
            if (!SkuImg.containsKey(each.getSkuId()) || SkuImg.get(each.getSkuId()) == null) {
                noSkuPic.add(each.getCommodityId());
                continue;
            }
            each.setPicUrl(SkuImg.get(each.getSkuId()));
        }
        if (noSkuPic.size() > 0) {
            List commdPicPos = this.uccCommodityPicMapper.queryBatchLesCloum(noSkuPic, bo.get(0).getSupplierShopId(), ModelRuleConstant.COMMD_IMG_MAIN);
            commdPicPos = commdPicPos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<UccCommodityPicPo>(Comparator.comparing(UccCommodityPicPo::getCommodityId))), ArrayList::new));
            Map<Long, String> commdImg = commdPicPos.stream().collect(Collectors.toMap(UccCommodityPicPo::getCommodityId, UccCommodityPicPo::getCommodityPicUrl));
            for (UccCommdQrySalePropBO each : bo) {
                if (!commdImg.containsKey(each.getCommodityId())) continue;
                each.setPicUrl(commdImg.get(each.getCommodityId()));
            }
        }
    }

    private void querySkuProperties(UccCommdQrySalePropBO sku) {
        UccSkuSpecPo uccSkuSpecPo = new UccSkuSpecPo();
        uccSkuSpecPo.setSkuId(sku.getSkuId());
        uccSkuSpecPo.setSupplierShopId(sku.getSupplierShopId());
        List<UccSkuSpecPo> skuSpecPoList = this.uccSkuSpecMapper.querySpec(uccSkuSpecPo);
        if (skuSpecPoList == null || skuSpecPoList.size() == 0) {
            return;
        }
        SaleSkuPropEntityBo bo = null;
        JSONArray properties = new JSONArray();
        JSONObject object = null;
        sku.setSaleSkuPropEntitys(new ArrayList());
        for (UccSkuSpecPo each : skuSpecPoList) {
            bo = new SaleSkuPropEntityBo();
            BeanUtils.copyProperties((Object)each, (Object)bo);
            bo.setShowName(each.getPropShowName());
            sku.getSaleSkuPropEntitys().add(bo);
            object = new JSONObject();
            object.put(each.getPropShowName(), (Object)each.getPropValue());
            properties.add((Object)object);
        }
        sku.setSkuProperties(properties.toString());
    }

    private void queryTianmaoStock(List<UccCommdQrySalePropBO> bo, String area) {
        if (bo == null || bo.size() == 0) {
            return;
        }
        ArrayList<Long> skuIds = new ArrayList<Long>();
        for (UccCommdQrySalePropBO each : bo) {
            skuIds.add(each.getSkuId());
        }
        List<UccSkuPo> skuPoList = this.uccSkuMapper.qeryBatchSkus(skuIds);
        if (skuPoList == null || skuPoList.size() == 0) {
            LOGGER.info("\u5355\u54c1\u5e93\u5b58\u67e5\u8be2\uff1a" + JSONObject.toJSONString(skuIds) + "\u672a\u67e5\u8be2\u5230\u5355\u54c1\u4fe1\u606f");
            return;
        }
        UccCommodityPo commodityPo = this.uccCommodityMapper.qryCommdByCommdId(skuPoList.get(0).getCommodityId(), skuPoList.get(0).getSupplierShopId());
        if (commodityPo == null) {
            LOGGER.error("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f: commodityId = " + skuPoList.get(0).getCommodityId() + "supplierShopId = " + skuPoList.get(0).getSupplierShopId());
            return;
        }
        UccTmCommdStockQryReqBO reqBO = new UccTmCommdStockQryReqBO();
        ArrayList<UccTmStockBO> itemList = new ArrayList<UccTmStockBO>();
        reqBO.setDivisionCode(area);
        reqBO.setItemList(itemList);
        UccTmStockBO tmStockBO = new UccTmStockBO();
        itemList.add(tmStockBO);
        ArrayList<Long> skus = new ArrayList<Long>();
        for (UccSkuPo each : skuPoList) {
            if (each.getExtSkuId().equals(commodityPo.getExtSkuId())) {
                skus.add(-1L);
                continue;
            }
            skus.add(Long.parseLong(each.getExtSkuId()));
        }
        tmStockBO.setSkuIdLists(skus);
        tmStockBO.setItemId(Long.valueOf(Long.parseLong(commodityPo.getExtSkuId())));
        HashedMap stockMap = new HashedMap();
        UccTmCommdStockQryRspBO uccTmCommdStockQryRspBO = this.uccTmCommdStockQryService.qryStock(reqBO);
        if (uccTmCommdStockQryRspBO.getItemList() == null || uccTmCommdStockQryRspBO.getItemList().size() == 0) {
            for (UccCommdQrySalePropBO uccCommdQrySalePropBO : bo) {
                uccCommdQrySalePropBO.setSoldNumber(new BigDecimal(0));
            }
            return;
        }
        if ("0000".equals(uccTmCommdStockQryRspBO.getRespCode())) {
            block3: for (UccSkuPo uccSkuPo : skuPoList) {
                for (CommdStockBO stock : uccTmCommdStockQryRspBO.getItemList()) {
                    if ("-1".equals(stock.getSkuId())) {
                        bo.get(0).setSoldNumber(new BigDecimal(stock.getRemainNum()));
                        return;
                    }
                    if (!uccSkuPo.getExtSkuId().equals(stock.getSkuId())) continue;
                    stockMap.put(uccSkuPo.getSkuId(), new BigDecimal(stock.getRemainNum()));
                    continue block3;
                }
            }
            if (!stockMap.isEmpty()) {
                for (UccCommdQrySalePropBO uccCommdQrySalePropBO : bo) {
                    uccCommdQrySalePropBO.setSoldNumber((BigDecimal)stockMap.get(uccCommdQrySalePropBO.getSkuId()));
                }
            }
        } else {
            LOGGER.error("\u67e5\u8be2\u5e93\u5b58\u5f02\u5e38\uff1a" + uccTmCommdStockQryRspBO.getRespDesc());
        }
    }
}

