/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.bo.busi.UccCommodityBaseInfoUpdateReqBO;
import com.tydic.commodity.bo.busi.UccCommodityBaseInfoUpdateRspBO;
import com.tydic.commodity.bo.busi.UccSendMessageReqBO;
import com.tydic.commodity.busi.api.UccCommodityBaseInfoUpdateBusiService;
import com.tydic.commodity.busi.api.UccSendMessageService;
import com.tydic.commodity.businessenums.BusinessRsponseEnums;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityLogMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccLabelDealMapper;
import com.tydic.commodity.dao.UccSkuLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommodityLogPO;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccLabelPO;
import com.tydic.commodity.dao.po.UccSkuLogPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.validate.ValidatorUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccCommodityBaseInfoUpdateBusiService.class)
public class UccCommodityBaseInfoUpdateBusiServiceImpl
implements UccCommodityBaseInfoUpdateBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityBaseInfoUpdateBusiServiceImpl.class);
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityLogMapper commodityLogMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private OrderSequence uccBatchSequence;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV")
    private UccSendMessageService uccSendMessageService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccLabelDealMapper uccLabelDealMapper;
    @Autowired
    private UccSkuLogMapper uccSkuLogMapper;

    public UccCommodityBaseInfoUpdateRspBO updateCommodityInfo(UccCommodityBaseInfoUpdateReqBO reqBO) {
        UccCommodityBaseInfoUpdateRspBO rspBO = new UccCommodityBaseInfoUpdateRspBO();
        try {
            ValidatorUtil.validator((Object)reqBO);
        }
        catch (BusinessException e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMsgInfo());
            return rspBO;
        }
        UccCommodityPo commodityPo = new UccCommodityPo();
        commodityPo.setCommodityId(reqBO.getCommodityId());
        commodityPo.setFreeFhipping(reqBO.getFreeShipping());
        commodityPo.setFreightPrice(reqBO.getFreightPrice());
        commodityPo.setViewOrder(reqBO.getViewOrder());
        commodityPo.setSupplierShopId(reqBO.getShopId());
        commodityPo.setCommodityName(reqBO.getCommodityName());
        commodityPo.setCommodityPhoneDetailChar(reqBO.getCommodityDetail());
        if (null != reqBO.getOrgIdIn() || reqBO.getRootOrgIdIn() != null) {
            List<SupplierShopPo> supplierShopPos;
            Long supperliId = 0L;
            supperliId = reqBO.getOrgIdIn();
            if (reqBO.getRootOrgIdIn() != null) {
                supperliId = reqBO.getRootOrgIdIn();
            }
            if (CollectionUtils.isNotEmpty(supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(supperliId))) {
                commodityPo.setSupplierShopId(supplierShopPos.get(0).getSupplierShopId());
            }
        }
        Long batchId = null;
        try {
            batchId = this.uccBatchSequence.nextId();
        }
        catch (SQLException e) {
            throw new BusinessException(BusinessRsponseEnums.SEQUENCE_ID_ERROR.code(), BusinessRsponseEnums.SEQUENCE_ID_ERROR.message());
        }
        try {
            this.uccCommodityMapper.updateCommodity(commodityPo);
            UccCommodityPo uccCommodityPo = this.uccCommodityMapper.getCommodityById(reqBO.getCommodityId());
            UccCommodityLogPO commodityLogPO = new UccCommodityLogPO();
            commodityLogPO.setBatchId(batchId);
            BeanUtils.copyProperties((Object)uccCommodityPo, (Object)commodityLogPO);
            this.commodityLogMapper.insert(commodityLogPO);
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        UccSkuPo skuPo = new UccSkuPo();
        skuPo.setCommodityId(reqBO.getCommodityId());
        List<UccSkuPo> poList = this.uccSkuMapper.qerySku(skuPo);
        for (UccSkuPo each : poList) {
            UccSkuLogPo po = new UccSkuLogPo();
            BeanUtils.copyProperties((Object)each, (Object)po);
            try {
                po.setBatchId(this.uccBatchSequence.nextId());
                this.uccSkuLogMapper.insert(po);
            }
            catch (SQLException e) {
                throw new BusinessException(BusinessRsponseEnums.SEQUENCE_ID_ERROR.code(), BusinessRsponseEnums.SEQUENCE_ID_ERROR.message());
            }
        }
        if (reqBO.getPreDeliverDay() != null) {
            skuPo.setPreDeliverDay(reqBO.getPreDeliverDay().toString());
            this.uccSkuMapper.updateSku(skuPo);
        } else {
            skuPo.setPreDeliverDay(null);
            this.uccSkuMapper.updateSkuPreDeliverDay(null, reqBO.getCommodityId());
        }
        ArrayList<Integer> labelType = new ArrayList<Integer>();
        labelType.add(1);
        labelType.add(2);
        this.uccLabelDealMapper.deleteByCommdAndType(reqBO.getCommodityId(), labelType);
        if (reqBO.getLabelType() != null) {
            UccLabelPO uccLabelPO;
            if (reqBO.getLabelType().contains(1)) {
                uccLabelPO = new UccLabelPO();
                uccLabelPO.setSupplierShopId(reqBO.getShopId());
                uccLabelPO.setCommodityId(reqBO.getCommodityId());
                uccLabelPO.setLabelType(1);
                uccLabelPO.setLabelName("\u5230\u8d27\u901a\u77e5");
                try {
                    uccLabelPO.setLabelId(this.uccBatchSequence.nextId());
                    this.uccLabelDealMapper.addLabel(uccLabelPO);
                }
                catch (SQLException e) {
                    throw new BusinessException(BusinessRsponseEnums.SEQUENCE_ID_ERROR.code(), BusinessRsponseEnums.SEQUENCE_ID_ERROR.message());
                }
            }
            if (reqBO.getLabelType().contains(2)) {
                uccLabelPO = new UccLabelPO();
                uccLabelPO.setSupplierShopId(reqBO.getShopId());
                uccLabelPO.setCommodityId(reqBO.getCommodityId());
                uccLabelPO.setLabelType(2);
                uccLabelPO.setLabelName("\u5230\u8d27\u901a4\u77e5");
                try {
                    uccLabelPO.setLabelId(this.uccBatchSequence.nextId());
                    this.uccLabelDealMapper.addLabel(uccLabelPO);
                }
                catch (SQLException e) {
                    throw new BusinessException(BusinessRsponseEnums.SEQUENCE_ID_ERROR.code(), BusinessRsponseEnums.SEQUENCE_ID_ERROR.message());
                }
            }
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("REDIS_UCC_COMMODITYCOMMDITEMQRY").append(reqBO.getCommodityId());
            this.cacheClient.delete(sb.toString());
            sb = new StringBuilder();
            sb.append("REDIS_UCC_COMMODITYLISTSABILITY").append(reqBO.getCommodityId());
            this.cacheClient.delete(sb.toString());
        }
        catch (Exception e) {
            LOGGER.error("reids \u5546\u54c1\u8be6\u60c5\u7f13\u5b58\u6e05\u9664\u5931\u8d25\uff1a" + reqBO.getCommodityId());
        }
        try {
            UccSendMessageReqBO uccSendMessageReqBO = new UccSendMessageReqBO();
            uccSendMessageReqBO.setCommodityIds((List)Lists.newArrayList((Object[])new Long[]{reqBO.getCommodityId()}));
            uccSendMessageReqBO.setOperType(Integer.valueOf(2));
            uccSendMessageReqBO.setSyncType(Integer.valueOf(0));
            uccSendMessageReqBO.setOrgIdIn(reqBO.getOrgIdIn());
            this.uccSendMessageService.dealMessage(uccSendMessageReqBO);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u53d1\u9001\u540c\u6b65\u6d88\u606f\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

