/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.bo.busi.CommodityPicDeleteReqBO;
import com.tydic.commodity.bo.busi.CommodityPicDeleteRspBO;
import com.tydic.commodity.bo.busi.UccSendMessageReqBO;
import com.tydic.commodity.busi.api.UccCommodityPicDeleteBusiService;
import com.tydic.commodity.busi.api.UccSendMessageService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.ListUtils;
import com.tydic.commodity.validate.ValidatorUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccCommodityPicDeleteBusiService.class)
public class UccCommodityPicDeleteBusiServiceImpl
implements UccCommodityPicDeleteBusiService {
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV")
    private UccSendMessageService uccSendMessageService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityPicDeleteBusiServiceImpl.class);

    public CommodityPicDeleteRspBO deleteCommodityPic(CommodityPicDeleteReqBO reqBO) {
        CommodityPicDeleteRspBO rspBO = new CommodityPicDeleteRspBO();
        try {
            ValidatorUtil.validator((Object)reqBO);
        }
        catch (BusinessException e) {
            rspBO.setRespCode("8888");
            rspBO.setRespCode(e.getMsgInfo());
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCommodityPicId())) {
            rspBO.setRespCode("8888");
            rspBO.setRespCode("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != reqBO.getOrgIdIn() || reqBO.getRootOrgIdIn() != null) {
            List<SupplierShopPo> supplierShopPos;
            Object suppper = reqBO.getOrgIdIn();
            if (reqBO.getRootOrgIdIn() != null) {
                suppper = reqBO.getRootOrgIdIn();
            }
            if (CollectionUtils.isNotEmpty(supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId((Long)suppper))) {
                reqBO.setSupplierShopId(supplierShopPos.get(0).getSupplierShopId());
            }
        }
        try {
            for (Long commodityPicId : reqBO.getCommodityPicId()) {
                this.uccCommodityPicMapper.deleteByPrimaryKey(commodityPicId, reqBO.getSupplierShopId());
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespCode("\u5220\u9664\u56fe\u7247\u5931\u8d25");
            return rspBO;
        }
        UccCommodityPicPo uccCommodityPicPo = new UccCommodityPicPo();
        uccCommodityPicPo.setCommodityPicId((Long)reqBO.getCommodityPicId().get(0));
        uccCommodityPicPo.setSupplierShopId(reqBO.getSupplierShopId());
        List<UccCommodityPicPo> uccCommodityPicPos = this.uccCommodityPicMapper.queryCommdPic(uccCommodityPicPo);
        if (CollectionUtils.isNotEmpty(uccCommodityPicPos)) {
            List commodityIds = uccCommodityPicPos.stream().map(UccCommodityPicPo::getCommodityId).collect(Collectors.toList());
            commodityIds = ListUtils.removeReapet(commodityIds);
            commodityIds = ListUtils.removeNull((List)commodityIds);
            try {
                UccSendMessageReqBO uccSendMessageReqBO = new UccSendMessageReqBO();
                uccSendMessageReqBO.setCommodityIds(commodityIds);
                uccSendMessageReqBO.setOperType(Integer.valueOf(2));
                uccSendMessageReqBO.setSyncType(Integer.valueOf(0));
                uccSendMessageReqBO.setOrgIdIn(reqBO.getOrgIdIn());
                this.uccSendMessageService.dealMessage(uccSendMessageReqBO);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u53d1\u9001\u540c\u6b65\u6d88\u606f\u5931\u8d25");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespCode("\u6210\u529f");
        return rspBO;
    }
}

