/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.atom.UccSkuUpAtomService;
import com.tydic.commodity.atom.bo.UccSkuUpReqBO;
import com.tydic.commodity.atom.bo.UccSkuUpRspBO;
import com.tydic.commodity.bo.busi.UccCommodityUpReqBO;
import com.tydic.commodity.bo.busi.UccCommodityUpRspBO;
import com.tydic.commodity.busi.api.UccCommodityUpBusiService;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.SkuPutCirEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccCommodityUpBusiService.class)
public class UccCommodityUpBusiServiceImpl
implements UccCommodityUpBusiService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuUpAtomService UccSkuUpAtomService;
    private static final String SHELF_SOURCES = "linkmall";
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityUpBusiServiceImpl.class);

    public UccCommodityUpRspBO dealCommodityUp(UccCommodityUpReqBO reqBO) {
        UccCommodityUpRspBO rspBO = new UccCommodityUpRspBO();
        String s = this.judge(reqBO);
        if (!"".equals(s)) {
            rspBO.setRespDesc(s);
            rspBO.setRespCode("8888");
            return rspBO;
        }
        List skuIds = reqBO.getSkuIds();
        for (Long skuId : skuIds) {
            try {
                UccSkuUpReqBO uccSkuUpReqBO = new UccSkuUpReqBO();
                BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuUpReqBO);
                uccSkuUpReqBO.setSkuId(skuId);
                UccSkuUpRspBO uccSkuUpRspBO = this.UccSkuUpAtomService.dealSkuUp(uccSkuUpReqBO);
                if (!"8888".equals(uccSkuUpRspBO.getRespCode())) continue;
                BeanUtils.copyProperties((Object)((Object)uccSkuUpRspBO), (Object)rspBO);
                return rspBO;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new ZTBusinessException("\u8c03\u7528\u5355\u54c1\u4e0a\u67b6\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5546\u54c1\u4e0a\u67b6\u6210\u529f");
        return rspBO;
    }

    public String judge(UccCommodityUpReqBO reqBO) {
        String s = "";
        if (reqBO != null) {
            if (reqBO.getSkuIds().size() == 0) {
                s = "\u8bf7\u9009\u62e9\u5355\u54c1";
                return s;
            }
            if (reqBO.getSupplierShopId() == null) {
                s = "\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a";
                return s;
            }
            if (!Objects.equals(SHELF_SOURCES, reqBO.getShelfSource())) {
                List skuIds = reqBO.getSkuIds();
                UccSkuPo skuPo = new UccSkuPo();
                skuPo.setSupplierShopId(reqBO.getSupplierShopId());
                for (Long skuId : skuIds) {
                    skuPo.setSkuId(skuId);
                    List<UccSkuPo> skuPos = this.uccSkuMapper.qerySku(skuPo);
                    if (skuPos.size() <= 0 || skuPos.get(0).getSkuStatus().equals(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus())) continue;
                    s = "\u5355\u54c1ID\u4e3a\uff1a" + skuId + "\u7684\u72b6\u6001\u4e0d\u4e3a\u5f85\u4e0a\u67b6";
                    return s;
                }
            }
            Map<String, String> map = null;
            if (reqBO.getUpType() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuPutCirEnum.UP_TYPE.toString())).containsKey(String.valueOf(reqBO.getUpType()))) {
                s = "\u4e0a\u67b6\u65b9\u5f0f\u9519\u8bef";
                return s;
            }
        } else {
            s = "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
            return s;
        }
        return s;
    }
}

