/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.google.common.collect.Lists;
import com.tydic.commodity.bo.busi.CheckPassAndNotPassBO;
import com.tydic.commodity.bo.busi.CommCompletenessCheckInfoBO;
import com.tydic.commodity.bo.busi.CommInfoCompletenessCheckReqBO;
import com.tydic.commodity.bo.busi.CommInfoCompletenessCheckRspBO;
import com.tydic.commodity.bo.busi.CommodityCheckNotPassBO;
import com.tydic.commodity.bo.busi.CommodityCheckPassBO;
import com.tydic.commodity.bo.busi.CommodityImageBo;
import com.tydic.commodity.bo.busi.SkuPriceBo;
import com.tydic.commodity.busi.api.UccCompletenessBusiService;
import com.tydic.commodity.businessenums.BusinessRsponseEnums;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.validate.ValidatorUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccCompletenessBusiService.class)
public class UccCompletenessCheckBusiServiceImpl
implements UccCompletenessBusiService {
    public CommInfoCompletenessCheckRspBO completenessCheck(CommInfoCompletenessCheckReqBO reviewReqBO) {
        CommInfoCompletenessCheckRspBO commInfoCompletenessCheckRspBO = new CommInfoCompletenessCheckRspBO();
        CheckPassAndNotPassBO checkPassAndNotPassBO = new CheckPassAndNotPassBO();
        ArrayList notPassCommodity = Lists.newArrayList();
        ArrayList passCommodity = Lists.newArrayList();
        for (CommCompletenessCheckInfoBO commCompletenessCheckInfoBO : reviewReqBO.getCommCompletenessCheckInfoBOS()) {
            CommodityCheckNotPassBO commodityCheckNotPassBO = new CommodityCheckNotPassBO();
            CommodityCheckPassBO commodityCheckPassBO = new CommodityCheckPassBO();
            try {
                if (StringUtils.isBlank((String)commCompletenessCheckInfoBO.getCommodityName())) {
                    throw new BusinessException("8888", "\u6807\u9898\u53c2\u6570\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((String)commCompletenessCheckInfoBO.getBrandName())) {
                    throw new BusinessException("8888", "\u54c1\u724c\u53c2\u6570\u4e3a\u7a7a");
                }
                ValidatorUtil.validator((Object)commCompletenessCheckInfoBO);
                if (!UccCompletenessCheckBusiServiceImpl.checkSpace(commCompletenessCheckInfoBO.getCommodityName())) {
                    commodityCheckNotPassBO.setCommodityIds(commCompletenessCheckInfoBO.getCommodityId());
                    commodityCheckNotPassBO.setNotPassReason("\u5546\u54c1\u540d\u79f0\u5305\u542b\u8fde\u7eed\u4e24\u4e2a\u7a7a\u683c");
                    notPassCommodity.add(commodityCheckNotPassBO);
                    continue;
                }
                this.commodityImageCheck(commCompletenessCheckInfoBO.getCommdImages());
                this.commodityPriceCheck(commCompletenessCheckInfoBO.getPrice());
            }
            catch (BusinessException e) {
                if ("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a".equals(e.getMessage()) || "\u5546\u54c1\u7c7b\u578bID\u4e0d\u80fd\u4e3a\u7a7a".equals(e.getMessage())) {
                    throw new BusinessException(e.getMsgCode(), e.getMessage());
                }
                commodityCheckNotPassBO.setCommodityIds(commCompletenessCheckInfoBO.getCommodityId());
                commodityCheckNotPassBO.setNotPassReason(e.getMsgInfo());
                notPassCommodity.add(commodityCheckNotPassBO);
                continue;
            }
            commodityCheckPassBO.setCommodityId(commCompletenessCheckInfoBO.getCommodityId());
            commodityCheckPassBO.setCommodityTypeId(commCompletenessCheckInfoBO.getCommodityTypeId());
            commodityCheckPassBO.setCommodityName(commCompletenessCheckInfoBO.getCommodityName());
            passCommodity.add(commodityCheckPassBO);
        }
        checkPassAndNotPassBO.setNotPassCommodity((List)notPassCommodity);
        checkPassAndNotPassBO.setPassCommodity((List)passCommodity);
        commInfoCompletenessCheckRspBO.setCheckPassAndNotPassBO(checkPassAndNotPassBO);
        commInfoCompletenessCheckRspBO.setRespCode("0000");
        commInfoCompletenessCheckRspBO.setRespCode("\u6210\u529f");
        return commInfoCompletenessCheckRspBO;
    }

    static boolean checkSpace(String commodityDesc) {
        String[] res = commodityDesc.split("  +");
        return res == null || res.length <= 1;
    }

    private CommInfoCompletenessCheckRspBO commodityImageCheck(List<CommodityImageBo> reqBO) {
        CommInfoCompletenessCheckRspBO commInfoCompletenessCheckRspBO = new CommInfoCompletenessCheckRspBO();
        if (CollectionUtils.isEmpty(reqBO)) {
            throw new BusinessException(BusinessRsponseEnums.PARAMETER_ERROR.code(), "\u5546\u54c1\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean flage = false;
        int picSecondaryCount = 0;
        for (CommodityImageBo commdImageBo : reqBO) {
            if (StringUtils.isBlank((String)commdImageBo.getCommodityPicUrl())) {
                throw new BusinessException("8888", "\u5546\u54c1\u56fe\u7247\u5730\u5740\u4e3a\u7a7a");
            }
            if (commdImageBo.getCommodityPicType() != null && commdImageBo.getCommodityPicType() == 1) {
                ++picSecondaryCount;
            }
            if (picSecondaryCount != true) continue;
            flage = true;
        }
        if (!flage) {
            throw new BusinessException("8888", "\u5546\u54c1\u56fe\u7247\u4e3b\u56fe\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u5f20\u4e3b\u56fe");
        }
        commInfoCompletenessCheckRspBO.setRespDesc("\u6210\u529f");
        commInfoCompletenessCheckRspBO.setRespCode("0000");
        return commInfoCompletenessCheckRspBO;
    }

    private CommInfoCompletenessCheckRspBO commodityPriceCheck(SkuPriceBo skuInfoPriceBo) {
        CommInfoCompletenessCheckRspBO commInfoCompletenessCheckRspBO = new CommInfoCompletenessCheckRspBO();
        if (null == skuInfoPriceBo.getAgreementPrice()) {
            throw new BusinessException("8888", "\u5546\u54c1\u534f\u8bae\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == skuInfoPriceBo.getMarketPrice()) {
            throw new BusinessException("8888", "\u5546\u54c1\u5e02\u573a\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == skuInfoPriceBo.getSalePrice()) {
            throw new BusinessException("8888", "\u5546\u54c1\u9500\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        commInfoCompletenessCheckRspBO.setRespDesc("\u6210\u529f");
        commInfoCompletenessCheckRspBO.setRespCode("0000");
        return commInfoCompletenessCheckRspBO;
    }
}

