/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.UccExecuteEcommerceMsgReqBo;
import com.tydic.commodity.bo.busi.UccExecuteEcommerceMsgRspBo;
import com.tydic.commodity.busi.api.UccExecuteEcommerceMsgService;
import com.tydic.commodity.config.vo.CommdProPertiesVo;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.XextSkuChangeMapper;
import com.tydic.commodity.dao.po.SupplierBusiPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.XextSkuChangePo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.bo.UccBusiQryMsgReqBO;
import com.tydic.commodity.external.bo.UccBusiQryMsgRspBO;
import com.tydic.commodity.external.service.UccQryMsgFromInterService;
import com.tydic.commodity.external.vo.ResultVO;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccExecuteEcommerceMsgService.class)
public class UccExecuteEcommerceMsgServiceImpl
implements UccExecuteEcommerceMsgService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccExecuteEcommerceMsgServiceImpl.class);
    @Autowired
    private UccQryMsgFromInterService uccQryMsgFromInterService;
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private XextSkuChangeMapper xextSkuChangeMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private CommdProPertiesVo commdProPertiesVo;
    @Autowired
    private OrderSequence uccExtSkuSequence;

    public UccExecuteEcommerceMsgRspBo executeMsg(UccExecuteEcommerceMsgReqBo reqBo) {
        UccExecuteEcommerceMsgRspBo rspBo = new UccExecuteEcommerceMsgRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (reqBo.getMsgType() == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u4f20\u5165\u6d88\u606f\u7c7b\u578b");
            return rspBo;
        }
        SupplierShopPo supplierShop = this.supplierShopMapper.queryPoBySupplierShopId(reqBo.getSupplierShopId());
        if (supplierShop == null) {
            LOGGER.error("\u65e0\u5e97\u94fa\u4fe1\u606f\uff1a" + reqBo.getSupplierShopId());
            rspBo.setRespDesc("8888");
            rspBo.setRespCode("\u65e0\u5e97\u94fa\u4fe1\u606f\uff1a" + reqBo.getSupplierShopId());
            return rspBo;
        }
        SupplierBusiPo po = new SupplierBusiPo();
        po.setSupplierId(supplierShop.getSupplierId());
        po.setSupplierName(supplierShop.getSupplierName());
        List<SupplierBusiPo> suppliers = this.supplierMapper.querySupplierDetails(po, (Page<SupplierBusiPo>)new Page(-1, 100));
        if (suppliers == null || suppliers.size() == 0) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u65e0\u4f9b\u5e94\u5546\u4fe1\u606f" + reqBo.getSupplierShopId());
            LOGGER.error("\u65e0\u4f9b\u5e94\u5546\u4fe1\u606f\uff1a" + reqBo.getSupplierShopId());
            return rspBo;
        }
        UccBusiQryMsgReqBO uccBusiQryMsgReqBO = null;
        for (SupplierBusiPo each : suppliers) {
            uccBusiQryMsgReqBO = new UccBusiQryMsgReqBO();
            uccBusiQryMsgReqBO.setSupplierCode(each.getSupplierCode());
            uccBusiQryMsgReqBO.setSupplierId(each.getSupplierId());
            uccBusiQryMsgReqBO.setType(reqBo.getMsgType());
            UccBusiQryMsgRspBO msgRspBO = this.uccQryMsgFromInterService.qryMsg(uccBusiQryMsgReqBO);
            XextSkuChangePo xextSkuChangePo = null;
            if ("0000".equals(msgRspBO.getRespCode())) {
                if (msgRspBO.isSuccess()) {
                    if (msgRspBO.getResult() == null || msgRspBO.getResult().size() <= 0) continue;
                    for (ResultVO resultEach : msgRspBO.getResult()) {
                        xextSkuChangePo = this.xextSkuChangeMapper.queryPoByMsgGetId(resultEach.getId(), supplierShop.getSupplierShopId());
                        if (xextSkuChangePo != null) {
                            LOGGER.info("msgId = " + resultEach.getId() + "\u5df2\u7ecf\u5b58\u5728; \u4e0d\u5165\u5e93\u5b58");
                            continue;
                        }
                        xextSkuChangePo = new XextSkuChangePo();
                        xextSkuChangePo.setExtSkuId(resultEach.getResult().getSkuId());
                        xextSkuChangePo.setId(this.getSequence());
                        xextSkuChangePo.setIsDelete(ModelRuleConstant.EXT_SKU_MESSAGE_IS_DELETE_NO);
                        xextSkuChangePo.setSupplierShopId(supplierShop.getSupplierShopId());
                        xextSkuChangePo.setSupplierId(each.getSupplierId());
                        try {
                            xextSkuChangePo.setMsgGetTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(resultEach.getTime()));
                        }
                        catch (ParseException e) {
                            LOGGER.error("\u65b0\u589e\u6d88\u606f\uff0c\u65f6\u95f4\u683c\u5f0f\u5316\u5931\u8d25", (Throwable)e);
                        }
                        xextSkuChangePo.setMsgGetType(resultEach.getType().intValue());
                        xextSkuChangePo.setExtSkuState(ModelRuleConstant.EXT_SKU_STATE_NOT_PROCESSED);
                        xextSkuChangePo.setMsgGetId(resultEach.getId());
                        xextSkuChangePo.setSkuPoolState(resultEach.getResult().getState());
                        try {
                            this.xextSkuChangeMapper.insertMsg(xextSkuChangePo);
                        }
                        catch (Exception e) {
                            LOGGER.error("\u65b0\u589e\u6d88\u606f\u5931\u8d25:" + e.getMessage());
                            throw new BusinessException("COMMEREE_MSG_ADD", "\u65b0\u589e\u6d88\u606f\u5931\u8d25:" + e.getMessage());
                        }
                    }
                    continue;
                }
                rspBo.setRespCode("8888");
                rspBo.setRespDesc(msgRspBO.getResultMessage());
                continue;
            }
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(msgRspBO.getResultMessage());
            return rspBo;
        }
        return rspBo;
    }

    public Long getSequence() throws ZTBusinessException {
        try {
            return this.uccExtSkuSequence.nextId();
        }
        catch (SQLException e) {
            throw new ZTBusinessException("\u83b7\u53d6\u6d88\u606f\u5e8f\u5217\u5f02\u5e38");
        }
    }
}

