/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.bo.busi.BatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.bo.busi.CommodityBo;
import com.tydic.commodity.bo.busi.UccMarketLowerShelfReqBO;
import com.tydic.commodity.bo.busi.UccMarketLowerShelfRspBO;
import com.tydic.commodity.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.busi.api.UccMarketLowerShelfBusiService;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.enumType.AuditResultStatusEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.validate.ValidatorUtil;
import com.tydic.uac.ability.UacNoTaskAuditOrderSyncAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderSyncReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderSyncRspBO;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccMarketLowerShelfBusiService.class)
public class UccMarketLowerShelfBusiServiceImpl
implements UccMarketLowerShelfBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMarketLowerShelfBusiServiceImpl.class);
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV")
    private BatchUpdateCommoStatusForMarketService batchUpdateCommoStatusForMarketService;
    @Autowired
    private UacNoTaskAuditOrderSyncAbilityService uocAuditOrderSyncAbilityService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;

    public UccMarketLowerShelfRspBO marketLowerShelf(UccMarketLowerShelfReqBO reqBO) {
        UccMarketLowerShelfRspBO uccMarketLowerShelfRspBO = new UccMarketLowerShelfRspBO();
        try {
            ValidatorUtil.validator((Object)reqBO);
        }
        catch (BusinessException e) {
            uccMarketLowerShelfRspBO.setRespCode("8888");
            uccMarketLowerShelfRspBO.setRespDesc(e.getMsgInfo());
            return uccMarketLowerShelfRspBO;
        }
        if (reqBO.getBusinessId() == null || reqBO.getBusinessId().length < 1) {
            uccMarketLowerShelfRspBO.setRespCode("8888");
            uccMarketLowerShelfRspBO.setRespDesc("\u4e1a\u52a1ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return uccMarketLowerShelfRspBO;
        }
        if (reqBO.getUserId() == null) {
            uccMarketLowerShelfRspBO.setRespCode("8888");
            uccMarketLowerShelfRspBO.setRespDesc("\u64cd\u4f5c\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
            return uccMarketLowerShelfRspBO;
        }
        UacNoTaskAuditOrderSyncReqBO uocAuditOrderSyncReqBO = new UacNoTaskAuditOrderSyncReqBO();
        uocAuditOrderSyncReqBO.setObjType(Integer.valueOf(2));
        uocAuditOrderSyncReqBO.setAuditAdvice(reqBO.getReason());
        uocAuditOrderSyncReqBO.setDownload(reqBO.getAnnexFileUrl());
        uocAuditOrderSyncReqBO.setStepId(ApprovalTypeEnum.APPROVAL_DOWN_SHELF.getStep());
        uocAuditOrderSyncReqBO.setStepName(ApprovalTypeEnum.APPROVAL_DOWN_SHELF.code());
        uocAuditOrderSyncReqBO.setStepDesc(ApprovalTypeEnum.APPROVAL_DOWN_SHELF.getMessage());
        uocAuditOrderSyncReqBO.setOperid(reqBO.getUsername());
        uocAuditOrderSyncReqBO.setObjId(Arrays.asList(reqBO.getBusinessId()).stream().map(a -> String.valueOf(a)).collect(Collectors.toList()));
        HashMap<String, String> ext = new HashMap<String, String>();
        ext.put("dealStepName", "\u4e0b\u67b6");
        uocAuditOrderSyncReqBO.setExt(ext);
        UacNoTaskAuditOrderSyncRspBO uocAuditOrderSyncBusiRspBO = this.uocAuditOrderSyncAbilityService.dealAuditOrderSync(uocAuditOrderSyncReqBO);
        if ("0000".equals(uocAuditOrderSyncBusiRspBO.getRespCode())) {
            try {
                this.batchUpdateCommoStatusForMarketService.batchUpdateCommoStatusForMarket((BatchUpdateCommoStatusForMarketBO)reqBO, null, SkuStatusEnum.DOWN_FRAME_STATUS);
            }
            catch (BusinessException e) {
                LOGGER.error("\u5546\u54c1\u4e2d\u5fc3\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + e.getMsgInfo());
                throw new BusinessException(e.getMsgCode(), e.getMsgInfo());
            }
        }
        for (int i = 0; i < reqBO.getBusinessId().length; ++i) {
            CommodityBo commodityBo = new CommodityBo();
            UccCommodityPo uccCommodityPo = this.uccCommodityMapper.getCommodityById(reqBO.getBusinessId()[i]);
            BeanUtils.copyProperties((Object)uccCommodityPo, (Object)commodityBo);
            commodityBo.setApprovalStatus("0");
            this.batchUpdateCommoStatusForMarketService.updateCommoApprovalStatus(commodityBo, AuditResultStatusEnum.Audit_Down_Shelf);
        }
        uccMarketLowerShelfRspBO.setRespCode("0000");
        uccMarketLowerShelfRspBO.setRespDesc("\u6210\u529f");
        return uccMarketLowerShelfRspBO;
    }
}

