/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.bo.busi.UccModifyDownReasonReqBO;
import com.tydic.commodity.bo.busi.UccModifyDownReasonRspBO;
import com.tydic.commodity.bo.busi.UccSendMessageReqBO;
import com.tydic.commodity.busi.api.UccModifyDownReasonBusiService;
import com.tydic.commodity.busi.api.UccSendMessageService;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccModifyDownReasonBusiService.class)
public class UccModifyDownReasonBusiServiceImpl
implements UccModifyDownReasonBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccModifyDownReasonBusiServiceImpl.class);
    @Autowired
    private UccCommodityMapper commodityMapper;
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV")
    private UccSendMessageService uccSendMessageService;

    public UccModifyDownReasonRspBO modifyReason(UccModifyDownReasonReqBO reqBO) {
        UccModifyDownReasonRspBO rspBO = new UccModifyDownReasonRspBO();
        for (Long aLong : reqBO.getCommodityIds()) {
            UccCommodityPo uccCommodityPo = new UccCommodityPo();
            UccCommodityPo commodityPo = this.commodityMapper.getCommodityById(aLong);
            uccCommodityPo.setRemark(reqBO.getRemark());
            uccCommodityPo.setCommodityId(aLong);
            if (commodityPo != null) {
                uccCommodityPo.setSupplierShopId(commodityPo.getSupplierShopId());
            }
            try {
                this.commodityMapper.updateCommodity(uccCommodityPo);
            }
            catch (Exception e) {
                LOGGER.error("\u4fee\u6539\u5546\u54c1\u4e0b\u67b6\u539f\u56e0\u5931\u8d25,commodityId:" + aLong, (Throwable)e);
            }
        }
        try {
            UccSendMessageReqBO uccSendMessageReqBO = new UccSendMessageReqBO();
            uccSendMessageReqBO.setOperType(Integer.valueOf(2));
            uccSendMessageReqBO.setSyncType(Integer.valueOf(0));
            uccSendMessageReqBO.setCommodityIds(reqBO.getCommodityIds());
            uccSendMessageReqBO.setOrgIdIn(reqBO.getOrgIdIn());
            this.uccSendMessageService.dealMessage(uccSendMessageReqBO);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u53d1\u9001\u540c\u6b65\u6d88\u606f\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

