/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.commodity.bo.busi.UccOssUploadFileRspBO;
import com.tydic.commodity.bo.busi.UccOssUploadFileServiceReqBO;
import com.tydic.commodity.busi.api.UccOssUploadFileService;
import com.tydic.commodity.util.Base64;
import com.tydic.commodity.util.Utils;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.multipart.MultipartFile;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccOssUploadFileService.class)
public class UccOssUploadFileServiceImpl
implements UccOssUploadFileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccOssUploadFileServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${oss.fileUrl}")
    private String fileUrl;
    private static String filedir = "ucc/";

    public UccOssUploadFileRspBO uploadFile(UccOssUploadFileServiceReqBO ossUploadFileReqBO) {
        String originalFilename;
        MultipartFile file = Base64.base64ToMultipart((String)ossUploadFileReqBO.getBase64Img());
        String fileId = Utils.get16UUID();
        String fileSuffix = Utils.getFileSuffix((String)file.getOriginalFilename());
        fileSuffix = StringUtils.lowerCase((String)fileSuffix);
        String ossKey = null;
        UccOssUploadFileRspBO uccOssUploadFileRspBO = new UccOssUploadFileRspBO();
        try {
            ossKey = filedir + file.getOriginalFilename();
            originalFilename = file.getOriginalFilename();
            this.fileClient.uploadFileByInputStream(filedir, originalFilename, file.getInputStream());
        }
        catch (OSSException oe) {
            LOGGER.info("\u4e0a\u4f20oss\u670d\u52a1\u5f02\u5e38\uff0c\u4e1a\u52a1ID:{}" + ossUploadFileReqBO.getBusinessId());
            uccOssUploadFileRspBO.setRespCode("8888");
            uccOssUploadFileRspBO.setRespDesc("\u5931\u8d25");
            return uccOssUploadFileRspBO;
        }
        catch (ClientException ce) {
            LOGGER.info("\u4e0a\u4f20oss\u5ba2\u6237\u7aef\u8fde\u63a5\u670d\u52a1\u5f02\u5e38\uff0c\u4e1a\u52a1ID:{}" + ossUploadFileReqBO.getBusinessId());
            uccOssUploadFileRspBO.setRespCode("8888");
            uccOssUploadFileRspBO.setRespDesc("\u5931\u8d25");
            return uccOssUploadFileRspBO;
        }
        catch (Exception e) {
            LOGGER.info("\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5f02\u5e38\uff0c\u4e1a\u52a1ID:{}" + ossUploadFileReqBO.getBusinessId(), (Throwable)e);
            uccOssUploadFileRspBO.setRespCode("8888");
            uccOssUploadFileRspBO.setRespDesc("\u5931\u8d25");
            return uccOssUploadFileRspBO;
        }
        if (StringUtils.isEmpty((String)this.fileUrl)) {
            uccOssUploadFileRspBO.setRetUrl(this.getUrl(this.accessUrl + "/" + filedir + originalFilename));
        } else {
            uccOssUploadFileRspBO.setRetUrl(this.getUrl(this.fileUrl + "/" + filedir + originalFilename));
        }
        uccOssUploadFileRspBO.setOssKey(originalFilename);
        uccOssUploadFileRspBO.setBusinessId(ossUploadFileReqBO.getBusinessId());
        uccOssUploadFileRspBO.setFileName(originalFilename);
        uccOssUploadFileRspBO.setFileSize(Integer.valueOf(Integer.parseInt(String.valueOf(file.getSize() / 1024L))));
        uccOssUploadFileRspBO.setFileType(file.getContentType());
        uccOssUploadFileRspBO.setCreateOperId(ossUploadFileReqBO.getCreateOperId());
        uccOssUploadFileRspBO.setCreateTime(new Date());
        uccOssUploadFileRspBO.setRespCode("0000");
        uccOssUploadFileRspBO.setRespDesc("\u6210\u529f");
        return uccOssUploadFileRspBO;
    }

    public String getUrl(String key) {
        return UccOssUploadFileServiceImpl.splitUrl(key);
    }

    public static String splitUrl(String url) {
        if (url.indexOf("?Expires") != -1) {
            return url.split("Expires")[0].substring(0, url.split("Expires")[0].length() - 1);
        }
        return url;
    }
}

