/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.commodity.bo.busi.SkuPriceBo;
import com.tydic.commodity.bo.busi.SkuPriceChangeBO;
import com.tydic.commodity.bo.busi.UccPriChangeReqBO;
import com.tydic.commodity.bo.busi.UccPriChangeRspBO;
import com.tydic.commodity.bo.busi.UccSkuAdjustPriceReqBO;
import com.tydic.commodity.busi.api.QueryDBDateBusiService;
import com.tydic.commodity.busi.api.UccPriChangeBusiService;
import com.tydic.commodity.busi.api.UccSkuAdjustPriceBusiService;
import com.tydic.commodity.dao.ECommercePriceChangeLogMapper;
import com.tydic.commodity.dao.ECommercePriceChangeMapper;
import com.tydic.commodity.dao.UccAddCoefficientMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceLogMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.po.ECommercePriceChangeLogPO;
import com.tydic.commodity.dao.po.ECommercePriceChangePO;
import com.tydic.commodity.dao.po.UccAddCoefficientPO;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.enumType.UnitPrice;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccPriChangeBusiService.class)
public class UccPriChangeBusiServiceImpl
implements UccPriChangeBusiService {
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuPriceLogMapper uccSkuPriceLogMapper;
    @Autowired
    private UccAddCoefficientMapper uccAddCoefficientMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccPriChangeBusiServiceImpl.class);
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV")
    private UccSkuAdjustPriceBusiService uccSkuAdjustPriceBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private ECommercePriceChangeMapper eCommercePriceChangeMapper;
    @Autowired
    private ECommercePriceChangeLogMapper eCommercePriceChangeLogMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private OrderSequence coefficientSequence;
    private static final BigDecimal yuanToMilli = new BigDecimal(10000);
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    public UccPriChangeRspBO changePrice(UccPriChangeReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSkuPriceInfos() == null) {
            throw new BusinessException("8888", "\u4ef7\u683c\u53d8\u66f4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSupplierShopId() == null) {
            throw new BusinessException("8888", "\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<ECommercePriceChangePO> eCommercePriceChangePOList = new ArrayList<ECommercePriceChangePO>();
        ArrayList<ECommercePriceChangeLogPO> eCommercePriceChangeLogPOS = new ArrayList<ECommercePriceChangeLogPO>();
        ArrayList skuPriceVOList = new ArrayList();
        for (SkuPriceChangeBO skuPriceChangeBO : reqBO.getSkuPriceInfos()) {
            UccCommodityTypePo uccCommodityTypePo;
            if (skuPriceChangeBO.getSkuId() == null || skuPriceChangeBO.getPrice() == null || skuPriceChangeBO.getMarketPrice() == null) continue;
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setExtSkuId(skuPriceChangeBO.getSkuId());
            uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
            List<UccSkuPo> uccSkuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
            if (uccSkuPoList == null || uccSkuPoList.size() != 1) continue;
            UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
            uccSkuPricePo.setSkuId(uccSkuPoList.get(0).getSkuId());
            uccSkuPricePo.setSupplierShopId(reqBO.getSupplierShopId());
            uccSkuPricePo.setCurrencyType(null);
            if ((uccSkuPricePo = this.uccSkuPriceMapper.querySkuPrice(uccSkuPricePo)) == null || (uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(uccSkuPoList.get(0).getCommodityTypeId())) == null) continue;
            Long catalogId = uccCommodityTypePo.getCatalogId();
            UccAddCoefficientPO uccAddCoefficientPO = this.uccAddCoefficientMapper.qryAddCoefficientByCatalogId(catalogId);
            BigDecimal addCoefficient = new BigDecimal(0);
            Integer allowMarketPrice = 0;
            if (uccAddCoefficientPO != null) {
                if (uccAddCoefficientPO.getAddCoefficient() != null) {
                    addCoefficient = uccAddCoefficientPO.getAddCoefficient();
                    addCoefficient = addCoefficient.divide(new BigDecimal(100), 4, 5);
                }
                if (uccAddCoefficientPO.getAllowMarketPrice() != null) {
                    allowMarketPrice = uccAddCoefficientPO.getAllowMarketPrice();
                }
            }
            BigDecimal salePrice = skuPriceChangeBO.getPrice().multiply(addCoefficient.add(new BigDecimal(1)));
            if (allowMarketPrice == 0 && salePrice.compareTo(skuPriceChangeBO.getMarketPrice()) > 0) {
                salePrice = skuPriceChangeBO.getMarketPrice();
            }
            salePrice = salePrice.setScale(2, 0);
            int result1 = salePrice.multiply(UnitPrice.ten_thousand.getCode()).compareTo(new BigDecimal(uccSkuPricePo.getSalePrice()));
            int result = skuPriceChangeBO.getPrice().multiply(UnitPrice.ten_thousand.getCode()).compareTo(new BigDecimal(uccSkuPricePo.getAgreementPrice()));
            if (result == 0 && result1 == 0) continue;
            UccSkuAdjustPriceReqBO uccSkuAdjustPriceReqBO = new UccSkuAdjustPriceReqBO();
            uccSkuAdjustPriceReqBO.setSkuId(uccSkuPoList.get(0).getSkuId());
            uccSkuAdjustPriceReqBO.setSupplierShopId(uccSkuPoList.get(0).getSupplierShopId());
            SkuPriceBo skuPriceBo = new SkuPriceBo();
            uccSkuAdjustPriceReqBO.setUpdateSkuPriceInfo(skuPriceBo);
            skuPriceBo.setSalePrice(Long.valueOf(salePrice.multiply(UnitPrice.ten_thousand.getCode()).longValue()));
            skuPriceBo.setAgreementPrice(Long.valueOf(skuPriceChangeBO.getPrice().multiply(UnitPrice.ten_thousand.getCode()).longValue()));
            if (skuPriceChangeBO.getMarketPrice() != null) {
                skuPriceBo.setMarketPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)skuPriceChangeBO.getMarketPrice())));
            }
            try {
                this.uccSkuAdjustPriceBusiService.dealSkuAdjustPrice(uccSkuAdjustPriceReqBO);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            ECommercePriceChangePO eCommercePriceChangePO = new ECommercePriceChangePO();
            eCommercePriceChangePO.setSkuId(uccSkuPoList.get(0).getSkuId());
            eCommercePriceChangePO.setSupplierShopId(uccSkuPoList.get(0).getSupplierShopId());
            List<ECommercePriceChangePO> eCommercePriceChangePOS = this.eCommercePriceChangeMapper.qryECommercePriceChange(eCommercePriceChangePO);
            Date nowDate = this.queryDBDateBusiService.getDBDate();
            Calendar time = Calendar.getInstance();
            time.setTime(uccSkuPoList.get(0).getOnShelveTime());
            time.add(1, 1);
            Date onShelveTime = time.getTime();
            Date updateTime = null;
            if (nowDate.compareTo(onShelveTime) > 0) {
                time.setTime(nowDate);
                time.set(2, 4);
                time.set(5, 31);
                Date compareTime = time.getTime();
                time = Calendar.getInstance();
                time.setTime(nowDate);
                time.add(1, -1);
                if (nowDate.compareTo(compareTime) > 0) {
                    time.set(2, 5);
                    time.set(5, 1);
                } else {
                    time.set(2, 0);
                    time.set(5, 1);
                }
                updateTime = time.getTime();
            }
            ECommercePriceChangeLogPO eCommercePriceChangeLogHistory = new ECommercePriceChangeLogPO();
            eCommercePriceChangeLogHistory.setSkuId(uccSkuPoList.get(0).getSkuId());
            eCommercePriceChangeLogHistory.setSupplierShopId(uccSkuPoList.get(0).getSupplierShopId());
            eCommercePriceChangeLogHistory.setUpdateTime(updateTime);
            eCommercePriceChangeLogHistory = this.eCommercePriceChangeLogMapper.queryCount(eCommercePriceChangeLogHistory);
            if (eCommercePriceChangeLogHistory == null) continue;
            eCommercePriceChangePO.setFrequency(eCommercePriceChangeLogHistory.getFrequency());
            eCommercePriceChangePO.setAveragePrice(eCommercePriceChangeLogHistory.getAveragePrice());
            eCommercePriceChangePO.setExtSkuId(uccSkuPoList.get(0).getExtSkuId());
            eCommercePriceChangePO.setFrequency(eCommercePriceChangeLogHistory.getFrequency());
            eCommercePriceChangePO.setPrice(salePrice);
            if (eCommercePriceChangePO.getAveragePrice() != null) {
                eCommercePriceChangePO.setFloatingRate(salePrice.divide(eCommercePriceChangePO.getAveragePrice(), 2, 0));
            }
            try {
                eCommercePriceChangePO.setId(this.coefficientSequence.nextId());
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            if (eCommercePriceChangePOS == null || eCommercePriceChangePOS.size() == 0) {
                eCommercePriceChangePOList.add(eCommercePriceChangePO);
            } else {
                this.eCommercePriceChangeMapper.modifyECommercePriceChange(eCommercePriceChangePO);
            }
            ECommercePriceChangeLogPO eCommercePriceChangeLogPO = new ECommercePriceChangeLogPO();
            try {
                eCommercePriceChangeLogPO.setBatchId(this.coefficientSequence.nextId());
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            BeanUtils.copyProperties((Object)eCommercePriceChangePO, (Object)eCommercePriceChangeLogPO);
            eCommercePriceChangeLogPO.setOnShelveTime(uccSkuPoList.get(0).getOnShelveTime());
            eCommercePriceChangeLogPOS.add(eCommercePriceChangeLogPO);
        }
        if (eCommercePriceChangePOList.size() > 0) {
            this.eCommercePriceChangeMapper.insertPriceChange(eCommercePriceChangePOList);
        }
        if (eCommercePriceChangeLogPOS.size() > 0) {
            this.eCommercePriceChangeLogMapper.insertECommercePriceChangeLogs(eCommercePriceChangeLogPOS);
        }
        UccPriChangeRspBO rspBO = new UccPriChangeRspBO();
        rspBO.setSkuPriceVOList(skuPriceVOList);
        rspBO.setRespDesc("\u8c03\u4ef7\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

