/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.atom.UccQryCommdDetailAtomService;
import com.tydic.commodity.atom.UccQrySkuInfoAtomService;
import com.tydic.commodity.atom.bo.UccQryCommdDetailReqBO;
import com.tydic.commodity.atom.bo.UccQryCommdDetailRspBO;
import com.tydic.commodity.atom.bo.UccQrySkuDetailReqBO;
import com.tydic.commodity.atom.bo.UccQrySkuDetailRspBO;
import com.tydic.commodity.bo.ability.PropEntityBo;
import com.tydic.commodity.bo.ability.PropEntityValue;
import com.tydic.commodity.bo.ability.SpecBo;
import com.tydic.commodity.bo.busi.CommodityBo;
import com.tydic.commodity.bo.busi.SkuBo;
import com.tydic.commodity.bo.busi.SpuSpecBo;
import com.tydic.commodity.busi.api.UccQryCommodityDetailBusiService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccBrandDealPO;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccCommodityPropGrpPo;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.CommodityEnum;
import com.tydic.commodity.enumType.SkuEnum;
import com.tydic.commodity.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccQryCommodityDetailBusiService.class)
public class UccQryCommodityDetailBusiServiceImpl
implements UccQryCommodityDetailBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQryCommodityDetailBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccQrySkuInfoAtomService uccQrySkuInfoAtomService;
    @Autowired
    private UccQryCommdDetailAtomService uccQryCommdDetailAtomService;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;

    public com.tydic.commodity.bo.busi.UccQryCommdDetailRspBO qryCommodityDetail(com.tydic.commodity.bo.busi.UccQryCommdDetailReqBO reqBO) {
        SupplierShopPo supplierShopPo;
        com.tydic.commodity.bo.busi.UccQryCommdDetailRspBO rspBO = new com.tydic.commodity.bo.busi.UccQryCommdDetailRspBO();
        String errMsg = this.verify(reqBO);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(errMsg);
            return rspBO;
        }
        UccSkuPo qryCommd = new UccSkuPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)qryCommd);
        List<UccSkuPo> listSku = this.uccSkuMapper.qerySku(qryCommd);
        if (listSku == null || listSku.size() == 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        reqBO.setCommodityId(listSku.get(0).getCommodityId());
        UccCommodityPo commdPo = this.uccCommodityMapper.qryCommdByCommdId(reqBO.getCommodityId(), reqBO.getSupplierShopId());
        if (commdPo == null) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        CommodityBo commodityBo = new CommodityBo();
        BeanUtils.copyProperties((Object)commdPo, (Object)commodityBo);
        UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(commdPo.getCommodityTypeId());
        if (uccCommodityTypePo != null) {
            commodityBo.setCommodityTypeName(uccCommodityTypePo.getCommodityTypeName());
        }
        if ((supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(reqBO.getSupplierShopId())) != null) {
            commodityBo.setShopName(supplierShopPo.getShopName());
        }
        UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
        uccBrandDealPO.setBrandId(commodityBo.getBrandId());
        uccBrandDealPO = this.uccBrandDealMapper.selectById(uccBrandDealPO);
        if (uccBrandDealPO != null) {
            commodityBo.setBrandName(uccBrandDealPO.getBrandName());
        }
        if (commdPo.getCreateTime() != null) {
            commodityBo.setCreateTime(DateUtils.dateToStr((Date)commdPo.getCreateTime()));
        }
        if (commdPo.getUpdateTime() != null) {
            commodityBo.setUpdateTime(DateUtils.dateToStr((Date)commdPo.getUpdateTime()));
        }
        DicDictionaryPo po = null;
        if (commdPo.getCommodityStatus() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(commdPo.getCommodityStatus().toString(), CommodityEnum.COMMODITY_STATUS.toString())) != null) {
            commodityBo.setCommodityStatusDesc(po.getTitle());
            po = null;
        }
        if (commdPo.getCommoditySource() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(commdPo.getCommoditySource().toString(), CommodityEnum.COMMODITY_SOURCE.toString())) != null) {
            commodityBo.setCommoditySourceDesc(po.getTitle());
            po = null;
        }
        if (commdPo.getStoreGetType() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(commdPo.getStoreGetType().toString(), CommodityEnum.COMMODITY_STORE_GET_TYPE.toString())) != null) {
            commodityBo.setStoreGetTypeDesc(po.getTitle());
            po = null;
        }
        if (commdPo.getServenRejectAllow() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(commdPo.getServenRejectAllow().toString(), CommodityEnum.COMMODITY_SERVEN_REJECT_ALLOW.toString())) != null) {
            commodityBo.setServenRejectAllowDesc(po.getTitle());
            po = null;
        }
        UccQryCommdDetailReqBO atomCommdReqBo = new UccQryCommdDetailReqBO();
        BeanUtils.copyProperties((Object)commdPo, (Object)atomCommdReqBo);
        UccQryCommdDetailRspBO atomCommdRspBo = this.uccQryCommdDetailAtomService.queryInfomation(atomCommdReqBo);
        if (atomCommdRspBo != null) {
            if (atomCommdRspBo.getCommdImageInfo() != null && atomCommdRspBo.getCommdImageInfo().size() > 0) {
                commodityBo.setCommdImages(atomCommdRspBo.getCommdImageInfo());
            }
            if (atomCommdRspBo.getCommdSpecInfo() != null && atomCommdRspBo.getCommdSpecInfo().size() > 0) {
                commodityBo.setSpuSpecInfoList(atomCommdRspBo.getCommdSpecInfo());
                this.formatSpec(atomCommdRspBo.getCommdSpecInfo(), commodityBo);
            }
            if (atomCommdRspBo.getCommodPageckeInfo() != null) {
                commodityBo.setCommodityPackageInfo(atomCommdRspBo.getCommodPageckeInfo());
            }
            if (atomCommdRspBo.getSaleParaInfo() != null && atomCommdRspBo.getSaleParaInfo().size() > 0) {
                commodityBo.setSaleParamEntityList(atomCommdRspBo.getSaleParaInfo());
            }
        }
        if (!StringUtils.isEmpty((Object)reqBO.getSaleParams()) && reqBO.getSkuId() == null) {
            JSONObject keyParas = null;
            try {
                keyParas = JSONObject.parseObject((String)reqBO.getSaleParams());
            }
            catch (JSONException e) {
                LOGGER.error("can not cast to JSONObject");
                throw new ZTBusinessException("can not cast to JSONObject");
            }
            if (!keyParas.isEmpty()) {
                Set keys = keyParas.entrySet();
                List<Long> skuIds = null;
                for (Map.Entry each : keys) {
                    skuIds = this.filterSkuId(reqBO.getCommodityId(), Long.parseLong((String)each.getKey()), Long.parseLong(each.getValue().toString()), reqBO.getSupplierShopId(), skuIds);
                    if (skuIds != null && skuIds.size() != 0) continue;
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5355\u54c1\u4fe1\u606f");
                    return rspBO;
                }
                if (skuIds.size() > 1) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5c5e\u6027\u4fe1\u606f\u6216\u5219\u5546\u54c1\u521b\u5efa\u4fe1\u606f\u9519\u8bef\u8bf7\u68c0\u67e5\u5546\u54c1\u4fe1\u606f\u662f\u5426\u6b63\u786e\uff01\uff01");
                    return rspBO;
                }
                reqBO.setSkuId((Long)skuIds.get(0));
            }
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuPo);
        List<UccSkuPo> listSkuInfo = this.uccSkuMapper.qerySku(uccSkuPo);
        ArrayList<SkuBo> listBo = new ArrayList<SkuBo>();
        SkuBo bo = null;
        UccQrySkuDetailReqBO uccQrySkuDetailReqBO = new UccQrySkuDetailReqBO();
        if (listSkuInfo != null && listSkuInfo.size() > 0) {
            for (UccSkuPo each : listSkuInfo) {
                UccQrySkuDetailRspBO skuDetail;
                bo = new SkuBo();
                uccQrySkuDetailReqBO.setSkuId(each.getSkuId());
                uccQrySkuDetailReqBO.setSupplierShopId(each.getSupplierShopId());
                BeanUtils.copyProperties((Object)each, (Object)bo);
                bo.setBrandName(commodityBo.getBrandName());
                bo.setShopName(commodityBo.getShopName());
                if (each.getSkuStatus() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getSkuStatus().toString(), SkuEnum.SKU_STATUS.toString())) != null) {
                    bo.setSkuStatusDesc(po.getTitle());
                    po = null;
                }
                if (each.getSkuSource() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getSkuSource().toString(), SkuEnum.SKU_SOURCE.toString())) != null) {
                    bo.setSkuSourceDesc(po.getTitle());
                    po = null;
                }
                if (each.getOnShelveWay() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getOnShelveWay().toString(), SkuEnum.SKU_SOURCE.toString())) != null) {
                    bo.setOnShelveWayDec(po.getTitle());
                    po = null;
                }
                if (each.getCreateTime() != null) {
                    bo.setCreateTime(DateUtils.dateToStr((Date)each.getCreateTime()));
                }
                if (each.getUpdateTime() != null) {
                    bo.setUpdateTime(DateUtils.dateToStr((Date)each.getUpdateTime()));
                }
                if ("0000".equals((skuDetail = this.uccQrySkuInfoAtomService.queryInfomation(uccQrySkuDetailReqBO)).getRespCode())) {
                    bo.setSkuStockInfo(skuDetail.getSkuStock());
                    bo.setSkuPutCirInfo(skuDetail.getSkuPutCir());
                    bo.setSkuPicInfoList(skuDetail.getSkuPic());
                    bo.setSkuSaleNumInfo(skuDetail.getSkuSaleNum());
                    bo.setSkuSpecInfoList(skuDetail.getSkuSpec());
                    bo.setSkuPriceInfo(skuDetail.getSkuprice());
                    bo.setChannels(skuDetail.getChannels());
                }
                listBo.add(bo);
            }
            commodityBo.setSkuInfoList(listBo);
        }
        rspBO.setCommodity(commodityBo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    public List<Long> filterSkuId(Long commodityId, Long commodityPropDefId, Long propvaluelistid, Long supplierShopId, List<Long> skuIds) {
        return this.uccSkuSpecMapper.filterSkuIdByProp(commodityId, commodityPropDefId, propvaluelistid, supplierShopId, skuIds);
    }

    private String verify(com.tydic.commodity.bo.busi.UccQryCommdDetailReqBO reqBO) {
        if (reqBO.getSupplierShopId() == null || reqBO.getSupplierShopId() == 0L) {
            return "\u8bf7\u9009\u62e9\u9700\u8981\u67e5\u8be2\u7684\u5e97\u94fa";
        }
        if (reqBO.getCommodityId() == null && reqBO.getSkuId() == null) {
            return "\u8bf7\u9009\u62e9\u67e5\u8be2\u7684\u5546\u54c1\u4fe1\u606f";
        }
        return this.enumVerify(reqBO);
    }

    private String enumVerify(com.tydic.commodity.bo.busi.UccQryCommdDetailReqBO reqBO) {
        Map<String, String> enumMap;
        if (!(reqBO.getSkuStatus() == null || (enumMap = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_STATUS.toString())) != null && enumMap.containsKey(reqBO.getSkuStatus().toString()))) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5355\u54c1\u72b6\u6001";
        }
        return "";
    }

    public void formatSpec(List<SpuSpecBo> specBos, CommodityBo commodityBo) {
        if (specBos.isEmpty()) {
            return;
        }
        HashMap group = new HashMap();
        for (SpuSpecBo each : specBos) {
            if (group.containsKey(each.getCommodityPropGrpId())) {
                ((List)group.get(each.getCommodityPropGrpId())).add(each);
                continue;
            }
            ArrayList<SpuSpecBo> spuSpecBos = new ArrayList<SpuSpecBo>();
            spuSpecBos.add(each);
            group.put(each.getCommodityPropGrpId(), spuSpecBos);
        }
        ArrayList<SpecBo> specBoList = new ArrayList<SpecBo>();
        SpecBo bo = new SpecBo();
        Iterator iterator = group.entrySet().iterator();
        while (iterator.hasNext()) {
            bo = new SpecBo();
            Map.Entry map = iterator.next();
            UccCommodityPropGrpPo grpPo = this.uccCommodityPropGrpMapper.queryGroupByGrpId((Long)map.getKey());
            bo.setCommodityPropGrpId(grpPo.getCommodityPropGrpId());
            bo.setCommodityPropGrpCode(grpPo.getCommodityPropGrpCode());
            bo.setCommodityPropGrpName(grpPo.getCommodityPropGrpName());
            bo.setCommodityPropGrpType(grpPo.getCommodityPropGrpType());
            ArrayList commodityProps = new ArrayList();
            PropEntityBo propEntityBo = null;
            HashedMap defMap = new HashedMap();
            for (SpuSpecBo spec : (List)map.getValue()) {
                PropEntityValue value = new PropEntityValue();
                if (defMap.containsKey(spec.getCommodityPropDefId())) {
                    value.setPropValue(spec.getPropValue());
                    value.setPropValueListId(spec.getPropValueListId());
                    ((PropEntityBo)defMap.get(spec.getCommodityPropDefId())).getSalePropEntityValue().add(value);
                    continue;
                }
                ArrayList<PropEntityValue> salePropEntityValue = new ArrayList<PropEntityValue>();
                PropEntityValue propEntityValue = new PropEntityValue();
                propEntityValue.setPropValueListId(spec.getPropValueListId());
                propEntityValue.setPropValue(spec.getPropValue());
                salePropEntityValue.add(propEntityValue);
                propEntityBo = new PropEntityBo();
                propEntityBo.setCommodityPropDefId(spec.getCommodityPropDefId());
                propEntityBo.setPropName(spec.getPropName());
                propEntityBo.setShowName(spec.getPropShowName());
                propEntityBo.setSalePropEntityValue(salePropEntityValue);
                defMap.put(spec.getCommodityPropDefId(), propEntityBo);
            }
            commodityProps.addAll(defMap.values());
            bo.setCommodityDefs(commodityProps);
            specBoList.add(bo);
        }
        commodityBo.setCommodityProps(specBoList);
    }
}

