/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.bo.ability.UccCommodityInDetailBO;
import com.tydic.commodity.bo.busi.QryCommodityDetailListReqBO;
import com.tydic.commodity.busi.api.UccQryCommodityDetailListBusiService;
import com.tydic.commodity.dao.UccQryCommodityListsInfoMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.dao.po.UccCommodityInDetailPO;
import com.tydic.commodity.dao.po.UccQryCommoDetailPO;
import com.tydic.commodity.dao.po.UccVendorPo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.ListCloneUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccQryCommodityDetailListBusiService.class)
public class UccQryCommodityDetailListBusiServiceImpl
implements UccQryCommodityDetailListBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQryCommodityDetailListBusiServiceImpl.class);
    @Autowired
    private UccQryCommodityListsInfoMapper qryCommodityListsInfoMapper;
    @Autowired
    private UccVendorMapper uccVendorMapper;

    public List<UccCommodityInDetailBO> qryCommodityDetailList(QryCommodityDetailListReqBO reqBO) {
        UccQryCommoDetailPO uccQryCommoDetailPO = new UccQryCommoDetailPO();
        uccQryCommoDetailPO.setSupplierShopId(reqBO.getSupplierShopId());
        uccQryCommoDetailPO.setCommodityId(reqBO.getCommodityId());
        List<UccCommodityInDetailPO> uccCommodityInDetailBO = null;
        try {
            uccCommodityInDetailBO = this.qryCommodityListsInfoMapper.queryCommodityInfoList(uccQryCommoDetailPO);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5546\u54c1\u76f8\u5173\u4fe1\u606f\u5931\u8d25,\u539f\u56e0\uff1a", (Throwable)e);
        }
        try {
            List commodityInDetailBOS = ListCloneUtils.clonePOListToBOListNotDate(uccCommodityInDetailBO, UccCommodityInDetailBO.class);
            if (commodityInDetailBOS != null && commodityInDetailBOS.size() > 0) {
                for (UccCommodityInDetailBO each : commodityInDetailBOS) {
                    UccVendorPo po = new UccVendorPo();
                    po.setId(each.getVendorShopId());
                    List<UccVendorPo> list = this.uccVendorMapper.queryVerdor(po);
                    if (list != null && list.size() > 0) {
                        each.setExtShopId(list.get(0).getShopId().toString());
                        each.setExtShopName(list.get(0).getShopName());
                    }
                    po = null;
                }
            }
            return commodityInDetailBOS;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5546\u54c1\u76f8\u5173\u4fe1\u606f\u5931\u8d25,\u539f\u56e0\uff1a", (Throwable)e);
            throw new BusinessException("8888", "\u67e5\u8be2\u5546\u54c1\u76f8\u5173\u4fe1\u606f\u5931\u8d25");
        }
    }
}

