/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.atom.UccSupplierCacheAtomService;
import com.tydic.commodity.atom.bo.UccSupplierCacheReqBo;
import com.tydic.commodity.atom.bo.UccSupplierCacheRspBo;
import com.tydic.commodity.bo.ability.PropEntityBo;
import com.tydic.commodity.bo.ability.PropEntityValue;
import com.tydic.commodity.bo.ability.SpecBo;
import com.tydic.commodity.bo.busi.CommodityImageBo;
import com.tydic.commodity.bo.busi.CommodityItemBo;
import com.tydic.commodity.bo.busi.SpuSpecBo;
import com.tydic.commodity.bo.busi.UccQryCommdItemReqBO;
import com.tydic.commodity.bo.busi.UccQryCommdItemRspBO;
import com.tydic.commodity.busi.api.UccQryCommodityItemBusiService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccLabelDealMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSceneSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSpuSpecMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.dao.po.UccBrandDealPO;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccCommodityPropGrpPo;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.dao.po.UccLabelPO;
import com.tydic.commodity.dao.po.UccSaleNumPo;
import com.tydic.commodity.dao.po.UccSceneSkuPricePo;
import com.tydic.commodity.dao.po.UccSkuPicPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.dao.po.UccSpuSpecPo;
import com.tydic.commodity.enumType.CommodityEnum;
import com.tydic.commodity.enumType.SkuEnum;
import com.tydic.commodity.util.DateUtils;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccQryCommodityItemBusiService.class)
public class UccQryCommodityItemBusiServiceImpl
implements UccQryCommodityItemBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQryCommodityItemBusiServiceImpl.class);
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSpuSpecMapper uccSpuSpecMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccLabelDealMapper uccLabelDealMapper;
    @Autowired
    private UccSupplierCacheAtomService uccSupplierCacheAtomService;
    @Autowired
    private UccSceneSkuPriceMapper uccSceneSkuPriceMapper;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;

    public UccQryCommdItemRspBO qryItem(UccQryCommdItemReqBO reqBO) {
        UccQryCommdItemRspBO rspBO = new UccQryCommdItemRspBO();
        String errMsg = this.verify(reqBO);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(errMsg);
            return rspBO;
        }
        UccSupplierCacheReqBo uccSupplierCacheReqBo = new UccSupplierCacheReqBo();
        uccSupplierCacheReqBo.setSupplierId(reqBO.getOrgIdIn());
        UccSupplierCacheRspBo uccSupplierCacheRspBo = this.uccSupplierCacheAtomService.qryInfomation(uccSupplierCacheReqBo);
        if (uccSupplierCacheRspBo == null || !"0000".equals(uccSupplierCacheRspBo.getRespCode())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5f53\u524d\u5e97\u94fa\u4e0d\u5728\u5546\u6237\u7ba1\u7406\u4e2d");
            return rspBO;
        }
        StringBuilder sb = new StringBuilder();
        if (reqBO.getSkuId() != null) {
            sb.append("REDIS_UCC_COMMODITYSKUQRY");
        } else {
            sb.append("REDIS_UCC_COMMODITYCOMMDITEMQRY");
        }
        sb.append(reqBO.getCommodityId());
        Object object = this.cacheClient.get(sb.toString());
        if (object != null) {
            try {
                rspBO = (UccQryCommdItemRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)object), UccQryCommdItemRspBO.class);
            }
            catch (Exception e) {
                LOGGER.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38\uff1a JSON to javaObject:" + object);
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u7f51\u7edc\u7e41\u5fd9\uff01\u7a0d\u540e\u8bf7\u91cd\u8bd5");
                return rspBO;
            }
        }
        this.qryCommdity(reqBO, rspBO, uccSupplierCacheRspBo);
        if (rspBO.getCommodity() != null) {
            try {
                if (reqBO.getSkuId() == null) {
                    this.cacheClient.set(sb.toString(), (Object)rspBO);
                    sb = null;
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5546\u54c1\u8be6\u60c5\u7f13\u5b58 RedisKey= " + sb.toString() + " \u7f13\u5b58redis \u5f02\u5e38\uff1a" + e.getMessage());
            }
        } else {
            LOGGER.error("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u6570\u636e\uff1a" + reqBO.getCommodityId());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7f51\u7edc\u7e41\u5fd9\uff01\u7a0d\u540e\u8bf7\u91cd\u8bd5");
            return rspBO;
        }
        if (reqBO.getSkuId() != null) {
            List<UccSceneSkuPricePo> sceneSkuPricePos;
            UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
            uccSkuPricePo.setSkuId(reqBO.getSkuId());
            UccSkuPricePo skuPricePo = this.uccSkuPriceMapper.querySkuPrice(uccSkuPricePo);
            if (skuPricePo != null) {
                rspBO.getCommodity().setPrice(MoneyUtils.haoToYuan((Long)skuPricePo.getSalePrice()));
                rspBO.getCommodity().setMarketPrice(MoneyUtils.haoToYuan((Long)skuPricePo.getMarketPrice()));
            } else {
                rspBO.getCommodity().setPrice(new BigDecimal(0));
                rspBO.getCommodity().setMarketPrice(new BigDecimal(0));
            }
            UccSaleNumPo uccSaleNumPo = new UccSaleNumPo();
            uccSaleNumPo.setSkuId(reqBO.getSkuId());
            uccSaleNumPo = this.uccSaleNumMapper.querySaleNum(uccSaleNumPo);
            if (uccSaleNumPo != null) {
                rspBO.getCommodity().setEccommerSale(uccSaleNumPo.getEcommerceSale());
            } else {
                rspBO.getCommodity().setEccommerSale(new BigDecimal(0));
            }
            if (uccSupplierCacheRspBo.getSceneId() != null && !CollectionUtils.isEmpty(sceneSkuPricePos = this.uccSceneSkuPriceMapper.qrySKuBySceneandsku(Arrays.asList(reqBO.getSkuId()), uccSupplierCacheRspBo.getSceneId(), 1))) {
                rspBO.getCommodity().setPrice(MoneyUtils.haoToYuan((Long)sceneSkuPricePos.get(0).getSalePrice()));
                rspBO.getCommodity().setMarketPrice(MoneyUtils.haoToYuan((Long)sceneSkuPricePos.get(0).getMarketPrice()));
            }
        } else {
            UccSceneSkuPricePo uccSceneSkuPricePo;
            List<UccSkuPricePo> uccSkuPricePoList = this.uccSkuPriceMapper.queryPriceOrderBySaleAsc(rspBO.getCommodity().getCommodityId(), rspBO.getCommodity().getSupplierShopId());
            if (uccSkuPricePoList != null && uccSkuPricePoList.size() > 0) {
                rspBO.getCommodity().setPrice(MoneyUtils.haoToYuan((Long)uccSkuPricePoList.get(0).getSalePrice()));
                rspBO.getCommodity().setMarketPrice(MoneyUtils.haoToYuan((Long)uccSkuPricePoList.get(0).getMarketPrice()));
            } else {
                rspBO.getCommodity().setPrice(new BigDecimal(0));
                rspBO.getCommodity().setMarketPrice(new BigDecimal(0));
            }
            List<UccSaleNumPo> uccSaleNumPoList = this.uccSaleNumMapper.qryEcommerceSaleOrderByDesc(rspBO.getCommodity().getCommodityId(), rspBO.getCommodity().getSupplierShopId());
            if (uccSaleNumPoList != null && uccSaleNumPoList.size() > 0) {
                rspBO.getCommodity().setEccommerSale(uccSaleNumPoList.get(0).getEcommerceSale());
            } else {
                rspBO.getCommodity().setEccommerSale(new BigDecimal(0));
            }
            if (uccSupplierCacheRspBo.getSceneId() != null && (uccSceneSkuPricePo = this.uccSceneSkuPriceMapper.qryMinSalePirceBycomdIdAndScenceId(reqBO.getCommodityId(), uccSupplierCacheRspBo.getSceneId())) != null) {
                rspBO.getCommodity().setPrice(MoneyUtils.haoToYuan((Long)uccSceneSkuPricePo.getSalePrice()));
                rspBO.getCommodity().setMarketPrice(MoneyUtils.haoToYuan((Long)uccSceneSkuPricePo.getMarketPrice()));
            }
        }
        UccLabelPO uccLabelPO = new UccLabelPO();
        uccLabelPO.setCommodityId(reqBO.getCommodityId());
        List<UccLabelPO> uccLabelPOS = this.uccLabelDealMapper.selectLabel(uccLabelPO);
        if (!CollectionUtils.isEmpty(uccLabelPOS)) {
            List labes = uccLabelPOS.stream().map(UccLabelPO::getLabelType).collect(Collectors.toList());
            rspBO.getCommodity().setLabelType(labes);
        } else {
            rspBO.getCommodity().setLabelType(new ArrayList());
        }
        return rspBO;
    }

    private void qryCommdity(UccQryCommdItemReqBO reqBO, UccQryCommdItemRspBO rspBO, UccSupplierCacheRspBo uccSupplierCacheRspBo) {
        CommodityImageBo bo;
        UccCommodityTypePo uccCommodityTypePo;
        UccSkuPo qryCommd = new UccSkuPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)qryCommd);
        List<UccSkuPo> listSku = this.uccSkuMapper.qerySku(qryCommd);
        if (listSku == null || listSku.size() == 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f");
            return;
        }
        UccCommodityPo commdPo = this.uccCommodityMapper.qryCommdByCommdId(listSku.get(0).getCommodityId(), reqBO.getSupplierShopId());
        if (commdPo == null) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f");
            return;
        }
        CommodityItemBo commodityBo = new CommodityItemBo();
        BeanUtils.copyProperties((Object)commdPo, (Object)commodityBo);
        if (reqBO.getSkuId() != null) {
            commodityBo.setCommodityName(listSku.get(0).getSkuName());
        }
        if (!StringUtils.isEmpty((Object)listSku.get(0).getPreDeliverDay())) {
            commodityBo.setPreDeliverDay(Integer.valueOf(listSku.get(0).getPreDeliverDay()));
        }
        if ((uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(commdPo.getCommodityTypeId())) != null) {
            commodityBo.setCommodityTypeName(uccCommodityTypePo.getCommodityTypeName());
        }
        if (uccSupplierCacheRspBo != null) {
            commodityBo.setShopName(uccSupplierCacheRspBo.getShopPos().get(0).getShopName());
        }
        UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
        uccBrandDealPO.setBrandId(commodityBo.getBrandId());
        uccBrandDealPO = this.uccBrandDealMapper.selectById(uccBrandDealPO);
        if (uccBrandDealPO != null) {
            commodityBo.setBrandName(uccBrandDealPO.getBrandName());
        }
        if (commdPo.getCreateTime() != null) {
            commodityBo.setCreateTime(DateUtils.dateToStr((Date)commdPo.getCreateTime()));
        }
        if (commdPo.getUpdateTime() != null) {
            commodityBo.setUpdateTime(DateUtils.dateToStr((Date)commdPo.getUpdateTime()));
        }
        DicDictionaryPo po = null;
        if (commdPo.getCommodityStatus() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(commdPo.getCommodityStatus().toString(), CommodityEnum.COMMODITY_STATUS.toString())) != null) {
            commodityBo.setCommodityStatusDesc(po.getTitle());
            po = null;
        }
        if (commdPo.getCommoditySource() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(commdPo.getCommoditySource().toString(), CommodityEnum.COMMODITY_SOURCE.toString())) != null) {
            commodityBo.setCommoditySourceDesc(po.getTitle());
            po = null;
        }
        if (commdPo.getStoreGetType() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(commdPo.getStoreGetType().toString(), CommodityEnum.COMMODITY_STORE_GET_TYPE.toString())) != null) {
            commodityBo.setStoreGetTypeDesc(po.getTitle());
            po = null;
        }
        if (commdPo.getServenRejectAllow() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(commdPo.getServenRejectAllow().toString(), CommodityEnum.COMMODITY_SERVEN_REJECT_ALLOW.toString())) != null) {
            commodityBo.setServenRejectAllowDesc(po.getTitle());
            po = null;
        }
        UccSpuSpecPo uccSpuSpecPo = new UccSpuSpecPo();
        uccSpuSpecPo.setCommodityId(commdPo.getCommodityId());
        uccSpuSpecPo.setSupplierShopId(commdPo.getSupplierShopId());
        List<UccSpuSpecPo> listSpuSpec = this.uccSpuSpecMapper.querySpec(uccSpuSpecPo);
        if (listSpuSpec != null && listSpuSpec.size() > 0) {
            ArrayList<SpuSpecBo> spuSpecBos = new ArrayList<SpuSpecBo>();
            SpuSpecBo bo2 = null;
            for (UccSpuSpecPo each : listSpuSpec) {
                bo2 = new SpuSpecBo();
                BeanUtils.copyProperties((Object)each, (Object)bo2);
                spuSpecBos.add(bo2);
            }
            this.formatSpec(spuSpecBos, commodityBo);
        }
        ArrayList<CommodityImageBo> listBo = new ArrayList<CommodityImageBo>();
        if (reqBO.getSkuId() != null) {
            UccSkuPicPo uccSkuPicPo = new UccSkuPicPo();
            uccSkuPicPo.setSkuId(reqBO.getSkuId());
            uccSkuPicPo.setCommodityPicType(2);
            List<UccSkuPicPo> skuPicPos = this.uccSkuPicMapper.qeurySkuPic(uccSkuPicPo);
            if (!CollectionUtils.isEmpty(skuPicPos)) {
                bo = null;
                for (UccSkuPicPo uccSkuPicPo2 : skuPicPos) {
                    bo = new CommodityImageBo();
                    bo.setCommodityPicId(uccSkuPicPo2.getSkuPicId());
                    bo.setCommodityPicType(uccSkuPicPo2.getCommodityPicType());
                    bo.setCommodityPicUrl(uccSkuPicPo2.getSkuPicUrl());
                    if (uccSkuPicPo2.getCreateTime() != null) {
                        bo.setCreateTime(DateUtils.dateToStr((Date)uccSkuPicPo2.getCreateTime()));
                    }
                    if (uccSkuPicPo2.getUpdateTime() != null) {
                        bo.setUpdateTime(DateUtils.dateToStr((Date)uccSkuPicPo2.getUpdateTime()));
                    }
                    listBo.add(bo);
                }
                commodityBo.setCommdImages(listBo);
            }
        }
        if (CollectionUtils.isEmpty(listBo)) {
            UccCommodityPicPo uccCommodityPicPo = new UccCommodityPicPo();
            uccCommodityPicPo.setCommodityId(commdPo.getCommodityId());
            uccCommodityPicPo.setSupplierShopId(commdPo.getSupplierShopId());
            List<UccCommodityPicPo> listPic = this.uccCommodityPicMapper.queryCommdPic(uccCommodityPicPo);
            if (listPic != null && listPic.size() > 0) {
                bo = null;
                for (UccCommodityPicPo uccCommodityPicPo2 : listPic) {
                    bo = new CommodityImageBo();
                    BeanUtils.copyProperties((Object)uccCommodityPicPo2, (Object)bo);
                    if (uccCommodityPicPo2.getCreateTime() != null) {
                        bo.setCreateTime(DateUtils.dateToStr((Date)uccCommodityPicPo2.getCreateTime()));
                    }
                    if (uccCommodityPicPo2.getUpdateTime() != null) {
                        bo.setUpdateTime(DateUtils.dateToStr((Date)uccCommodityPicPo2.getUpdateTime()));
                    }
                    listBo.add(bo);
                }
                commodityBo.setCommdImages(listBo);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5546\u54c1\u8be6\u60c5\u67e5\u8be2\u6210\u529f");
        rspBO.setCommodity(commodityBo);
    }

    private String verify(UccQryCommdItemReqBO reqBO) {
        if (reqBO.getSupplierShopId() == null || reqBO.getSupplierShopId() == 0L) {
            return "\u8bf7\u9009\u62e9\u9700\u8981\u67e5\u8be2\u7684\u5e97\u94fa";
        }
        if (reqBO.getCommodityId() == null) {
            return "\u8bf7\u9009\u62e9\u67e5\u8be2\u7684\u5546\u54c1\u4fe1\u606f";
        }
        return this.enumVerify(reqBO);
    }

    private String enumVerify(UccQryCommdItemReqBO reqBO) {
        Map<String, String> enumMap;
        if (!(reqBO.getSkuStatus() == null || (enumMap = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_STATUS.toString())) != null && enumMap.containsKey(reqBO.getSkuStatus().toString()))) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5355\u54c1\u72b6\u6001";
        }
        return "";
    }

    public void formatSpec(List<SpuSpecBo> specBos, CommodityItemBo commodityBo) {
        if (specBos.isEmpty()) {
            return;
        }
        HashMap group = new HashMap();
        for (SpuSpecBo each : specBos) {
            if (group.containsKey(each.getCommodityPropGrpId())) {
                ((List)group.get(each.getCommodityPropGrpId())).add(each);
                continue;
            }
            ArrayList<SpuSpecBo> spuSpecBos = new ArrayList<SpuSpecBo>();
            spuSpecBos.add(each);
            group.put(each.getCommodityPropGrpId(), spuSpecBos);
        }
        ArrayList<SpecBo> specBoList = new ArrayList<SpecBo>();
        SpecBo bo = new SpecBo();
        Iterator iterator = group.entrySet().iterator();
        while (iterator.hasNext()) {
            bo = new SpecBo();
            Map.Entry map = iterator.next();
            UccCommodityPropGrpPo grpPo = this.uccCommodityPropGrpMapper.queryGroupByGrpId((Long)map.getKey());
            bo.setCommodityPropGrpId(grpPo.getCommodityPropGrpId());
            bo.setCommodityPropGrpCode(grpPo.getCommodityPropGrpCode());
            bo.setCommodityPropGrpName(grpPo.getCommodityPropGrpName());
            bo.setCommodityPropGrpType(grpPo.getCommodityPropGrpType());
            ArrayList commodityProps = new ArrayList();
            PropEntityBo propEntityBo = null;
            HashedMap defMap = new HashedMap();
            for (SpuSpecBo spec : (List)map.getValue()) {
                PropEntityValue value = new PropEntityValue();
                if (defMap.containsKey(spec.getCommodityPropDefId())) {
                    value.setPropValue(spec.getPropValue());
                    value.setPropValueListId(spec.getPropValueListId());
                    ((PropEntityBo)defMap.get(spec.getCommodityPropDefId())).getSalePropEntityValue().add(value);
                    continue;
                }
                ArrayList<PropEntityValue> salePropEntityValue = new ArrayList<PropEntityValue>();
                PropEntityValue propEntityValue = new PropEntityValue();
                propEntityValue.setPropValueListId(spec.getPropValueListId());
                propEntityValue.setPropValue(spec.getPropValue());
                salePropEntityValue.add(propEntityValue);
                propEntityBo = new PropEntityBo();
                propEntityBo.setCommodityPropDefId(spec.getCommodityPropDefId());
                propEntityBo.setPropName(spec.getPropName());
                propEntityBo.setShowName(spec.getPropShowName());
                propEntityBo.setSalePropEntityValue(salePropEntityValue);
                defMap.put(spec.getCommodityPropDefId(), propEntityBo);
            }
            commodityProps.addAll(defMap.values());
            bo.setCommodityDefs(commodityProps);
            specBoList.add(bo);
        }
        commodityBo.setCommodityProps(specBoList);
    }
}

