/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.tydic.commodity.atom.UccSupplierCacheAtomService;
import com.tydic.commodity.atom.UccSupplierShopCacheAtomService;
import com.tydic.commodity.atom.bo.UccSupplierCacheReqBo;
import com.tydic.commodity.atom.bo.UccSupplierCacheRspBo;
import com.tydic.commodity.atom.bo.UccSupplierShopCacheReqBo;
import com.tydic.commodity.atom.bo.UccSupplierShopCacheRspBo;
import com.tydic.commodity.bo.ability.SkuInfoImageBo;
import com.tydic.commodity.bo.ability.SkuInfoPriceBo;
import com.tydic.commodity.bo.ability.SkuInfoPutCirBo;
import com.tydic.commodity.bo.ability.UccSkuInfoDetailBO;
import com.tydic.commodity.bo.busi.QrySkusDetailListReqBO;
import com.tydic.commodity.bo.busi.SkuSaleNumBo;
import com.tydic.commodity.bo.busi.SkuSpecBo;
import com.tydic.commodity.bo.busi.SkuStockBo;
import com.tydic.commodity.bo.busi.UccChannelputBo;
import com.tydic.commodity.busi.api.UccQrySkuDetailListBusiService;
import com.tydic.commodity.dao.UccQrySkuDetailListsMapper;
import com.tydic.commodity.dao.UccSceneSkuPriceMapper;
import com.tydic.commodity.dao.po.UccQrySkusDetailPO;
import com.tydic.commodity.dao.po.UccSceneSkuPricePo;
import com.tydic.commodity.dao.po.UccSkuInfoDetailPO;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.ListCloneUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccQrySkuDetailListBusiService.class)
public class UccQrySkuDetailListBusiServiceImpl
implements UccQrySkuDetailListBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQrySkuDetailListBusiServiceImpl.class);
    @Autowired
    private UccQrySkuDetailListsMapper uccQrySkuDetailListsMapper;
    @Autowired
    private UccSupplierCacheAtomService uccSupplierCacheAtomService;
    @Autowired
    private UccSupplierShopCacheAtomService uccSupplierShopCacheAtomService;
    @Autowired
    private UccSceneSkuPriceMapper uccSceneSkuPriceMapper;

    public List<UccSkuInfoDetailBO> querySkuDetailList(QrySkusDetailListReqBO reqBO) {
        List<UccSceneSkuPricePo> uccSceneSkuPricePos;
        UccQrySkusDetailPO qrySkusDetailPO = new UccQrySkusDetailPO();
        UccSupplierShopCacheReqBo uccSupplierShopCacheReqBo = new UccSupplierShopCacheReqBo();
        if (reqBO.getOrgIdIn() != null) {
            uccSupplierShopCacheReqBo.setSupplierShopId(reqBO.getOrgIdIn());
        } else {
            uccSupplierShopCacheReqBo.setSupplierShopId(reqBO.getSupplierShopId());
        }
        UccSupplierShopCacheRspBo uccSupplierShopCacheRspBo = this.uccSupplierShopCacheAtomService.qryInfomation(uccSupplierShopCacheReqBo);
        if (uccSupplierShopCacheRspBo == null || !"0000".equals(uccSupplierShopCacheRspBo.getRespCode())) {
            LOGGER.error("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
            throw new BusinessException("supplierShopId_is_null", "\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
        }
        UccSupplierCacheReqBo uccSupplierCacheReqBo = new UccSupplierCacheReqBo();
        uccSupplierCacheReqBo.setSupplierId(uccSupplierShopCacheRspBo.getSupplierId());
        UccSupplierCacheRspBo uccSupplierCacheRspBo = this.uccSupplierCacheAtomService.qryInfomation(uccSupplierCacheReqBo);
        if (uccSupplierCacheRspBo == null || !"0000".equals(uccSupplierCacheRspBo.getRespCode())) {
            LOGGER.error("\u4f9b\u5e94\u5546\u67e5\u8be2\u51fa\u9519");
            throw new BusinessException("supplierShopId_is_null", "\u4f9b\u5e94\u5546\u67e5\u8be2\u51fa\u9519");
        }
        ArrayList uccSkuInfoDetailBOS = Lists.newArrayList();
        qrySkusDetailPO.setSkuId(reqBO.getSkuId());
        qrySkusDetailPO.setSupplierShopId(reqBO.getSupplierShopId());
        List<UccSkuInfoDetailPO> skuInfoDetailPOS = this.uccQrySkuDetailListsMapper.querySkusInfoList(qrySkusDetailPO);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("\u6570\u636e\uff1a" + JSON.toJSONString(skuInfoDetailPOS));
        }
        try {
            for (UccSkuInfoDetailPO uccSkuInfoDetailPO : skuInfoDetailPOS) {
                UccSkuInfoDetailBO uccSkuInfoDetailBO = new UccSkuInfoDetailBO();
                BeanUtils.copyProperties((Object)uccSkuInfoDetailPO, (Object)uccSkuInfoDetailBO);
                List skuInfoImageBos = ListCloneUtils.clonePOListToBOList(uccSkuInfoDetailPO.getSkuImags(), SkuInfoImageBo.class);
                List skuSpecBos = ListCloneUtils.clonePOListToBOList(uccSkuInfoDetailPO.getSkuSpec(), SkuSpecBo.class);
                SkuInfoPriceBo skuInfoPriceBo = (SkuInfoPriceBo)ListCloneUtils.copyPOTobBO((Object)uccSkuInfoDetailPO.getSkuInfoPrice(), SkuInfoPriceBo.class);
                UccChannelputBo uccChannelputBo = (UccChannelputBo)ListCloneUtils.copyPOTobBO((Object)uccSkuInfoDetailPO.getChannels(), UccChannelputBo.class);
                SkuInfoPutCirBo skuInfoPutCirBo = (SkuInfoPutCirBo)ListCloneUtils.copyPOTobBO((Object)uccSkuInfoDetailPO.getSkuPutCir(), SkuInfoPutCirBo.class);
                SkuSaleNumBo skuSaleNumBo = (SkuSaleNumBo)ListCloneUtils.copyPOTobBO((Object)uccSkuInfoDetailPO.getSkuSaleNum(), SkuSaleNumBo.class);
                SkuStockBo skuStockBo = (SkuStockBo)ListCloneUtils.copyPOTobBO((Object)uccSkuInfoDetailPO.getSkuStock(), SkuStockBo.class);
                uccSkuInfoDetailBO.setSkuStock(skuStockBo);
                uccSkuInfoDetailBO.setChannels(uccChannelputBo);
                uccSkuInfoDetailBO.setSkuPutCir(skuInfoPutCirBo);
                uccSkuInfoDetailBO.setSkuSaleNum(skuSaleNumBo);
                uccSkuInfoDetailBO.setSkuInfoPrice(skuInfoPriceBo);
                uccSkuInfoDetailBO.setSkuImags(skuInfoImageBos);
                uccSkuInfoDetailBO.setSkuSpec(skuSpecBos);
                uccSkuInfoDetailBOS.add(uccSkuInfoDetailBO);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2sku\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25:", (Throwable)e);
        }
        if (uccSupplierCacheRspBo.getSceneId() != null && !CollectionUtils.isEmpty(uccSceneSkuPricePos = this.uccSceneSkuPriceMapper.qrySKuBySceneandsku(Arrays.asList(reqBO.getSkuId()), uccSupplierCacheRspBo.getSceneId(), 1))) {
            Map<Long, UccSceneSkuPricePo> skuPricePoMap = uccSceneSkuPricePos.stream().collect(Collectors.toMap(UccSceneSkuPricePo::getSkuId, UccSceneSkuPricePo2 -> UccSceneSkuPricePo2));
            for (UccSkuInfoDetailBO each : uccSkuInfoDetailBOS) {
                if (!skuPricePoMap.containsKey(each.getSkuId())) continue;
                each.getSkuInfoPrice().setMarketPrice(skuPricePoMap.get(each.getSkuId()).getMarketPrice());
                each.getSkuInfoPrice().setSalePrice(skuPricePoMap.get(each.getSkuId()).getSalePrice());
            }
            skuPricePoMap = null;
        }
        return uccSkuInfoDetailBOS;
    }
}

