/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.SkuBo;
import com.tydic.commodity.bo.busi.UccSkuInfoReqBO;
import com.tydic.commodity.bo.busi.UccSkuInfoRspBO;
import com.tydic.commodity.busi.api.UccQrySkuInfoBusiService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.dao.po.UccBrandDealPO;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.SkuEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccQrySkuInfoBusiService.class)
public class UccQrySkuInfoBusiServiceImpl
implements UccQrySkuInfoBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQrySkuInfoBusiServiceImpl.class);
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    public UccSkuInfoRspBO queryInfomation(UccSkuInfoReqBO reqBO) {
        UccSkuInfoRspBO rspBO = new UccSkuInfoRspBO();
        String errMsg = this.verify(reqBO);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(errMsg);
            return rspBO;
        }
        UccCommodityPo uccCommodityPo = new UccCommodityPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccCommodityPo);
        List<Long> commoditys = null;
        Long a = System.currentTimeMillis();
        if (!StringUtils.isEmpty((String)reqBO.getCommodityName()) && CollectionUtils.isEmpty(commoditys = this.uccCommodityMapper.queryIdByName(uccCommodityPo))) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        if (!StringUtils.isEmpty((String)reqBO.getCommodityCode()) && CollectionUtils.isEmpty(commoditys = this.uccCommodityMapper.queryByCommodityIds(commoditys, uccCommodityPo))) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        Page skuPage = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccSkuPo uccSkuPo = new UccSkuPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuPo);
        List<UccSkuPo> listSkuInfo = this.uccSkuMapper.qrySkuByCommdsToPage((Page<UccSkuPo>)skuPage, uccSkuPo, commoditys);
        ArrayList<SkuBo> listBo = new ArrayList<SkuBo>();
        SkuBo bo = null;
        DicDictionaryPo po = null;
        if (listSkuInfo != null && listSkuInfo.size() > 0) {
            UccCommodityTypePo uccCommodityTypePo = null;
            for (UccSkuPo each : listSkuInfo) {
                bo = new SkuBo();
                BeanUtils.copyProperties((Object)each, (Object)bo);
                uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(each.getCommodityTypeId());
                if (uccCommodityTypePo != null) {
                    bo.setCommodityTypeName(uccCommodityTypePo.getCommodityTypeName());
                }
                if (each.getSkuStatus() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getSkuStatus().toString(), SkuEnum.SKU_STATUS.toString())) != null) {
                    bo.setSkuStatusDesc(po.getTitle());
                    po = null;
                }
                if (each.getSkuSource() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getSkuSource().toString(), SkuEnum.SKU_SOURCE.toString())) != null) {
                    bo.setSkuSourceDesc(po.getTitle());
                    po = null;
                }
                if (each.getOnShelveWay() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getOnShelveWay().toString(), SkuEnum.SKU_ON_SHELVE_WAY.toString())) != null) {
                    bo.setOnShelveWayDec(po.getTitle());
                    po = null;
                }
                listBo.add(bo);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u6210\u529f");
        rspBO.setRows(listBo);
        rspBO.setPageNo(skuPage.getPageNo());
        rspBO.setRecordsTotal(skuPage.getTotalCount());
        rspBO.setTotal(skuPage.getTotalPages());
        return rspBO;
    }

    private String verify(UccSkuInfoReqBO reqBO) {
        if (reqBO.getSupplierShopId() == null || reqBO.getSupplierShopId() == 0L) {
            return "\u8bf7\u4f20\u5165\u5e97\u94fa\u4fe1\u606f";
        }
        if (reqBO.getAllStatus() != 1 && reqBO.getSkuStatus() == null) {
            return "\u8bf7\u4f20\u5165\u5355\u54c1\u72b6\u6001";
        }
        if (reqBO.getAllStatus() == 1) {
            reqBO.setSkuStatus(null);
        }
        return this.dataBaseVerify(reqBO);
    }

    private String dataBaseVerify(UccSkuInfoReqBO reqBO) {
        UccCommodityTypePo uccCommodityTypePo;
        if (reqBO.getSupplierShopId() != null && reqBO.getSupplierShopId() != 0L) {
            int count = 0;
            count = this.supplierShopMapper.selectSupplierShopById(reqBO.getSupplierShopId());
            if (count == 0) {
                return "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5e97\u94fa\u4fe1\u606f";
            }
        }
        if (reqBO.getCommodityTypeId() != null && reqBO.getCommodityTypeId() != 0L && (uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(reqBO.getCommodityTypeId())) == null) {
            return "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5546\u54c1\u7c7b\u578b\u4fe1\u606f";
        }
        if (reqBO.getBrandId() != null && reqBO.getBrandId() != 0L) {
            UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
            uccBrandDealPO.setBrandId(reqBO.getBrandId());
            uccBrandDealPO = this.uccBrandDealMapper.selectById(uccBrandDealPO);
            if (uccBrandDealPO == null) {
                return "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u54c1\u724c\u4fe1\u606f";
            }
        }
        return this.enumVerify(reqBO);
    }

    private String enumVerify(UccSkuInfoReqBO reqBO) {
        Map<String, String> map;
        if (reqBO.getSkuStatus() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_STATUS.toString())).containsKey(reqBO.getSkuStatus().toString())) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u5355\u54c1\u72b6\u6001";
        }
        if (reqBO.getSkuSource() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_SOURCE.toString())).containsKey(reqBO.getSkuSource().toString())) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5546\u54c1\u6765\u6e90";
        }
        if (reqBO.getOnShelveWay() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_ON_SHELVE_WAY.toString())).containsKey(reqBO.getOnShelveWay().toString())) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u4e0a\u67b6\u7c7b\u578b";
        }
        return "";
    }
}

