/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.AllCommdTypeRspBo;
import com.tydic.commodity.bo.busi.CommdTypeRspBo;
import com.tydic.commodity.bo.busi.UccQryAllCommdTypeReqBO;
import com.tydic.commodity.bo.busi.UccQryAllCommdTypeRspBO;
import com.tydic.commodity.bo.busi.UccQryCommdTypeReqBO;
import com.tydic.commodity.bo.busi.UccQryCommdTypeRspBO;
import com.tydic.commodity.busi.api.UccQueryCommdTypeBusiService;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.dao.po.UccCatalogDealPO;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.enumType.CommodityTypeEnum;
import com.tydic.commodity.util.ListCloneUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccQueryCommdTypeBusiService.class)
public class UccQueryCommdTypeBusiServiceImpl
implements UccQueryCommdTypeBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQueryCommdTypeBusiServiceImpl.class);
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    @Autowired
    private UccCatRCommdTypeMapper uccCatRCommdTypeMapper;

    public UccQryCommdTypeRspBO queryCommdType(UccQryCommdTypeReqBO qryCommdTypeReqBO) {
        LOGGER.info("\u5546\u54c1\u7c7b\u578b\u5206\u9875\u67e5\u8be2\u5165\u53c2\uff1a{}", JSON.toJSON((Object)qryCommdTypeReqBO));
        ArrayList<Long> commdTypes = new ArrayList();
        if (qryCommdTypeReqBO.getChannelId() != null) {
            UccCatalogDealPO uccCatalogDealPO = new UccCatalogDealPO();
            uccCatalogDealPO.setCatalogLevel(3);
            List<UccCatalogDealPO> catalogDealPOList = this.uccCatalogDealMapper.queryCatalog(uccCatalogDealPO);
            if (catalogDealPOList != null && catalogDealPOList.size() > 0) {
                ArrayList<Long> GuideCatalogIds = new ArrayList<Long>();
                for (UccCatalogDealPO each : catalogDealPOList) {
                    GuideCatalogIds.add(each.getGuideCatalogId());
                }
                commdTypes = this.uccCatRCommdTypeMapper.queryTypeByGuideCatalogIds(GuideCatalogIds);
            }
        }
        UccQryCommdTypeRspBO uccQryCommdTypeRspBO = new UccQryCommdTypeRspBO();
        UccCommodityTypePo uccCommodityTypePo = new UccCommodityTypePo();
        uccCommodityTypePo.setCommodityTypeName(qryCommdTypeReqBO.getCommodityTypeName());
        uccCommodityTypePo.setCommodityTypeStatus(qryCommdTypeReqBO.getCommodityTypeStatus());
        HashMap map = Maps.newHashMap();
        map.put("create_time", true);
        uccCommodityTypePo.setSort(map);
        Page page = new Page(qryCommdTypeReqBO.getPageNo(), qryCommdTypeReqBO.getPageSize());
        List<UccCommodityTypePo> uccCommodityTypePos = this.uccCommodityTypeMapper.queryCommdTypeExcludeId(uccCommodityTypePo, (Page<UccCommodityTypePo>)page, commdTypes);
        List commdTypeRspBOS = null;
        try {
            commdTypeRspBOS = ListCloneUtils.clonePOListToBOList(uccCommodityTypePos, CommdTypeRspBo.class);
        }
        catch (Exception e) {
            LOGGER.error("\u5546\u54c1\u7c7b\u578b\u67e5\u8be2-->\u6570\u636e\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            uccQryCommdTypeRspBO.setRespCode("8888");
            uccQryCommdTypeRspBO.setRespDesc("\u5546\u54c1\u67e5\u8be2\u4e1a\u52a1\u5f02\u5e38");
            return uccQryCommdTypeRspBO;
        }
        for (CommdTypeRspBo commdTypeRspBO : commdTypeRspBOS) {
            DicDictionaryPo dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(commdTypeRspBO.getCommodityTypeStatus().toString(), CommodityTypeEnum.COMMODITY_TYPE_STATUS.toString());
            if (dicDictionaryPo == null) continue;
            commdTypeRspBO.setTypeStatusTranslation(dicDictionaryPo.getTitle());
        }
        uccQryCommdTypeRspBO.setRespCode("0000");
        uccQryCommdTypeRspBO.setRespDesc("\u6210\u529f");
        uccQryCommdTypeRspBO.setRows(commdTypeRspBOS);
        uccQryCommdTypeRspBO.setPageNo(page.getPageNo());
        uccQryCommdTypeRspBO.setTotal(page.getTotalPages());
        uccQryCommdTypeRspBO.setRecordsTotal(page.getTotalCount());
        return uccQryCommdTypeRspBO;
    }

    public UccQryAllCommdTypeRspBO queryAllCommdType(UccQryAllCommdTypeReqBO qryAllCommdTypeReqBO) {
        UccQryAllCommdTypeRspBO uccQryAllCommdTypeRspBO = new UccQryAllCommdTypeRspBO();
        UccCommodityTypePo uccCommodityTypePo = new UccCommodityTypePo();
        BeanUtils.copyProperties((Object)qryAllCommdTypeReqBO, (Object)uccCommodityTypePo);
        List<UccCommodityTypePo> uccCommodityTypePos = this.uccCommodityTypeMapper.queryAllCommdTypeDetails(uccCommodityTypePo);
        List allCommdTypeRspBos = null;
        try {
            allCommdTypeRspBos = ListCloneUtils.clonePOListToBOList(uccCommodityTypePos, AllCommdTypeRspBo.class);
        }
        catch (Exception e) {
            LOGGER.error("\u5546\u54c1\u7c7b\u578b\u67e5\u8be2-->\u6570\u636e\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            uccQryAllCommdTypeRspBO.setRespCode("8888");
            uccQryAllCommdTypeRspBO.setRespDesc("\u5546\u54c1\u67e5\u8be2\u4e1a\u52a1\u5f02\u5e38");
            return uccQryAllCommdTypeRspBO;
        }
        uccQryAllCommdTypeRspBO.setRespCode("0000");
        uccQryAllCommdTypeRspBO.setRespDesc("\u6210\u529f");
        uccQryAllCommdTypeRspBO.setCommdTypeRspBos(allCommdTypeRspBos);
        return uccQryAllCommdTypeRspBO;
    }
}

