/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.bo.busi.BatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.bo.busi.CommodityBo;
import com.tydic.commodity.bo.busi.ProcessStepGroupReqBO;
import com.tydic.commodity.bo.busi.ProcessStepGroupRspBO;
import com.tydic.commodity.bo.busi.UccRejectCommodityReqBO;
import com.tydic.commodity.bo.busi.UccRejectCommodityRspBO;
import com.tydic.commodity.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.busi.api.UccApprovalPassService;
import com.tydic.commodity.busi.api.UccRejcetCommodityBusiService;
import com.tydic.commodity.dao.UccApprovalConfigMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.po.ApprovalConfigPO;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.enumType.ApprovalCommoAuthDetailEnum;
import com.tydic.commodity.enumType.AuditResultStatusEnum;
import com.tydic.commodity.enumType.CommodityStatusEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.validate.ValidatorUtil;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccRejcetCommodityBusiService.class)
public class UccRejcetCommodityBusiServiceImpl
implements UccRejcetCommodityBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccRejcetCommodityBusiServiceImpl.class);
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService auditOrderAuditAbilityService;
    @Value(value="${PROCESS_DEF_ID}")
    private String processDefId;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private BatchUpdateCommoStatusForMarketService statusForMarketService;
    @Autowired
    private UccApprovalConfigMapper approvalConfigMapper;
    @Autowired
    private UccApprovalPassService uccApprovalPassService;

    public UccRejectCommodityRspBO rejectCommodity(UccRejectCommodityReqBO reqBO) {
        ValidatorUtil.validator((Object)reqBO);
        UccRejectCommodityRspBO uccRestoreShelfRspBO = new UccRejectCommodityRspBO();
        if (reqBO.getBusinessId() == null || reqBO.getBusinessId().length < 1) {
            uccRestoreShelfRspBO.setRespCode("8888");
            uccRestoreShelfRspBO.setRespDesc("\u4e1a\u52a1ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return uccRestoreShelfRspBO;
        }
        if (reqBO.getUserId() == null) {
            uccRestoreShelfRspBO.setRespCode("8888");
            uccRestoreShelfRspBO.setRespDesc("\u64cd\u4f5c\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
            return uccRestoreShelfRspBO;
        }
        ProcessStepGroupReqBO processStepGroupReqBO = new ProcessStepGroupReqBO();
        try {
            HashMap<String, String> ext = new HashMap<String, String>();
            ext.put("dealStepName", "\u9a73\u56de");
            processStepGroupReqBO.setCommodityIds(Arrays.asList(reqBO.getBusinessId()));
            ProcessStepGroupRspBO processStepGroupRspBO = this.uccApprovalPassService.processStepGroup(processStepGroupReqBO);
            ApprovalConfigPO approvalConfigPO = new ApprovalConfigPO();
            approvalConfigPO.setApprovalPost(ApprovalCommoAuthDetailEnum.REJECTAPPROVAL.code());
            List<ApprovalConfigPO> approvalConfigPOS = this.approvalConfigMapper.selectByApprovalCode(approvalConfigPO);
            Set entries = processStepGroupRspBO.getCommodityIdMaps().entrySet();
            for (Map.Entry stringListEntry : entries) {
                UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO;
                UacNoTaskAuditOrderAuditReqBO uocAuditAbilityAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
                uocAuditAbilityAuditReqBO.setObjType(Integer.valueOf(2));
                uocAuditAbilityAuditReqBO.setObjId((List)stringListEntry.getValue());
                uocAuditAbilityAuditReqBO.setStepId((String)stringListEntry.getKey());
                uocAuditAbilityAuditReqBO.setAuditResult(Integer.valueOf(0));
                uocAuditAbilityAuditReqBO.setOperId(reqBO.getUsername());
                uocAuditAbilityAuditReqBO.setAuditAdvice(reqBO.getReason());
                uocAuditAbilityAuditReqBO.setUsername(reqBO.getUsername());
                uocAuditAbilityAuditReqBO.setExt(ext);
                try {
                    uacNoTaskAuditOrderAuditRspBO = this.auditOrderAuditAbilityService.dealAudit(uocAuditAbilityAuditReqBO);
                    if (Objects.equals("8888", uacNoTaskAuditOrderAuditRspBO.getRespCode())) {
                        throw new BusinessException(uacNoTaskAuditOrderAuditRspBO.getRespCode(), uacNoTaskAuditOrderAuditRspBO.getRespDesc());
                    }
                }
                catch (BusinessException e) {
                    LOGGER.error("\u9a73\u56de\u5904\u7406\u6d41\u7a0b\u5931\u8d25\uff1a\u539f\u56e0:" + (Object)((Object)e));
                    throw new BusinessException("8888", e.getMessage());
                }
                if (CollectionUtils.isNotEmpty(approvalConfigPOS) && Objects.equals(uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getStepId(), approvalConfigPOS.get(0).getApprovalStatus())) {
                    BatchUpdateCommoStatusForMarketBO batchUpdateCommoStatusForMarketBO = new BatchUpdateCommoStatusForMarketBO();
                    batchUpdateCommoStatusForMarketBO.setBusinessId(reqBO.getBusinessId());
                    batchUpdateCommoStatusForMarketBO.setReason(reqBO.getReason());
                    batchUpdateCommoStatusForMarketBO.setOperId(reqBO.getUsername());
                    this.statusForMarketService.batchUpdateCommoStatusForMarket(batchUpdateCommoStatusForMarketBO, CommodityStatusEnum.REJECT_STATUS, SkuStatusEnum.REJECT_STATUS);
                }
                for (int i = 0; i < ((List)stringListEntry.getValue()).size(); ++i) {
                    CommodityBo commodityBo = new CommodityBo();
                    UccCommodityPo commodityPo = this.uccCommodityMapper.getCommodityById((Long)((List)stringListEntry.getValue()).get(i));
                    BeanUtils.copyProperties((Object)commodityPo, (Object)commodityBo);
                    commodityBo.setApprovalStatus(uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getStepId());
                    this.statusForMarketService.updateCommoApprovalStatus(commodityBo, AuditResultStatusEnum.Audit_Not_Pass);
                }
            }
            uccRestoreShelfRspBO.setRespCode("0000");
            uccRestoreShelfRspBO.setRespDesc("\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u5546\u54c1\u4e2d\u5fc3\u7535\u5b50\u8d85\u5e02\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + (Object)((Object)e));
            uccRestoreShelfRspBO.setRespCode(e.getMsgCode());
            uccRestoreShelfRspBO.setRespDesc(e.getMsgInfo());
            return uccRestoreShelfRspBO;
        }
        return uccRestoreShelfRspBO;
    }
}

