/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.bo.busi.UccRemoveSupplierBusiReqBO;
import com.tydic.commodity.bo.busi.UccRemoveSupplierBusiRspBO;
import com.tydic.commodity.busi.api.UccRemoveSupplierBusiService;
import com.tydic.commodity.businessenums.BusinessRsponseEnums;
import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.po.SupplierBusiPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.validate.ValidatorUtil;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccRemoveSupplierBusiService.class)
public class UccRemoveSupplierBusiServiceImpl
implements UccRemoveSupplierBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccRemoveSupplierBusiServiceImpl.class);
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;

    public UccRemoveSupplierBusiRspBO removeSupplier(UccRemoveSupplierBusiReqBO removeSupplierBusiReqBO) {
        ValidatorUtil.validator((Object)removeSupplierBusiReqBO);
        UccRemoveSupplierBusiRspBO removeSupplierBusiRspBO = new UccRemoveSupplierBusiRspBO();
        SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(removeSupplierBusiReqBO.getSupplierId());
        if (supplierBusiPo == null) {
            removeSupplierBusiRspBO.setRespCode(BusinessRsponseEnums.NOT_EXIST_SUPPLIER.code());
            removeSupplierBusiRspBO.setRespDesc(BusinessRsponseEnums.NOT_EXIST_SUPPLIER.message());
            return removeSupplierBusiRspBO;
        }
        List<SupplierShopPo> supplierShopPoList = this.supplierShopMapper.selectSupplierShopBySupplierId(removeSupplierBusiReqBO.getSupplierId());
        if (CollectionUtils.isNotEmpty(supplierShopPoList)) {
            removeSupplierBusiRspBO.setRespCode("8888");
            removeSupplierBusiRspBO.setRespDesc("\u5b58\u5728\u5e97\u94fa\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        removeSupplierBusiRspBO.setRespCode("0000");
        removeSupplierBusiRspBO.setRespDesc("\u6210\u529f");
        this.supplierMapper.removeSupplierById(removeSupplierBusiReqBO);
        return removeSupplierBusiRspBO;
    }
}

