/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.bo.busi.UccSendMessageReqBO;
import com.tydic.commodity.bo.busi.UccSendMessageRspBO;
import com.tydic.commodity.busi.api.LmMeassageBO;
import com.tydic.commodity.busi.api.UccSendMessageService;
import com.tydic.commodity.config.vo.LMProperticeVo;
import com.tydic.commodity.dao.UccSceneMapper;
import com.tydic.commodity.dao.po.ScenePO;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccSendMessageService.class)
public class UccSendMessageServiceImpl
implements UccSendMessageService {
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private LMProperticeVo lmProperticeVo;
    @Autowired
    private UccSceneMapper sceneMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccSendMessageServiceImpl.class);

    public UccSendMessageRspBO dealMessage(UccSendMessageReqBO reqBO) {
        UccSendMessageRspBO rspBO = new UccSendMessageRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List<Object> sceneIds = new ArrayList<Long>();
        if (reqBO.getSceneId() == null) {
            ScenePO scenePO = new ScenePO();
            List<ScenePO> scenePOS = this.sceneMapper.getList(scenePO);
            if (CollectionUtils.isNotEmpty(scenePOS)) {
                sceneIds = scenePOS.stream().map(ScenePO::getSceneId).collect(Collectors.toList());
            }
        } else {
            sceneIds.add(reqBO.getSceneId());
        }
        try {
            for (int i = 0; i < sceneIds.size(); ++i) {
                LmMeassageBO lmMeassageBO = new LmMeassageBO();
                BeanUtils.copyProperties((Object)reqBO, (Object)lmMeassageBO);
                lmMeassageBO.setSceneId((Long)sceneIds.get(i));
                LOGGER.info("\u53d1\u9001\u6d88\u606f\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString((Object)lmMeassageBO));
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmProperticeVo.getLMSyncTopic(), this.lmProperticeVo.getLMSyncTag(), JSON.toJSONString((Object)lmMeassageBO)));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u53d1\u9001\u540c\u6b65\u6d88\u606f\u5931\u8d25");
        }
        return rspBO;
    }
}

