/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.comb.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.bo.busi.UccCurrentPriceQryReqBO;
import com.tydic.commodity.bo.busi.UccCurrentPriceQryRspBO;
import com.tydic.commodity.bo.comb.UccAddCoefficientSynPriceCombReqBo;
import com.tydic.commodity.bo.comb.UccAddCoefficientSynPriceCombRspBo;
import com.tydic.commodity.busi.api.QueryDBDateBusiService;
import com.tydic.commodity.busi.api.UccCurrentPriceQryBusiService;
import com.tydic.commodity.comb.api.UccAddCoefficientSynPriceCombService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccAddCoefficientMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccAddCoefficientPO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccAddCoefficientSynPriceCombService.class)
public class UccAddCoefficientSynPriceCombServiceImpl
implements UccAddCoefficientSynPriceCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccAddCoefficientSynPriceCombServiceImpl.class);
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private UccAddCoefficientMapper uccAddCoefficientMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="UCC_GROUP_DEV")
    private UccCurrentPriceQryBusiService uccCurrentPriceQryBusiService;
    private static final int SIZE = 100;

    public UccAddCoefficientSynPriceCombRspBo sync(UccAddCoefficientSynPriceCombReqBo reqBo) {
        UccAddCoefficientSynPriceCombRspBo rspBo = new UccAddCoefficientSynPriceCombRspBo();
        SupplierShopPo supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(reqBo.getSupplierShopId());
        if (supplierShopPo == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8bf7\u786e\u8ba4\u5e97\u94faID\u662f\u5426\u6b63\u786e");
            return rspBo;
        }
        Date now = this.queryDBDateBusiService.getDBDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date endDate = calendar.getTime();
        calendar.add(5, -1);
        Date strarDate = calendar.getTime();
        List<UccAddCoefficientPO> coefficientPOs = this.uccAddCoefficientMapper.qryModifyRecordsByTime(strarDate, endDate, reqBo.getSupplierShopId());
        if (coefficientPOs == null || coefficientPOs.size() == 0) {
            LOGGER.info("\u52a0\u4ef7\u7cfb\u6570\u65e0\u5904\u7406\u5185\u5bb9");
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u52a0\u4ef7\u7cfb\u6570\u65e0\u5904\u7406\u5185\u5bb9");
            return rspBo;
        }
        ArrayList<Long> catalogIds = new ArrayList<Long>();
        for (UccAddCoefficientPO each : coefficientPOs) {
            catalogIds.add(each.getCatalogId());
        }
        List<Long> commodityTypeIds = this.uccCommodityTypeMapper.qeryTypeIdByCatalogIds(catalogIds);
        if (commodityTypeIds == null || commodityTypeIds.size() == 0) {
            LOGGER.info("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u7c7b\u578b\u4fe1\u606f");
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u7c7b\u578b\u4fe1\u606f");
            return rspBo;
        }
        int count = this.uccSkuMapper.querySkuIdByCommTypeIdCounts(commodityTypeIds, reqBo.getSupplierShopId());
        if (count == 0) {
            LOGGER.info("\u672a\u67e5\u8be2\u5230\u5355\u54c1\u4fe1\u606f");
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5355\u54c1\u4fe1\u606f");
            return rspBo;
        }
        int frequency = count % 100 == 0 ? count / 100 : count / 100 + 1;
        int star = 0;
        int end = 0;
        for (int i = 0; i < frequency; ++i) {
            star = end;
            end = star + 100;
            List<Long> skuIds = this.uccSkuMapper.querySkuIdByCommTypeId(commodityTypeIds, reqBo.getSupplierShopId(), star, end);
            UccCurrentPriceQryReqBO uccCurrentPriceQryReqBO = new UccCurrentPriceQryReqBO();
            uccCurrentPriceQryReqBO.setSkuIds(skuIds);
            uccCurrentPriceQryReqBO.setSupplierShopId(reqBo.getSupplierShopId());
            UccCurrentPriceQryRspBO uccCurrentPriceQryRspBO = this.uccCurrentPriceQryBusiService.changeCommdCurrentPrice(uccCurrentPriceQryReqBO);
            if ("0000".equals(uccCurrentPriceQryRspBO.getRespCode())) continue;
            LOGGER.info(uccCurrentPriceQryRspBO.getRespDesc());
            BeanUtils.copyProperties((Object)uccCurrentPriceQryRspBO, (Object)rspBo);
            return rspBo;
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u5904\u7406\u6210\u529f");
        return rspBo;
    }
}

