/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.controller.busi;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.bo.busi.CreataESSkuDataReqBO;
import com.tydic.commodity.bo.busi.CreataESSkuDataRspBO;
import com.tydic.commodity.comb.api.UccESCreateSkuDataCombService;
import com.tydic.commodity.controller.vo.CreateESSkuDataReqvVO;
import com.tydic.commodity.controller.vo.CreateESSkuDataRspvVO;
import com.tydic.commodity.controller.vo.TaskReqVO;
import com.tydic.commodity.controller.vo.TaskRespVO;
import com.tydic.commodity.controller.vo.TaskRsp;
import com.tydic.commodity.enumType.CreateESSkuStrategyEnum;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ucc/createskudata/busi"})
public class CreateESsKUDataController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateESsKUDataController.class);
    @Autowired
    private UccESCreateSkuDataCombService uccESCreateSkuDataCombService;

    @RequestMapping(value={"/createesskudata"}, method={RequestMethod.POST})
    public CreateESSkuDataRspvVO createESSkuData(@RequestBody CreateESSkuDataReqvVO reqBO) {
        CreateESSkuDataRspvVO createESSkuDataRspvVO = new CreateESSkuDataRspvVO();
        CreataESSkuDataReqBO creataESSkuDataReqBO = new CreataESSkuDataReqBO();
        if (StringUtils.isBlank((String)reqBO.getStrategy())) {
            creataESSkuDataReqBO.setCreateESSkuStrategyEnum(CreateESSkuStrategyEnum.TIMER_TASK);
        } else if (CreateESSkuStrategyEnum.SKU.toString().equals(reqBO.getStrategy())) {
            creataESSkuDataReqBO.setCreateESSkuStrategyEnum(CreateESSkuStrategyEnum.SKU);
        } else if (CreateESSkuStrategyEnum.COMMODITY.toString().equals(reqBO.getStrategy())) {
            creataESSkuDataReqBO.setCreateESSkuStrategyEnum(CreateESSkuStrategyEnum.COMMODITY);
        }
        creataESSkuDataReqBO.setBusinessId(reqBO.getBusinessId());
        CreataESSkuDataRspBO creataESSkuDataRspBO = this.uccESCreateSkuDataCombService.createESSkuData(creataESSkuDataReqBO.getBusinessId(), creataESSkuDataReqBO.getCreateESSkuStrategyEnum());
        createESSkuDataRspvVO.setRespCode(creataESSkuDataRspBO.getRespCode());
        createESSkuDataRspvVO.setRespDesc(creataESSkuDataRspBO.getRespDesc());
        return createESSkuDataRspvVO;
    }

    @RequestMapping(value={"/synSkuEs"}, method={RequestMethod.POST})
    public TaskRespVO dtMsgPost(@RequestBody TaskReqVO reqBO) {
        LOGGER.info("\u8c03\u7528\u5b9a\u65f6\u4efb\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        TaskRespVO rspBo = new TaskRespVO();
        CreataESSkuDataRspBO creataESSkuDataRspBO = this.uccESCreateSkuDataCombService.createESSkuData(null, CreateESSkuStrategyEnum.TIMER_TASK);
        rspBo.setRsp(new TaskRsp(creataESSkuDataRspBO.getRespCode()));
        return rspBo;
    }
}

