/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.controller.busi;

import com.google.common.collect.Lists;
import com.tydic.commodity.bo.busi.OssFileDeleteBO;
import com.tydic.commodity.bo.busi.UccOssFileDeleteReqBO;
import com.tydic.commodity.bo.busi.UccOssFileDeleteRspBO;
import com.tydic.commodity.bo.busi.UccOssUploadFileReqBO;
import com.tydic.commodity.bo.busi.UccOssUploadFileRspBO;
import com.tydic.commodity.bo.busi.UccOssUploadFileServiceReqBO;
import com.tydic.commodity.busi.api.UccOssFileDeleteService;
import com.tydic.commodity.busi.api.UccOssUploadFileService;
import com.tydic.commodity.controller.vo.UccOssDeleteFileReqVo;
import com.tydic.commodity.validate.ValidatorUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ucc/busi/ossFile"})
public class OssFileController {
    @Autowired
    private UccOssUploadFileService uccOssUploadFileService;
    @Autowired
    private UccOssFileDeleteService uccOssFileDeleteService;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${oss.preview}")
    private String preview;

    @RequestMapping(value={"uploadFile"}, method={RequestMethod.POST})
    public UccOssUploadFileRspBO uploadFile(UccOssUploadFileReqBO uccOssUploadFileReqBO) {
        UccOssUploadFileRspBO uccOssUploadFileRspBO = new UccOssUploadFileRspBO();
        try {
            ValidatorUtil.validator((Object)uccOssUploadFileReqBO);
        }
        catch (Exception e) {
            uccOssUploadFileRspBO.setRespDesc(e.getMessage());
            uccOssUploadFileRspBO.setRespCode("8888");
            return uccOssUploadFileRspBO;
        }
        String base64Img = null;
        try {
            base64Img = new String(Base64.encodeBase64((byte[])uccOssUploadFileReqBO.getFile().getBytes()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        UccOssUploadFileServiceReqBO uccOssUploadFileServiceReqBO = new UccOssUploadFileServiceReqBO();
        if (base64Img != null) {
            uccOssUploadFileServiceReqBO.setBase64Img(base64Img);
        }
        uccOssUploadFileServiceReqBO.setBusinessId(uccOssUploadFileReqBO.getBusinessId());
        uccOssUploadFileServiceReqBO.setCreateOperId(uccOssUploadFileReqBO.getCreateOperId());
        return this.uccOssUploadFileService.uploadFile(uccOssUploadFileServiceReqBO);
    }

    @RequestMapping(value={"deleteFile"}, method={RequestMethod.POST})
    public UccOssFileDeleteRspBO deleteFile(@RequestBody UccOssDeleteFileReqVo uccOssDeleteFileReqVo) {
        UccOssFileDeleteReqBO uccOssFileDeleteReqBO = new UccOssFileDeleteReqBO();
        OssFileDeleteBO ossFileDeleteBO = new OssFileDeleteBO();
        ArrayList ossFileDeleteBOS = Lists.newArrayList();
        List<String> ossFileUrls = uccOssDeleteFileReqVo.getOssFileUrls();
        if (CollectionUtils.isNotEmpty(ossFileUrls)) {
            for (String ossFileUrl : ossFileUrls) {
                String osskey = ossFileUrl.substring(this.accessUrl.length() + 1, ossFileUrl.length());
                ossFileDeleteBO.setOssKey(osskey);
                ossFileDeleteBOS.add(ossFileDeleteBO);
            }
        }
        uccOssFileDeleteReqBO.setOssFileDeleteBOS((List)ossFileDeleteBOS);
        return this.uccOssFileDeleteService.deleteOSSFile(uccOssFileDeleteReqBO);
    }
}

