/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.atom.BO.UccDealCommodityReqBO;
import com.tydic.commodity.atom.BO.UccDealCommodityRespBO;
import com.tydic.commodity.atom.UccDealCommodityAtomService;
import com.tydic.commodity.busi.impl.UccDealAddBySkuBusiServiceImpl;
import com.tydic.commodity.dao.ComInitMapper;
import com.tydic.commodity.dao.ExternSkuDetailMapper;
import com.tydic.commodity.dao.po.BrandPO;
import com.tydic.commodity.dao.po.ComPackagePO;
import com.tydic.commodity.dao.po.ComPicPO;
import com.tydic.commodity.dao.po.CommodityPO;
import com.tydic.commodity.dao.po.SkuPO;
import com.tydic.commodity.dao.po.SkuPricePO;
import com.tydic.commodity.dao.po.SkuSalePO;
import com.tydic.commodity.dao.po.SpuSpecPO;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.CacheMap;
import com.tydic.commodity.utils.MoneyUtil;
import com.tydic.commodity.utils.SequenceUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="uccDealCommodityAtomService")
public class UccDealCommodityAtomServiceImpl
implements UccDealCommodityAtomService {
    private static final Logger LOG = LoggerFactory.getLogger(UccDealAddBySkuBusiServiceImpl.class);
    private CacheMap cacheMap = CacheMap.getInstance();
    @Autowired
    private ComInitMapper comInitMapper;
    @Autowired
    private ExternSkuDetailMapper externSkuDetailMapper;
    private static final Integer PAGE_SIZE = 500;

    @Override
    public UccDealCommodityRespBO dealCommodity(UccDealCommodityReqBO uccDealCommodityReqBO) {
        Integer supplierSource;
        JdbcTemplate jdbcTemplate = uccDealCommodityReqBO.getJdbcTemplate();
        String supplierCode = uccDealCommodityReqBO.getSupplierCode();
        Long aLong = this.comInitMapper.getSupplier(supplierCode, supplierSource = uccDealCommodityReqBO.getSupplierSource());
        if (null == aLong) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u4fe1\u606f");
        }
        Long supplierShopId = this.comInitMapper.getSupplierShopId(aLong);
        if (null == supplierShopId) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u4fe1\u606f");
        }
        SequenceUtil sequenceCom = new SequenceUtil(jdbcTemplate, "SEQ_UCC_COMMODITY");
        SequenceUtil sequenceSku = new SequenceUtil(jdbcTemplate, "SEQ_UCC_SKU");
        Sequence sequenceUtil = Sequence.getInstance();
        List<Map<String, Object>> maps = this.comInitMapper.getCatalogByEcommerce(uccDealCommodityReqBO.getSkuCodeList(), aLong);
        if (CollectionUtils.isEmpty(maps)) {
            maps = this.comInitMapper.getCatalogByEmdm(uccDealCommodityReqBO.getSkuCodeList());
        }
        if (!CollectionUtils.isEmpty(maps)) {
            Map<String, Object> vendorInfo = this.comInitMapper.getVendorInfo(aLong);
            for (Map<String, Object> next : maps) {
                String typeId = next.get("COMMODITY_TYPE_ID").toString();
                String cataLogId = next.get("CATALOG_ID").toString();
                String inCataLogId = next.get("IN_CATALOG_ID").toString();
                List<Map<String, Object>> maps2 = this.externSkuDetailMapper.getSkuList(cataLogId, supplierCode, uccDealCommodityReqBO.getSkuCodeList());
                if (CollectionUtils.isEmpty(maps2)) continue;
                LOG.info("\u5904\u7406\u54c1\u724c\u4fe1\u606f\u5f00\u59cb,cataLogId={}", (Object)cataLogId);
                List<Map<String, Object>> maps3 = this.externSkuDetailMapper.getBrandList(cataLogId, supplierCode, uccDealCommodityReqBO.getSkuCodeList());
                if (!CollectionUtils.isEmpty(maps3)) {
                    ArrayList<BrandPO> brandList = new ArrayList<BrandPO>();
                    Iterator<Map<String, Object>> iterator1 = maps3.iterator();
                    SimpleDateFormat sf = new SimpleDateFormat("yyyy-mm-dd");
                    Date parse = null;
                    try {
                        parse = sf.parse("2099-12-31");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    while (iterator1.hasNext()) {
                        Map<String, Object> next1 = iterator1.next();
                        List<Map<String, Object>> brand_name = this.comInitMapper.checkBrand((String)next1.get("brand_name"));
                        if (!CollectionUtils.isEmpty(brand_name)) continue;
                        BrandPO brandParm = new BrandPO();
                        brandParm.setBrandId(sequenceUtil.nextId());
                        brandParm.setBrandCode("brand_code");
                        brandParm.setBrandEnName(null);
                        brandParm.setBrandName((String)next1.get("brand_name"));
                        brandParm.setBrandLogo(null);
                        brandParm.setEffTime(new Date());
                        brandParm.setExpTime(parse);
                        brandParm.setBrandStatus(1);
                        brandParm.setBrandDesc(null);
                        brandParm.setTrademarkNum(null);
                        brandParm.setBrandOwner(null);
                        brandParm.setTrademarkCard(null);
                        brandParm.setCreateOperId("sys");
                        brandParm.setCreateTime(new Date());
                        brandParm.setRemark(null);
                        brandParm.setBrandType(0);
                        brandList.add(brandParm);
                    }
                    if (!CollectionUtils.isEmpty(brandList)) {
                        this.comInitMapper.insertBrand(brandList);
                    }
                }
                LOG.info("\u5904\u7406\u54c1\u724c\u4fe1\u606f\u7ed3\u675f");
                Page commodityPage = new Page(1, PAGE_SIZE.intValue());
                this.comInitMapper.getCommodityPage(supplierShopId, inCataLogId, cataLogId, supplierCode, uccDealCommodityReqBO.getSkuCodeList(), (Page<List<Map<String, Object>>>)commodityPage);
                int pageCount = commodityPage.getTotalPages();
                Long commodityId = this.getCacheId(0, sequenceCom);
                for (int i = 1; i <= pageCount; ++i) {
                    LOG.info("\u5904\u7406\u5546\u54c1\u4fe1\u606f\u7b2c{}\u9875\u5f00\u59cb", (Object)i);
                    commodityPage = new Page(i, PAGE_SIZE.intValue());
                    List<Map<String, Object>> pageRecord = this.comInitMapper.getCommodityPage(supplierShopId, inCataLogId, cataLogId, supplierCode, uccDealCommodityReqBO.getSkuCodeList(), (Page<List<Map<String, Object>>>)commodityPage);
                    if (!CollectionUtils.isEmpty(pageRecord)) {
                        Iterator<Map<String, Object>> iterator1 = pageRecord.iterator();
                        ArrayList<CommodityPO> commodityParm = new ArrayList<CommodityPO>();
                        while (iterator1.hasNext()) {
                            Map<String, Object> next1 = iterator1.next();
                            CommodityPO parm = new CommodityPO();
                            parm.setCommodityId(commodityId);
                            parm.setCommodityCode((String)next1.get("COMMODITY_CODE"));
                            parm.setCommodityName((String)next1.get("name"));
                            parm.setCommodityTypeId((Long)next1.get("COMMODITY_TYPE_ID"));
                            parm.setCommoditySource(2);
                            parm.setCommodityStatus(0);
                            parm.setSupplierShopId((Long)next1.get("SUPPLIER_SHOP_ID"));
                            parm.setShopName((String)next1.get("SHOP_NAME"));
                            parm.setCommodityBanner(null);
                            parm.setCommodityLinkChar(null);
                            parm.setCommodityLinkUrl(null);
                            parm.setBrandId((Long)next1.get("BRAND_ID"));
                            parm.setBrandName((String)next1.get("BRAND_NAME"));
                            parm.setAgreementId(null);
                            parm.setServenRejectAllow(1);
                            parm.setCommodityPcDetailUrl((String)next1.get("introduction"));
                            parm.setCommodityPcDetailChar((String)next1.get("introduction"));
                            parm.setCommodityPhoneDetailUrl(null);
                            parm.setCommodityPhoneDetailChar(null);
                            parm.setMaterialId(null);
                            parm.setExtSkuId((String)next1.get("sku"));
                            parm.setUpcCode((String)next1.get("upc"));
                            parm.setStoreGetType(2);
                            parm.setCreateOperId("sys");
                            parm.setCreateTime(new Date());
                            parm.setRemark(supplierCode);
                            parm.setVendorId((Long)vendorInfo.get("VENDOR_ID"));
                            parm.setVendorShopId((Long)vendorInfo.get("ID"));
                            commodityParm.add(parm);
                        }
                        if (!CollectionUtils.isEmpty(commodityParm)) {
                            this.comInitMapper.insertCommodity(commodityParm);
                        }
                    }
                    LOG.info("\u5904\u7406\u5546\u54c1\u4fe1\u606f\u7b2c{}\u9875\u7ed3\u675f", (Object)i);
                }
                LOG.info("\u5904\u7406\u5546\u54c1\u4fe1\u606f\u7ed3\u675f");
                LOG.info("\u5904\u7406\u5355\u54c1\u4fe1\u606f:supplierCode={},cataLogId={}", (Object)supplierCode, (Object)cataLogId);
                Page skuPage = new Page(1, PAGE_SIZE.intValue());
                this.comInitMapper.getSkuPage(commodityId, inCataLogId, (Page<List<Map<String, Object>>>)skuPage);
                int pageCountSku = skuPage.getTotalPages();
                for (int i = 1; i <= pageCountSku; ++i) {
                    skuPage = new Page(i, PAGE_SIZE.intValue());
                    List<Map<String, Object>> pageRecord = this.comInitMapper.getSkuPage(commodityId, inCataLogId, (Page<List<Map<String, Object>>>)skuPage);
                    if (CollectionUtils.isEmpty(pageRecord)) continue;
                    ArrayList<SkuPO> skuParm = new ArrayList<SkuPO>();
                    ArrayList<SkuSalePO> skuSale = new ArrayList<SkuSalePO>();
                    for (Map<String, Object> next1 : pageRecord) {
                        Long skuId = this.getCacheId(1, sequenceSku);
                        SkuPO skuP = new SkuPO();
                        skuP.setSkuId(skuId);
                        skuP.setCommodityId((Long)next1.get("COMMODITY_ID"));
                        skuP.setSupplierShopId((Long)next1.get("SUPPLIER_SHOP_ID"));
                        skuP.setShopName((String)next1.get("SHOP_NAME"));
                        skuP.setCommodityTypeId((Long)next1.get("COMMODITY_TYPE_ID"));
                        skuP.setSkuPrice(0L);
                        skuP.setSkuCode((String)next1.get("sku_code"));
                        skuP.setSkuSource(2);
                        skuP.setSkuName((String)next1.get("COMMODITY_NAME"));
                        skuP.setSkuLongName((String)next1.get("COMMODITY_NAME"));
                        skuP.setSkuPcDetailUrl((String)next1.get("COMMODITY_PC_DETAIL_URL"));
                        skuP.setSkuPcDetailChar((String)next1.get("COMMODITY_PC_DETAIL_CHAR"));
                        skuP.setSkuPhoneDetailUrl((String)next1.get("COMMODITY_PHONE_DETAIL_URL"));
                        skuP.setSkuPhoneDetailChar((String)next1.get("COMMODITY_PHONE_DETAIL_CHAR"));
                        skuP.setSkuStatus(0);
                        skuP.setPreDeliverDay(0);
                        skuP.setBrandId((Long)next1.get("BRAND_ID"));
                        skuP.setBrandName((String)next1.get("BRAND_NAME"));
                        skuP.setAgreementId(null);
                        skuP.setMeasureId((Long)next1.get("MEASURE_ID"));
                        skuP.setMeasureName((String)next1.get("MEASURE_NAME"));
                        skuP.setMoq(Integer.valueOf((String)next1.get("MOQ")));
                        skuP.setMfgsku(null);
                        skuP.setIsSupplierAgreement(0);
                        skuP.setMaterialId(null);
                        skuP.setExtSkuId((String)next1.get("EXT_SKU_ID"));
                        skuP.setUpcCode((String)next1.get("UPC_CODE"));
                        skuP.setOnShelveTime(new Date());
                        skuP.setOnShelveWay(1);
                        skuP.setPreOnShelveDay(0);
                        skuP.setCreateOperId("sys");
                        skuP.setCreateTime(new Date());
                        skuP.setRemark(supplierCode);
                        skuP.setRate((BigDecimal)next1.get("RATE"));
                        skuParm.add(skuP);
                        SkuSalePO skuSaleP = new SkuSalePO();
                        skuSaleP.setSaleId(sequenceUtil.nextId());
                        skuSaleP.setSkuId(skuId);
                        skuSaleP.setSupplierShopId((Long)next1.get("SUPPLIER_SHOP_ID"));
                        skuSaleP.setSoldNum(BigDecimal.ZERO);
                        skuSaleP.setCreateOperId("sys");
                        skuSaleP.setCreateTime(new Date());
                        skuSale.add(skuSaleP);
                    }
                    if (!CollectionUtils.isEmpty(skuParm)) {
                        this.comInitMapper.insertSku(skuParm);
                    }
                    if (CollectionUtils.isEmpty(skuSale)) continue;
                    this.comInitMapper.insertSkuSale(skuSale);
                }
                LOG.info("\u5904\u7406\u5355\u54c1\u4fe1\u606f\u7ed3\u675f");
                LOG.info("\u5904\u7406\u4ef7\u683c\u5f00\u59cb");
                List<Map<String, Object>> maps1 = this.comInitMapper.getCoefficient(aLong, inCataLogId);
                Iterator<Map<String, Object>> iterator2 = maps1.iterator();
                BigDecimal addCoefficient = new BigDecimal(1.0);
                while (iterator2.hasNext()) {
                    Map<String, Object> next1 = iterator2.next();
                    Object add_coefficient = next1.get("ADD_COEFFICIENT");
                    if (add_coefficient == null) continue;
                    addCoefficient = (BigDecimal)add_coefficient;
                    addCoefficient = addCoefficient.divide(new BigDecimal(100), 4);
                    addCoefficient = addCoefficient.add(BigDecimal.ONE);
                }
                Page skuPricePage = new Page(1, PAGE_SIZE.intValue());
                this.comInitMapper.getSkuPricePage(inCataLogId, supplierCode, uccDealCommodityReqBO.getSkuCodeList(), (Page<List<Map<String, Object>>>)skuPricePage);
                int pageCountSkuPrice = skuPricePage.getTotalPages();
                for (int i = 1; i <= pageCountSkuPrice; ++i) {
                    skuPricePage = new Page(i, PAGE_SIZE.intValue());
                    List<Map<String, Object>> pageRecord = this.comInitMapper.getSkuPricePage(inCataLogId, supplierCode, uccDealCommodityReqBO.getSkuCodeList(), (Page<List<Map<String, Object>>>)skuPricePage);
                    if (CollectionUtils.isEmpty(pageRecord)) continue;
                    Iterator<Map<String, Object>> iterator1 = pageRecord.iterator();
                    ArrayList<SkuPricePO> skuPriceParm = new ArrayList<SkuPricePO>();
                    while (iterator1.hasNext()) {
                        Map<String, Object> next1 = iterator1.next();
                        Object salePriceObj = next1.get("CON_PRICE");
                        Long salePrice = 0L;
                        Long addSalePrice = 0L;
                        if (salePriceObj != null) {
                            BigDecimal salePriceObj1 = (BigDecimal)salePriceObj;
                            BigDecimal multiply = salePriceObj1.multiply(addCoefficient);
                            multiply = multiply.setScale(2, 4);
                            try {
                                salePrice = MoneyUtil.BigDecimal2Long(salePriceObj1);
                                addSalePrice = MoneyUtil.BigDecimal2Long(multiply);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        Object externalPriceObj = next1.get("EXTERNAL_PRICE");
                        Long externalPrice = 0L;
                        Long marketPrice = 0L;
                        if (externalPriceObj != null) {
                            BigDecimal externalPriceObj1 = (BigDecimal)externalPriceObj;
                            try {
                                externalPrice = MoneyUtil.BigDecimal2Long(externalPriceObj1);
                                marketPrice = MoneyUtil.BigDecimal2Long(externalPriceObj1);
                            }
                            catch (Exception e) {
                                LOG.error("\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                                e.printStackTrace();
                            }
                        }
                        SkuPricePO priceP = new SkuPricePO();
                        priceP.setSkuPriceId(sequenceUtil.nextId());
                        priceP.setSkuId((Long)next1.get("SKU_ID"));
                        priceP.setSupplierShopId((Long)next1.get("SUPPLIER_SHOP_ID"));
                        priceP.setMarketPrice(marketPrice);
                        priceP.setAgreementPrice(salePrice);
                        priceP.setSalePrice(addSalePrice);
                        priceP.setMemberPrice1(externalPrice);
                        priceP.setMemberPrice2(externalPrice);
                        priceP.setMemberPrice3(externalPrice);
                        priceP.setMemberPrice4(externalPrice);
                        priceP.setMemberPrice5(externalPrice);
                        priceP.setCurrencyType(0);
                        priceP.setCreateOperId("sys");
                        priceP.setCreateTime(new Date());
                        priceP.setRemark(String.valueOf(next1.get("COMMODITY_TYPE_ID")));
                        skuPriceParm.add(priceP);
                        String ext_sku_id = this.externSkuDetailMapper.getMfgsku(supplierCode, (String)next1.get("EXT_SKU_ID"));
                        this.comInitMapper.updateSkuPriceAndMfgsku(salePrice, ext_sku_id, (String)next1.get("EXT_SKU_ID"));
                    }
                    if (CollectionUtils.isEmpty(skuPriceParm)) continue;
                    this.comInitMapper.insertSkuPrice(skuPriceParm);
                }
            }
        } else {
            LOG.info("\u672a\u67e5\u8be2\u5230\u9700\u5904\u7406\u7684\u5546\u54c1\u7c7b\u76ee");
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u9700\u5904\u7406\u7684\u5546\u54c1\u7c7b\u76ee");
        }
        List<Map<String, Object>> maps1 = this.comInitMapper.getComTypeAndCate4(supplierCode, uccDealCommodityReqBO.getSkuCodeList());
        if (!CollectionUtils.isEmpty(maps1)) {
            for (Map<String, Object> next : maps1) {
                String extSku = (String)next.get("SKU");
                String catalogId = (String)next.get("SKU_CATE4");
                LOG.info("\u5904\u7406\u5546\u54c1:" + extSku);
                List<Map<String, Object>> propRelList = this.comInitMapper.getPropValueId(extSku);
                if (CollectionUtils.isEmpty(propRelList)) continue;
                ArrayList<SpuSpecPO> spuSpecParm = new ArrayList<SpuSpecPO>();
                for (Map<String, Object> propRelNext : propRelList) {
                    Long propValueListId = (Long)propRelNext.get("PROP_VALUE_LIST_ID");
                    List<Map<String, Object>> valueListMap = this.comInitMapper.getValueListMap(propValueListId);
                    if (CollectionUtils.isEmpty(valueListMap)) continue;
                    for (Map<String, Object> valuerListNext : valueListMap) {
                        Long COMMODITY_PROP_GRP_ID;
                        List<Map<String, Object>> propDefMaps = this.comInitMapper.getPropDefMap((Long)valuerListNext.get("COMMODITY_PROP_DEF_ID"));
                        String PROP_NAME = null;
                        String SHOW_NAME = null;
                        if (!CollectionUtils.isEmpty(propDefMaps)) {
                            for (Map<String, Object> propDefNext : propDefMaps) {
                                PROP_NAME = (String)propDefNext.get("PROP_NAME");
                                SHOW_NAME = (String)propDefNext.get("SHOW_NAME");
                            }
                        }
                        if (null == (COMMODITY_PROP_GRP_ID = this.comInitMapper.getPropGrpId((Long)valuerListNext.get("COMMODITY_PROP_DEF_ID"), catalogId))) {
                            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5c5e\u6027\u7ec4ID");
                        }
                        String COMMODITY_PROP_GRP_NAME = this.comInitMapper.getPropGrpName(COMMODITY_PROP_GRP_ID);
                        if (!StringUtils.hasText((String)COMMODITY_PROP_GRP_NAME)) {
                            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5c5e\u6027\u7ec4ID");
                        }
                        SpuSpecPO spuSpec = new SpuSpecPO();
                        spuSpec.setCommoditySpecId(sequenceUtil.nextId());
                        spuSpec.setCommodityId((Long)next.get("COMMODITY_ID"));
                        spuSpec.setSupplierShopId((Long)next.get("SUPPLIER_SHOP_ID"));
                        spuSpec.setCommodityPropGrpId(COMMODITY_PROP_GRP_ID);
                        spuSpec.setCommodityPropGrpName(COMMODITY_PROP_GRP_NAME);
                        spuSpec.setCommodityPropDefId((Long)valuerListNext.get("COMMODITY_PROP_DEF_ID"));
                        spuSpec.setPropName(PROP_NAME);
                        spuSpec.setPropShowName(SHOW_NAME);
                        spuSpec.setPropValueListId((Long)valuerListNext.get("prop_value_list_id"));
                        spuSpec.setPropValue((String)valuerListNext.get("prop_value"));
                        spuSpec.setCreateOperId("sys");
                        spuSpec.setCreateTime(new Date());
                        spuSpec.setRemark(String.valueOf(valuerListNext.get("COMMODITY_TYPE_ID")));
                        spuSpecParm.add(spuSpec);
                    }
                }
                if (!CollectionUtils.isEmpty(spuSpecParm)) {
                    this.comInitMapper.insertSpuSpec(spuSpecParm);
                }
                this.comInitMapper.deleteSkuPropRel(extSku);
            }
        }
        Page comPicPage = new Page(1, PAGE_SIZE.intValue());
        this.comInitMapper.getComPicPage(supplierCode, uccDealCommodityReqBO.getSkuCodeList(), (Page<List<Map<String, Object>>>)comPicPage);
        int pageCommodityPic = comPicPage.getTotalPages();
        for (int i = 1; i <= pageCommodityPic; ++i) {
            comPicPage = new Page(i, PAGE_SIZE.intValue());
            List<Map<String, Object>> pageRecord = this.comInitMapper.getComPicPage(supplierCode, uccDealCommodityReqBO.getSkuCodeList(), (Page<List<Map<String, Object>>>)comPicPage);
            if (CollectionUtils.isEmpty(pageRecord)) continue;
            ArrayList<ComPicPO> picParmList = new ArrayList<ComPicPO>();
            ArrayList<ComPicPO> picParmList2 = new ArrayList<ComPicPO>();
            for (Map<String, Object> next : pageRecord) {
                String imagePath = (String)next.get("IMAGE_PATH");
                if (StringUtils.isEmpty((Object)imagePath) || "empty".equals(imagePath)) continue;
                ComPicPO picParm = new ComPicPO();
                picParm.setCommodityPicId(sequenceUtil.nextId());
                picParm.setCommodityId((Long)next.get("COMMODITY_ID"));
                picParm.setCommodityPicType(1);
                picParm.setCommodityPicUrl(imagePath);
                picParm.setSupplierShopId((Long)next.get("SUPPLIER_SHOP_ID"));
                picParm.setCreateOperId("sys");
                picParm.setCreateTime(new Date());
                picParm.setRemark(supplierCode);
                ComPicPO picParm2 = new ComPicPO();
                picParm2.setCommodityPicId(sequenceUtil.nextId());
                picParm2.setCommodityId((Long)next.get("COMMODITY_ID"));
                picParm2.setCommodityPicType(2);
                picParm2.setCommodityPicUrl(imagePath);
                picParm2.setSupplierShopId((Long)next.get("SUPPLIER_SHOP_ID"));
                picParm2.setCreateOperId("sys");
                picParm2.setCreateTime(new Date());
                picParm2.setRemark(supplierCode);
                picParmList.add(picParm);
                picParmList2.add(picParm2);
            }
            if (!CollectionUtils.isEmpty(picParmList)) {
                this.comInitMapper.insertComPic(picParmList);
            }
            if (CollectionUtils.isEmpty(picParmList2)) continue;
            this.comInitMapper.insertComPic(picParmList2);
        }
        Page comPackagePage = new Page(1, PAGE_SIZE.intValue());
        this.comInitMapper.getComPackagePage(supplierCode, uccDealCommodityReqBO.getSkuCodeList(), (Page<List<Map<String, Object>>>)comPackagePage);
        int pageCommodityPackage = comPackagePage.getTotalPages();
        for (int i = 1; i <= pageCommodityPackage; ++i) {
            comPackagePage = new Page(i, PAGE_SIZE.intValue());
            List<Map<String, Object>> pageRecord = this.comInitMapper.getComPackagePage(supplierCode, uccDealCommodityReqBO.getSkuCodeList(), (Page<List<Map<String, Object>>>)comPackagePage);
            if (CollectionUtils.isEmpty(pageRecord)) continue;
            Iterator<Map<String, Object>> iterator = pageRecord.iterator();
            ArrayList<ComPackagePO> packageParm = new ArrayList<ComPackagePO>();
            while (iterator.hasNext()) {
                Map<String, Object> next = iterator.next();
                ComPackagePO pack = new ComPackagePO();
                pack.setPackageId(sequenceUtil.nextId());
                pack.setCommodityId((Long)next.get("COMMODITY_ID"));
                pack.setSupplierShopId((Long)next.get("SUPPLIER_SHOP_ID"));
                pack.setPackParam((String)next.get("WARE_QD"));
                pack.setAfterService("0");
                pack.setInstalmentFlag(2);
                pack.setPlaceDelivery("\u91cd\u5e86");
                pack.setFreightTemplateId(1L);
                pack.setInvoiceType(1);
                pack.setCreateOperId("sys");
                pack.setCreateTime(new Date());
                pack.setRemark(supplierCode);
                packageParm.add(pack);
            }
            if (CollectionUtils.isEmpty(packageParm)) continue;
            this.comInitMapper.insertComPackage(packageParm);
        }
        List<Map<String, Object>> maps2 = this.comInitMapper.getSaleUnit(supplierCode, uccDealCommodityReqBO.getSkuCodeList());
        if (!CollectionUtils.isEmpty(maps2)) {
            for (Map<String, Object> next : maps2) {
                String saleUnit = (String)next.get("SALE_UNIT");
                List<Map<String, Object>> maps3 = this.comInitMapper.getMeasure(saleUnit);
                if (CollectionUtils.isEmpty(maps3)) continue;
                Long skuId = (Long)next.get("SKU_ID");
                Map<String, Object> map = maps3.get(0);
                Long measureId = (Long)map.get("measure_id");
                String measureName = (String)map.get("measure_name");
                this.comInitMapper.updateSkuMeasure(measureId, measureName, skuId);
            }
        }
        UccDealCommodityRespBO uccDealCommodityRespBO = new UccDealCommodityRespBO();
        uccDealCommodityRespBO.setRespCode("0000");
        uccDealCommodityRespBO.setRespDesc("\u6210\u529f");
        return uccDealCommodityRespBO;
    }

    private Long getCacheId(Integer type, SequenceUtil sequence) {
        try {
            if (0 == type) {
                List value = (List)this.cacheMap.getValueByKey(Thread.currentThread().getId() + "_commodity_id");
                if (!CollectionUtils.isEmpty((Collection)value)) {
                    Long id = (Long)value.remove(0);
                    this.cacheMap.putValue(Thread.currentThread().getId() + "_commodity_id", (Object)value);
                    return id;
                }
                return sequence.nextId();
            }
            List value = (List)this.cacheMap.getValueByKey(Thread.currentThread().getId() + "_sku_id");
            if (!CollectionUtils.isEmpty((Collection)value)) {
                Long id = (Long)value.remove(0);
                this.cacheMap.putValue(Thread.currentThread().getId() + "_sku_id", (Object)value);
                return id;
            }
            return sequence.nextId();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

