/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.google.gson.Gson;
import com.tydic.commodity.atom.BO.UccDealPutawayApproveReqBO;
import com.tydic.commodity.atom.BO.UccDealPutawayApproveRespBO;
import com.tydic.commodity.atom.UccDealPutawayApproveAtomService;
import com.tydic.commodity.batchimp.imp.BO.CommodityInfoCheckReqBO;
import com.tydic.commodity.dao.ComInitMapper;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class UccDealPutawayApproveAtomServiceImpl
implements UccDealPutawayApproveAtomService {
    private static final int DEAL_COUNT = 50;
    private final Long CHANNEL_ID = 1002L;
    private static final Logger log = LoggerFactory.getLogger(UccDealPutawayApproveAtomServiceImpl.class);
    @Autowired
    private ComInitMapper comInitMapper;

    @Override
    public UccDealPutawayApproveRespBO dealPutawayApprove(UccDealPutawayApproveReqBO uccDealPutawayApproveReqBO) {
        JdbcTemplate jdbcTemplate = uccDealPutawayApproveReqBO.getJdbcTemplate();
        String supplierCode = uccDealPutawayApproveReqBO.getSupplierCode();
        Integer supplierSource = uccDealPutawayApproveReqBO.getSupplierSource();
        String pageNumber = uccDealPutawayApproveReqBO.getPageNumber();
        Long aLong = this.comInitMapper.getSupplier(supplierCode, supplierSource);
        if (null == aLong) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u4fe1\u606f");
        }
        List<Map<String, Object>> maps = StringUtils.isEmpty((Object)pageNumber) ? this.comInitMapper.getComByExternDetail(supplierCode, uccDealPutawayApproveReqBO.getSkuCodeList()) : this.comInitMapper.getComByExternSet(supplierCode, uccDealPutawayApproveReqBO.getSkuCodeList(), pageNumber);
        ArrayList<Long> skuList = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(maps)) {
            for (Map<String, Object> next : maps) {
                Long sku = (Long)next.get("COMMODITY_ID");
                skuList.add(sku);
            }
        }
        int dealTimes = (int)Math.ceil((double)skuList.size() / 50.0);
        ArrayList<CommodityInfoCheckReqBO> commodityInfoCheckReqBOList = new ArrayList<CommodityInfoCheckReqBO>();
        for (int i = 1; i <= dealTimes; ++i) {
            int startPos = (i - 1) * 50;
            int endPos = startPos + 50;
            if (endPos > skuList.size()) {
                endPos = skuList.size();
            }
            List longs = skuList.subList(startPos, endPos);
            CommodityInfoCheckReqBO commodityInfoCheckReqBO = new CommodityInfoCheckReqBO();
            Long[] commoditys = new Long[longs.size()];
            for (int j = 0; j < commoditys.length; ++j) {
                commoditys[j] = (Long)longs.get(j);
            }
            commodityInfoCheckReqBO.setCommodityId(commoditys);
            commodityInfoCheckReqBO.setSupplierId(aLong + "");
            Gson gson = new Gson();
            System.out.println("gson.toJson(commodityInfoCheckReqBO):" + gson.toJson((Object)commodityInfoCheckReqBO));
            ArrayList channelPutParmList = new ArrayList();
            commodityInfoCheckReqBOList.add(commodityInfoCheckReqBO);
        }
        UccDealPutawayApproveRespBO uccDealPutawayApproveRespBO = new UccDealPutawayApproveRespBO();
        uccDealPutawayApproveRespBO.setRespCode("0000");
        uccDealPutawayApproveRespBO.setRespDesc("\u6210\u529f");
        uccDealPutawayApproveRespBO.setCommodityInfoCheckReqBOList(commodityInfoCheckReqBOList);
        return uccDealPutawayApproveRespBO;
    }
}

