/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.commodity.atom.BO.UccDealSkuPriceReqBO;
import com.tydic.commodity.atom.BO.UccDealSkuPriceRespBO;
import com.tydic.commodity.atom.BO.UccPriceBO;
import com.tydic.commodity.atom.UccDealSkuPriceAtomService;
import com.tydic.commodity.dao.ExternSkuPriceMapper;
import com.tydic.commodity.dao.po.ExternalSkuPricePO;
import com.tydic.commodity.utils.HttpTool;
import com.tydic.commodity.utils.UccPropertiesUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UccDealSkuPriceAtomServiceImpl
implements UccDealSkuPriceAtomService {
    @Autowired
    private ExternSkuPriceMapper externSkuPriceMapper;

    @Override
    public UccDealSkuPriceRespBO dealSkuPrice(UccDealSkuPriceReqBO uccDealSkuPriceReqBO) {
        String getPriceUrl = UccPropertiesUtil.getProperty("outinterface.getPriceUrl");
        JdbcTemplate jdbcTemplate = uccDealSkuPriceReqBO.getJdbcTemplate();
        List<String> skuCodeList = uccDealSkuPriceReqBO.getSkuCodeList();
        String skuListStr = uccDealSkuPriceReqBO.getSkuListStr();
        String supplierCode = uccDealSkuPriceReqBO.getSupplierCode();
        UccDealSkuPriceRespBO uccDealSkuPriceRespBO = new UccDealSkuPriceRespBO();
        JSONObject reqObj = new JSONObject();
        reqObj.put("hsn", (Object)supplierCode);
        reqObj.put("sku", skuCodeList);
        reqObj.put("serialNumber", (Object)"sjd79and83cgem");
        reqObj.put("timeStamp", (Object)DateUtils.dateToStr((Date)new Date(), (String)"yyyy-MM-ddHH:mm:ss"));
        String respJson = HttpTool.sendPostJson(getPriceUrl, reqObj.toJSONString());
        JSONObject resultObj = JSONObject.parseObject((String)respJson);
        boolean success = (Boolean)resultObj.get((Object)"success");
        if (!success) {
            uccDealSkuPriceRespBO.setRespCode("8888");
            uccDealSkuPriceRespBO.setRespDesc("\u67e5\u8be2\u8be6\u60c5\u5931\u8d25," + resultObj.getString("resultMessage"));
            return uccDealSkuPriceRespBO;
        }
        List<UccPriceBO> uccPriceBOList = this.dealPriceResult(resultObj, supplierCode, skuCodeList);
        if (!CollectionUtils.isEmpty(uccPriceBOList)) {
            this.externSkuPriceMapper.deleteBySupplierCodeAndSkuList(supplierCode, skuCodeList);
            ArrayList<ExternalSkuPricePO> params = new ArrayList<ExternalSkuPricePO>();
            for (UccPriceBO uccPriceBO : uccPriceBOList) {
                ExternalSkuPricePO param = new ExternalSkuPricePO();
                param.setSkuId(uccPriceBO.getSkuId());
                param.setPrice(uccPriceBO.getEcPrice());
                param.setEcPrice(uccPriceBO.getPrice());
                param.setSupplierCode(supplierCode);
                param.setSkuSource(1);
                params.add(param);
            }
            if (!CollectionUtils.isEmpty(params)) {
                this.externSkuPriceMapper.insertBatch(params);
            }
        }
        uccDealSkuPriceRespBO.setRespCode("0000");
        uccDealSkuPriceRespBO.setRespDesc("\u6210\u529f");
        return uccDealSkuPriceRespBO;
    }

    private List<UccPriceBO> dealPriceResult(JSONObject respObj, String supplierCode, List<String> skuCodeList) {
        ArrayList<UccPriceBO> uccPriceBOList = new ArrayList<UccPriceBO>();
        JSONArray result = respObj.getJSONArray("result");
        if ("jd".equals(supplierCode)) {
            if (!result.isEmpty()) {
                for (int i = 0; i < result.size(); ++i) {
                    JSONObject jsonObject = result.getJSONObject(i);
                    UccPriceBO uccPriceBO = new UccPriceBO();
                    if (!skuCodeList.contains(jsonObject.getString("skuId"))) {
                        uccPriceBO.setEcPrice(BigDecimal.ZERO);
                        uccPriceBO.setPrice(BigDecimal.ZERO);
                    } else {
                        uccPriceBO.setEcPrice(jsonObject.getBigDecimal("jdPrice"));
                        uccPriceBO.setPrice(jsonObject.getBigDecimal("price"));
                    }
                    uccPriceBO.setSkuId(jsonObject.getString("skuId"));
                    uccPriceBOList.add(uccPriceBO);
                }
            } else {
                skuCodeList.forEach(sku -> {
                    UccPriceBO uccPriceBO = new UccPriceBO();
                    uccPriceBO.setEcPrice(BigDecimal.ZERO);
                    uccPriceBO.setPrice(BigDecimal.ZERO);
                    uccPriceBO.setSkuId((String)sku);
                    uccPriceBOList.add(uccPriceBO);
                });
            }
        } else if (!result.isEmpty()) {
            for (int i = 0; i < result.size(); ++i) {
                JSONObject jsonObject = result.getJSONObject(i);
                UccPriceBO uccPriceBO = new UccPriceBO();
                if (!skuCodeList.contains(jsonObject.getString("skuId"))) {
                    uccPriceBO.setEcPrice(BigDecimal.ZERO);
                    uccPriceBO.setPrice(BigDecimal.ZERO);
                } else {
                    uccPriceBO.setEcPrice(jsonObject.getBigDecimal("ecPrice"));
                    uccPriceBO.setPrice(jsonObject.getBigDecimal("price"));
                }
                uccPriceBO.setSkuId(jsonObject.getString("skuId"));
                uccPriceBOList.add(uccPriceBO);
            }
        } else {
            skuCodeList.forEach(sku -> {
                UccPriceBO uccPriceBO = new UccPriceBO();
                uccPriceBO.setEcPrice(BigDecimal.ZERO);
                uccPriceBO.setPrice(BigDecimal.ZERO);
                uccPriceBO.setSkuId((String)sku);
                uccPriceBOList.add(uccPriceBO);
            });
        }
        return uccPriceBOList;
    }
}

