/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.atom.BO.UccDealSkuPropReqBO;
import com.tydic.commodity.atom.BO.UccDealSkuPropRspBO;
import com.tydic.commodity.atom.UccDealSkuPropAtomService;
import com.tydic.commodity.dao.ComInitMapper;
import com.tydic.commodity.dao.ExternSkuAttrMapper;
import com.tydic.commodity.dao.ExternSkuDetailMapper;
import com.tydic.commodity.dao.po.MeasurePO;
import com.tydic.commodity.dao.po.PropDefPO;
import com.tydic.commodity.dao.po.PropRelPO;
import com.tydic.commodity.dao.po.PropValuePO;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uccDealSkuPropAtomService")
public class UccDealSkuPropAtomServiceImpl
implements UccDealSkuPropAtomService {
    private Date now = new Date();
    @Autowired
    private ExternSkuDetailMapper externSkuDetailMapper;
    @Autowired
    private ExternSkuAttrMapper externSkuAttrMapper;
    @Autowired
    private ComInitMapper comInitMapper;
    private static final Integer PAGE_SIZE = 500;

    @Override
    public UccDealSkuPropRspBO dealSkuProp(UccDealSkuPropReqBO uccDealSkuPropReqBO) {
        List<Map<String, Object>> maps1;
        List<String> skuCodeList = uccDealSkuPropReqBO.getSkuCodeList();
        String skuListStr = uccDealSkuPropReqBO.getSkuListStr();
        String supplierCode = uccDealSkuPropReqBO.getSupplierCode();
        Sequence sequenceUtil = Sequence.getInstance();
        List<Map<String, Object>> maps = this.externSkuDetailMapper.getCate4BySkuList(skuCodeList);
        if (!CollectionUtils.isEmpty(maps)) {
            for (Map<String, Object> next : maps) {
                List<Map<String, Object>> maps12;
                String catalogId = next.get("SKU_CATE4").toString();
                List<Map<String, Object>> propDefMap = this.externSkuAttrMapper.getAttrNameBySkuListAndCatalogSupplier(skuCodeList, catalogId, supplierCode);
                if (!CollectionUtils.isEmpty(propDefMap)) {
                    ArrayList<PropDefPO> defParmList = new ArrayList<PropDefPO>();
                    for (Map<String, Object> next1 : propDefMap) {
                        List<Map<String, Object>> maps13;
                        String name = next1.get("attr_name").toString();
                        Integer filterFlag = 1;
                        if ("\u54c1\u724c".equals(name) || "-".equals(name)) {
                            filterFlag = 0;
                        }
                        if (!CollectionUtils.isEmpty(maps13 = this.comInitMapper.getPropDefIdByRemarkAndPropName(catalogId, name))) continue;
                        PropDefPO defParm = new PropDefPO();
                        defParm.setDefId(sequenceUtil.nextId());
                        defParm.setDefCode("PROP_CODE");
                        defParm.setDefName(name);
                        defParm.setDefShowName(name);
                        defParm.setDefTag(1);
                        defParm.setDefType(0);
                        defParm.setDefLength(500);
                        defParm.setInputType(0);
                        defParm.setFilterFlag(filterFlag);
                        defParm.setRequiredFlag(0);
                        defParm.setMultiFlag(1);
                        defParm.setPropertyLink(0);
                        defParm.setShowOrder(0);
                        defParm.setCreateOperId("sys");
                        defParm.setCreateTime(this.now);
                        defParm.setRemark(catalogId);
                        defParmList.add(defParm);
                    }
                    if (CollectionUtils.isNotEmpty(defParmList)) {
                        this.comInitMapper.insertPropDefBatch(defParmList);
                    }
                }
                if (CollectionUtils.isEmpty(maps12 = this.comInitMapper.getDefInfoByRemark(catalogId))) continue;
                for (Map<String, Object> next1 : maps12) {
                    String propName = next1.get("PROP_NAME").toString();
                    String defId = next1.get("COMMODITY_PROP_DEF_ID").toString();
                    String remark = next1.get("remark").toString();
                    Page skuAttrPage = new Page(1, PAGE_SIZE.intValue());
                    this.comInitMapper.getSkuAttrPage(catalogId, supplierCode, propName, skuCodeList, (Page<List<Map<String, Object>>>)skuAttrPage);
                    int pageCount = skuAttrPage.getTotalPages();
                    for (int i = 1; i <= pageCount; ++i) {
                        skuAttrPage = new Page(i, PAGE_SIZE.intValue());
                        List<Map<String, Object>> pageRecord = this.comInitMapper.getSkuAttrPage(catalogId, supplierCode, propName, skuCodeList, (Page<List<Map<String, Object>>>)skuAttrPage);
                        for (int j = 0; j < pageRecord.size(); ++j) {
                            Map<String, Object> skuInfotMap = pageRecord.get(j);
                            List<Map<String, Object>> maps6 = this.comInitMapper.getPropValueList(remark, (String)skuInfotMap.get("attr_value"));
                            Long propValueListId = 0L;
                            if (CollectionUtils.isEmpty(maps6)) {
                                Long seqNext = sequenceUtil.nextId();
                                PropValuePO parm = new PropValuePO();
                                parm.setValueId(seqNext);
                                parm.setDefId(defId);
                                parm.setValueCode("ATTR_VALUE_CODE");
                                parm.setPropValue((String)skuInfotMap.get("attr_value"));
                                parm.setCreateOper("sys");
                                parm.setCreateTime(new Date());
                                parm.setRemark(remark);
                                parm.setRemark2((String)skuInfotMap.get("sku"));
                                this.comInitMapper.insertPropValue(parm);
                                propValueListId = seqNext;
                            } else {
                                for (Map<String, Object> next2 : maps6) {
                                    propValueListId = (Long)next2.get("PROP_VALUE_LIST_ID");
                                }
                            }
                            this.comInitMapper.insertSkuPropRel(propValueListId, (String)skuInfotMap.get("sku"));
                        }
                    }
                    List<Map<String, Object>> maps2 = this.comInitMapper.getPropRelList(catalogId, defId);
                    if (!CollectionUtils.isEmpty(maps2)) continue;
                    List<Map<String, Object>> maps4 = this.comInitMapper.getPropRelInfo(catalogId, defId);
                    Iterator<Map<String, Object>> iterator2 = maps4.iterator();
                    ArrayList<PropRelPO> relParmList = new ArrayList<PropRelPO>();
                    while (iterator2.hasNext()) {
                        Map<String, Object> next2 = iterator2.next();
                        PropRelPO parm = new PropRelPO();
                        parm.setRelId(sequenceUtil.nextId());
                        parm.setDefId((Long)next2.get("COMMODITY_PROP_DEF_ID"));
                        parm.setGrpId((Long)next2.get("COMMODITY_PROP_GRP_ID"));
                        parm.setShowOrder(0);
                        parm.setCreateOper("sys");
                        parm.setCreateTime(this.now);
                        parm.setRemark((String)next2.get("REMARK"));
                        relParmList.add(parm);
                    }
                    if (!CollectionUtils.isNotEmpty(relParmList)) continue;
                    this.comInitMapper.insertPropRelBatch(relParmList);
                }
            }
        }
        if (!CollectionUtils.isEmpty(maps1 = this.externSkuDetailMapper.getSaleUnit(skuCodeList, supplierCode))) {
            Iterator<Map<String, Object>> iterator = maps1.iterator();
            ArrayList<MeasurePO> parmList = new ArrayList<MeasurePO>();
            while (iterator.hasNext()) {
                List<Map<String, Object>> maps2;
                Map<String, Object> next = iterator.next();
                String saleUnit = next.get("SALE_UNIT").toString();
                if (StringUtils.isEmpty((Object)saleUnit) || "empty".equals(saleUnit) || !CollectionUtils.isEmpty(maps2 = this.comInitMapper.getMeasure(saleUnit))) continue;
                MeasurePO parm = new MeasurePO();
                parm.setMeasureId(sequenceUtil.nextId());
                parm.setMeasureName(saleUnit);
                parm.setMeasureType(0);
                parm.setCreateOper("sys");
                parm.setCreateTime(this.now);
                parm.setIsDelete(0);
                parmList.add(parm);
            }
            if (CollectionUtils.isNotEmpty(parmList)) {
                this.comInitMapper.insertMeasure(parmList);
            }
        }
        UccDealSkuPropRspBO uccDealSkuPropRspBO = new UccDealSkuPropRspBO();
        uccDealSkuPropRspBO.setRespCode("0000");
        uccDealSkuPropRspBO.setRespDesc("\u6210\u529f");
        return uccDealSkuPropRspBO;
    }
}

