/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.imp;

import com.tydic.commodity.batchimp.imp.Constant;
import com.tydic.commodity.batchimp.imp.modle.AttributeModel;
import com.tydic.commodity.batchimp.imp.modle.BrandModel;
import com.tydic.commodity.batchimp.imp.modle.CategoryModel;
import com.tydic.commodity.batchimp.imp.modle.CommodityModel;
import com.tydic.commodity.batchimp.imp.modle.PropDefModel;
import com.tydic.commodity.batchimp.imp.modle.PropGrpModel;
import com.tydic.commodity.batchimp.imp.modle.PropRelModel;
import com.tydic.commodity.batchimp.imp.modle.PropValueListModel;
import com.tydic.commodity.batchimp.imp.modle.SaleNumModel;
import com.tydic.commodity.batchimp.imp.modle.ShopModel;
import com.tydic.commodity.batchimp.imp.modle.SkuModel;
import com.tydic.commodity.batchimp.imp.modle.SkuPriceModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class InsertDataService {
    private static final Logger logger = LoggerFactory.getLogger(InsertDataService.class);
    private JdbcTemplate jdbcTemplate;
    private static final String OS_SPLIT_STR = "*~~";
    private Constant constant;
    private Date now = new Date();

    public InsertDataService(JdbcTemplate jdbcTemplate) {
        this.constant = new Constant();
        this.jdbcTemplate = jdbcTemplate;
    }

    public String insertData(String commodityId) {
        int count = 0;
        if (!StringUtils.isEmpty((Object)commodityId) && (count = ((Integer)this.jdbcTemplate.queryForObject(this.constant.getCommmdSql() + commodityId, Integer.class)).intValue()) == 0) {
            return "\u65e0\u5546\u54c1\u4fe1\u606f\uff1acommodityId = " + commodityId;
        }
        this.getSkuList(commodityId);
        logger.info("\u6570\u636e\u5bfc\u5165\u5b8c\u6210\uff01\uff01");
        return "\u6570\u636e\u5bfc\u5165\u5b8c\u6210\uff01\uff01";
    }

    private void getSkuList(String commodityId) {
        if (StringUtils.isEmpty((Object)commodityId)) {
            Integer total = 0;
            int pageSize = 50;
            Integer totalPage = 0;
            int startRow = 0;
            int endRow = 0;
            total = (Integer)this.jdbcTemplate.queryForObject(this.constant.getCountSql(), Integer.class);
            logger.info("\u672c\u6b21\u5bfc\u5165\u6570\u636e\u603b\u6570\uff1a" + total);
            totalPage = total % pageSize == 0 ? Integer.valueOf(total / pageSize) : Integer.valueOf(total / pageSize + 1);
            for (int i = 0; i <= totalPage; ++i) {
                endRow = pageSize * (i + 1);
                String param = " " + startRow + "," + pageSize;
                List<SkuModel> skuModels = this.querySkuPageData(param);
                List<CommodityModel> commodityModels = this.dealCommodityModel(skuModels);
                logger.info("=================\u5b8c\u6210" + (i + 1) + "\u6b21\u6279\u91cf\u7684\u67e5\u8be2\uff0c\u603b\u5927\u5c0f\u4e3a" + commodityModels.size());
                this.addDataToEs(commodityModels);
                startRow = endRow;
            }
        } else {
            List<SkuModel> skuModels = this.querySkuPageData(commodityId);
            List<CommodityModel> commodityModels = this.dealCommodityModel(skuModels);
            logger.info("==================\u5b8c\u6210commodityId = " + commodityId + "\u7684\u67e5\u8be2\uff0c\u603b\u5927\u5c0f\u4e3a" + commodityModels.size());
            this.addDataToEs(commodityModels);
        }
    }

    private void addDataToEs(List<CommodityModel> commodityModels) {
        for (CommodityModel commodityModel : commodityModels) {
            this.jdbcTemplate.update("insert into D_SKU_ES(sku_id, commodity_id, sku_name, sku_status, brand_id, brand_id_name, brand_name, sku_source, supplier_id, supplier_id_name, supplier_name, sku_Phone_Detail_Char, ext_sku_id, l1_category_id, l1_category_name, l2_category_id, l2_category_name, l3_category_id, l3_category_name, l3_category_id_name, agreement_id, agreement_price, market_price, sale_price, discounts, member_price2, member_price1, member_price3, member_price4, member_price5, mfgsku, sold_number, comment_number, on_shelve_time, picture_url, properties, upc, supplier_shop_id, shop_name, channel_id, description, type_id, type_name,create_time,sku_create_time) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{commodityModel.getSku_id(), commodityModel.getCommodity_id(), commodityModel.getSku_name(), commodityModel.getSku_status(), commodityModel.getBrand_id(), commodityModel.getBrand_id_name(), commodityModel.getBrand_name(), commodityModel.getSku_source(), commodityModel.getSupplier_id(), commodityModel.getSupplier_id_name(), commodityModel.getSupplier_name(), commodityModel.getSkuPhoneDetailChar(), commodityModel.getExt_sku_id(), commodityModel.getL1_category_id(), commodityModel.getL1_category_name(), commodityModel.getL2_category_id(), commodityModel.getL2_category_name(), commodityModel.getL3_category_id(), commodityModel.getL3_category_name(), commodityModel.getL3_category_id_name(), commodityModel.getAgreement_id(), commodityModel.getAgreement_price(), commodityModel.getMarket_price(), commodityModel.getSale_price(), commodityModel.getDiscounts(), commodityModel.getMember_price2(), commodityModel.getMember_price1(), commodityModel.getMember_price3(), commodityModel.getMember_price4(), commodityModel.getMember_price5(), commodityModel.getMfgsku(), commodityModel.getSold_number(), commodityModel.getComment_number(), commodityModel.getOn_shelve_time(), commodityModel.getPicture_url(), commodityModel.getProperties(), commodityModel.getUpc(), commodityModel.getSupplier_shop_id(), commodityModel.getShop_name(), commodityModel.getChannel_id(), null, null, null, this.now, commodityModel.getSkuCreateTime()});
        }
    }

    private List<CommodityModel> dealCommodityModel(List<SkuModel> skuModels) {
        ArrayList<CommodityModel> commodityModels = new ArrayList<CommodityModel>();
        if (skuModels == null) {
            return null;
        }
        for (SkuModel skuModel : skuModels) {
            CommodityModel commodityModel = new CommodityModel();
            this.setSkuToCommodity(commodityModel, skuModel);
            this.setSkuPriceToCommodity(commodityModel, skuModel.getSKU_ID());
            this.setBrandToCommodity(commodityModel, skuModel.getCOMMODITY_ID());
            this.setPicUrlToCommodity(commodityModel, skuModel.getSKU_ID(), skuModel.getCOMMODITY_ID());
            this.setShopInfoToCommodity(commodityModel, skuModel.getCOMMODITY_ID());
            this.setPropertiesToCommodity(commodityModel, skuModel.getSKU_ID());
            this.setChannelToCommodity(commodityModel, skuModel.getSKU_ID());
            this.setSoldNumberToCommodity(commodityModel, skuModel.getSKU_ID());
            commodityModels.addAll(this.getCatalogToCommoditys(commodityModel, skuModel.getCOMMODITY_TYPE_ID()));
        }
        return commodityModels;
    }

    private void setSkuToCommodity(CommodityModel commodityModel, SkuModel skuModel) {
        if (!StringUtils.isEmpty((Object)skuModel.getAGREEMENT_ID())) {
            commodityModel.setAgreement_id(skuModel.getAGREEMENT_ID());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getSKU_PC_DETAIL_CHAR())) {
            commodityModel.setSkuPcDetailChar(skuModel.getSKU_PC_DETAIL_CHAR());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getSKU_PHONE_DETAIL_CHAR())) {
            commodityModel.setSkuPhoneDetailChar(skuModel.getSKU_PHONE_DETAIL_CHAR());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getEXT_SKU_ID())) {
            commodityModel.setExt_sku_id(skuModel.getEXT_SKU_ID());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getMFGSKU())) {
            commodityModel.setMfgsku(skuModel.getMFGSKU());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getON_SHELVE_TIME())) {
            commodityModel.setOn_shelve_time(skuModel.getON_SHELVE_TIME().getTime());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getSKU_ID())) {
            commodityModel.setSku_id(skuModel.getSKU_ID());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getSKU_SOURCE())) {
            commodityModel.setSku_source(skuModel.getSKU_SOURCE());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getSKU_STATUS())) {
            commodityModel.setSku_status(skuModel.getSKU_STATUS());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getSKU_NAME())) {
            commodityModel.setSku_name(skuModel.getSKU_NAME());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getUPC_CODE())) {
            commodityModel.setUpc(skuModel.getUPC_CODE());
        }
        if (!StringUtils.isEmpty((Object)skuModel.getCOMMODITY_ID())) {
            commodityModel.setCommodity_id(skuModel.getCOMMODITY_ID());
        }
        if (skuModel.getSkuCreateTime() != null) {
            commodityModel.setSkuCreateTime(skuModel.getSkuCreateTime());
        }
    }

    private void setSkuPriceToCommodity(CommodityModel commodityModel, Long skuId) {
        String querySql = this.constant.getPriceSql() + skuId;
        logger.info(querySql);
        List skuPriceModels = SkuPriceModel.toObject(this.jdbcTemplate.queryForList(querySql));
        for (SkuPriceModel skuPriceModel : skuPriceModels) {
            if (!StringUtils.isEmpty((Object)skuPriceModel.getAGREEMENT_PRICE())) {
                commodityModel.setAgreement_price(skuPriceModel.getAGREEMENT_PRICE());
            }
            if (!StringUtils.isEmpty((Object)skuPriceModel.getMARKET_PRICE())) {
                commodityModel.setMarket_price(skuPriceModel.getMARKET_PRICE());
            }
            if (!StringUtils.isEmpty((Object)skuPriceModel.getMEMBER_PRICE1())) {
                commodityModel.setMember_price1(skuPriceModel.getMEMBER_PRICE1());
            }
            if (!StringUtils.isEmpty((Object)skuPriceModel.getMEMBER_PRICE2())) {
                commodityModel.setMember_price2(skuPriceModel.getMEMBER_PRICE2());
            }
            if (!StringUtils.isEmpty((Object)skuPriceModel.getMEMBER_PRICE3())) {
                commodityModel.setMember_price3(skuPriceModel.getMEMBER_PRICE3());
            }
            if (!StringUtils.isEmpty((Object)skuPriceModel.getMEMBER_PRICE4())) {
                commodityModel.setMember_price4(skuPriceModel.getMEMBER_PRICE4());
            }
            if (!StringUtils.isEmpty((Object)skuPriceModel.getMEMBER_PRICE5())) {
                commodityModel.setMember_price5(skuPriceModel.getMEMBER_PRICE5());
            }
            if (!StringUtils.isEmpty((Object)skuPriceModel.getSALE_PRICE())) {
                commodityModel.setSale_price(skuPriceModel.getSALE_PRICE());
            }
            BigDecimal discounts = new BigDecimal(0);
            discounts = new BigDecimal(commodityModel.getSale_price()).divide(new BigDecimal(commodityModel.getMarket_price()), 2, 4);
            commodityModel.setDiscounts(discounts);
        }
    }

    private void setBrandToCommodity(CommodityModel commodityModel, Long commodityId) {
        String querySql = this.constant.getBrandSql() + commodityId + ")";
        logger.info(querySql);
        List brandModels = BrandModel.toObject(this.jdbcTemplate.queryForList(querySql));
        for (BrandModel brandModel : brandModels) {
            if (!StringUtils.isEmpty((Object)brandModel.getBRAND_ID())) {
                commodityModel.setBrand_id(brandModel.getBRAND_ID());
            }
            if (!StringUtils.isEmpty((Object)brandModel.getBRAND_EN_NAME())) {
                commodityModel.setBrand_id_name(brandModel.getBRAND_EN_NAME());
            }
            if (StringUtils.isEmpty((Object)brandModel.getBRAND_NAME())) continue;
            commodityModel.setBrand_name(brandModel.getBRAND_NAME());
        }
    }

    private void setPicUrlToCommodity(CommodityModel commodityModel, Long skuId, Long commodityId) {
        String sku_pic_url = this.constant.getSkuPicSql() + skuId;
        String skuPic = null;
        try {
            skuPic = (String)this.jdbcTemplate.queryForObject(sku_pic_url, String.class);
        }
        catch (EmptyResultDataAccessException e) {
            logger.info("this sku has no pic");
        }
        if (!StringUtils.isEmpty((Object)skuPic)) {
            commodityModel.setPicture_url(skuPic);
        } else {
            String commodity_pic_url = this.constant.getCommodityPicSql() + commodityId;
            String commodityPic = null;
            try {
                commodityPic = (String)this.jdbcTemplate.queryForObject(commodity_pic_url, String.class);
            }
            catch (EmptyResultDataAccessException e) {
                logger.info("this commodity has no pic");
            }
            if (!StringUtils.isEmpty((Object)commodityPic)) {
                commodityModel.setPicture_url(commodityPic);
            }
        }
    }

    private void setShopInfoToCommodity(CommodityModel commodityModel, Long commodityId) {
        String querySql = this.constant.getShopSql() + commodityId + ")";
        logger.info(querySql);
        List shopModels = ShopModel.toObject(this.jdbcTemplate.queryForList(querySql));
        for (ShopModel shopModel : shopModels) {
            if (!StringUtils.isEmpty((Object)shopModel.getSUPPLIER_ID())) {
                commodityModel.setSupplier_id(shopModel.getSUPPLIER_ID());
            }
            if (!StringUtils.isEmpty((Object)shopModel.getSUPPLIER_NAME())) {
                commodityModel.setSupplier_name(shopModel.getSUPPLIER_NAME());
            }
            if (!StringUtils.isEmpty((Object)shopModel.getSUPPLIER_SHOP_ID())) {
                commodityModel.setSupplier_shop_id(shopModel.getSUPPLIER_SHOP_ID());
            }
            if (StringUtils.isEmpty((Object)shopModel.getSHOP_NAME())) continue;
            commodityModel.setShop_name(shopModel.getSHOP_NAME());
        }
    }

    private void setPropertiesToCommodity(CommodityModel commodityModel, Long skuId) {
        String sql = this.constant.getPropertiesSql2();
        try {
            String s = (String)this.jdbcTemplate.queryForObject(sql, String.class, new Object[]{skuId, skuId});
            if (!StringUtils.isEmpty((Object)s)) {
                logger.info("\u5c5e\u6027\u6bb5\u843d>>>>>>>>>>" + s);
                commodityModel.setProperties(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setChannelToCommodity(CommodityModel commodityModel, Long skuId) {
        String querySql = this.constant.getChannelSql() + skuId;
        ArrayList<Long> channelIds = new ArrayList<Long>();
        try {
            List lists = this.jdbcTemplate.queryForList(querySql);
            for (Map map : lists) {
                Long channelId = (Long)map.get("CHANNEL_ID");
                if (StringUtils.isEmpty((Object)channelId)) continue;
                channelIds.add(channelId);
            }
        }
        catch (EmptyResultDataAccessException e) {
            logger.info("this sku has no channel");
        }
        if (channelIds != null && channelIds.size() > 0 && channelIds.size() < 2) {
            commodityModel.setChannel_id((Long)channelIds.get(0));
        }
    }

    private void setSoldNumberToCommodity(CommodityModel commodityModel, Long skuId) {
        String querySql = this.constant.getSoldSql() + skuId;
        logger.info(querySql);
        List saleNumModels = SaleNumModel.toObject(this.jdbcTemplate.queryForList(querySql));
        for (SaleNumModel saleNumModel : saleNumModels) {
            if (saleNumModel.getSOLD_NUMBER() == null) continue;
            commodityModel.setSold_number(saleNumModel.getSOLD_NUMBER());
        }
    }

    private List<CommodityModel> getCatalogToCommoditys(CommodityModel commodityModel, Long commodityTypeId) {
        ArrayList<CommodityModel> commodityModelList = new ArrayList<CommodityModel>();
        String guideSql = this.constant.getGuideSql() + commodityTypeId;
        logger.info(guideSql);
        List list = this.jdbcTemplate.queryForList(guideSql);
        if (CollectionUtils.isEmpty((Collection)list)) {
            commodityModelList.add(commodityModel);
        } else {
            for (Map map : list) {
                Set entries = map.entrySet();
                if (entries == null) continue;
                for (Map.Entry entry : entries) {
                    Long guideId = (Long)entry.getValue();
                    logger.info("this guide_catalog_id is " + guideId);
                    CommodityModel commodityModelGuid = new CommodityModel();
                    BeanUtils.copyProperties((Object)commodityModel, (Object)commodityModelGuid);
                    if (!this.setCatalogToCommodity(commodityModelGuid, guideId)) continue;
                    commodityModelList.add(commodityModelGuid);
                }
            }
        }
        return commodityModelList;
    }

    private boolean setCatalogToCommodity(CommodityModel commodityModel, Long guidCatalogId) {
        String querySql = this.constant.getCatalogSql() + guidCatalogId;
        logger.info(querySql);
        List categoryModels = CategoryModel.toObject(this.jdbcTemplate.queryForList(querySql));
        if (categoryModels.size() < 1 || categoryModels == null) {
            return false;
        }
        Integer level = 0;
        for (CategoryModel categoryModel : categoryModels) {
            if (categoryModel.getCATALOG_LEVEL() != null) {
                level = categoryModel.getCATALOG_LEVEL();
            }
            if (level.equals(1)) {
                if (!StringUtils.isEmpty((Object)categoryModel.getGUIDE_CATALOG_ID())) {
                    commodityModel.setL1_category_id(categoryModel.getGUIDE_CATALOG_ID());
                }
                if (StringUtils.isEmpty((Object)categoryModel.getCATALOG_NAME())) continue;
                commodityModel.setL1_category_name(categoryModel.getCATALOG_NAME());
                continue;
            }
            if (level.equals(2)) {
                if (!StringUtils.isEmpty((Object)categoryModel.getGUIDE_CATALOG_ID())) {
                    commodityModel.setL2_category_id(categoryModel.getGUIDE_CATALOG_ID());
                }
                if (!StringUtils.isEmpty((Object)categoryModel.getCATALOG_NAME())) {
                    commodityModel.setL2_category_name(categoryModel.getCATALOG_NAME());
                }
                if (categoryModel.getUPPER_CATALOG_ID() == null) continue;
                this.setCatalogToCommodity(commodityModel, categoryModel.getUPPER_CATALOG_ID());
                continue;
            }
            if (!level.equals(3)) continue;
            if (!StringUtils.isEmpty((Object)categoryModel.getGUIDE_CATALOG_ID())) {
                commodityModel.setL3_category_id(categoryModel.getGUIDE_CATALOG_ID());
            }
            if (!StringUtils.isEmpty((Object)categoryModel.getCATALOG_NAME())) {
                commodityModel.setL3_category_name(categoryModel.getCATALOG_NAME());
            }
            if (categoryModel.getUPPER_CATALOG_ID() == null) continue;
            this.setCatalogToCommodity(commodityModel, categoryModel.getUPPER_CATALOG_ID());
        }
        return true;
    }

    private List<SkuModel> querySkuPageData(String param) {
        String querySql = "";
        querySql = param.contains(",") ? this.constant.getSkuSql() + param : this.constant.getSkuByCommdSql() + param;
        logger.info(querySql);
        List skuModles = this.jdbcTemplate.queryForList(querySql);
        return SkuModel.toObject(skuModles);
    }

    private void getAttrList(String commodityId) {
        if (StringUtils.isEmpty((Object)commodityId)) {
            Integer total = 0;
            int pageSize = 50;
            Integer totalPage = 0;
            int startRow = 0;
            int endRow = 0;
            total = (Integer)this.jdbcTemplate.queryForObject(this.constant.getCountAttrSql(), Integer.class);
            logger.info("\u672c\u6b21\u5bfc\u5165\u5c5e\u6027\u6570\u636e\u603b\u6570\uff1a" + total);
            totalPage = total % pageSize == 0 ? Integer.valueOf(total / pageSize) : Integer.valueOf(total / pageSize + 1);
            for (int i = 0; i <= totalPage; ++i) {
                endRow = pageSize * (i + 1);
                String param = " " + startRow + "," + pageSize;
                List<PropValueListModel> valueModels = this.queryValueListPageData(param);
                List<AttributeModel> attributeModels = this.dealAttributeModel(valueModels);
                logger.info("=================\u5b8c\u6210" + (i + 1) + "\u6b21\u6279\u91cf\u7684\u67e5\u8be2\uff0c\u603b\u5927\u5c0f\u4e3a" + attributeModels.size());
                this.addAttrDataToEs(attributeModels);
                startRow = endRow;
            }
        } else {
            List<PropValueListModel> valueModels = this.queryValueListPageData(commodityId);
            List<AttributeModel> attributeModels = this.dealAttributeModel(valueModels);
            logger.info("=================\u5b8c\u6210commodityId = " + commodityId + "\u7684\u67e5\u8be2\uff0c\u603b\u5927\u5c0f\u4e3a" + attributeModels.size());
            this.addAttrDataToEs(attributeModels);
        }
    }

    private void addAttrDataToEs(List<AttributeModel> attributeModels) {
        for (AttributeModel attributeModel : attributeModels) {
            this.jdbcTemplate.update("insert into D_SKU_PROPERTIES(spec_id, prop_value_list_id, prop_value_list_code, commodity_prop_def_id, prop_value, prov_value_desc, remark, prop_code, prop_name, show_name, show_order, commodity_prop_grp_id, commodity_prop_grp_code, commodity_prop_grp_name, commodity_prop_grp_type, prop_grp_status) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{attributeModel.getCOMMODITY_SPEC_ID(), attributeModel.getProp_value_list_id(), attributeModel.getProp_value_list_code(), attributeModel.getCommodity_prop_def_id(), attributeModel.getProp_value(), attributeModel.getProv_value_desc(), attributeModel.getRemark(), attributeModel.getProp_code(), attributeModel.getProp_name(), attributeModel.getShow_name(), attributeModel.getShow_order(), attributeModel.getCommodity_prop_grp_id(), attributeModel.getCommodity_prop_grp_code(), attributeModel.getCommodity_prop_grp_name(), attributeModel.getCommodity_prop_grp_type(), attributeModel.getProp_grp_status()});
        }
    }

    private List<PropValueListModel> queryValueListPageData(String param) {
        String querySql = "";
        querySql = param.contains(",") ? this.constant.getAttrSql() + param : this.constant.getAttrByCommdSql() + param;
        logger.info(querySql);
        List propValueModels = this.jdbcTemplate.queryForList(querySql);
        return PropValueListModel.toObject(propValueModels);
    }

    private List<AttributeModel> dealAttributeModel(List<PropValueListModel> valueModels) {
        ArrayList<AttributeModel> attributeModels = new ArrayList<AttributeModel>();
        if (valueModels == null) {
            return null;
        }
        for (PropValueListModel propValueListModel : valueModels) {
            AttributeModel attributeModel = new AttributeModel();
            this.setPropValueToAttr(attributeModel, propValueListModel);
            this.setPropDefToAttr(attributeModel, propValueListModel.getCOMMODITY_PROP_DEF_ID());
            List<AttributeModel> attributeModelList = this.setPropGrpToAttr(attributeModel, propValueListModel.getCOMMODITY_PROP_DEF_ID());
            attributeModels.addAll(attributeModelList);
        }
        return attributeModels;
    }

    private void setPropValueToAttr(AttributeModel attributeModel, PropValueListModel propValueListModel) {
        if (!StringUtils.isEmpty((Object)propValueListModel.getPROP_VALUE_LIST_ID())) {
            attributeModel.setProp_value_list_id(propValueListModel.getPROP_VALUE_LIST_ID());
        }
        if (!StringUtils.isEmpty((Object)propValueListModel.getCOMMODITY_PROP_DEF_ID())) {
            attributeModel.setCommodity_prop_def_id(propValueListModel.getCOMMODITY_PROP_DEF_ID());
        }
        if (!StringUtils.isEmpty((Object)propValueListModel.getPROP_VALUE())) {
            attributeModel.setProp_value(propValueListModel.getPROP_VALUE());
        }
        if (propValueListModel.getCOMMODITY_SPEC_ID() != null) {
            attributeModel.setCOMMODITY_SPEC_ID(propValueListModel.getCOMMODITY_SPEC_ID());
        }
    }

    private void setPropDefToAttr(AttributeModel attributeModel, Long defId) {
        String querySql = this.constant.getAttrDefSql() + defId;
        logger.info(querySql);
        List propDefModels = PropDefModel.toObject(this.jdbcTemplate.queryForList(querySql));
        for (PropDefModel propDefModel : propDefModels) {
            if (!StringUtils.isEmpty((Object)propDefModel.getPROP_CODE())) {
                attributeModel.setProp_code(propDefModel.getPROP_CODE());
            }
            if (!StringUtils.isEmpty((Object)propDefModel.getPROP_NAME())) {
                attributeModel.setProp_name(propDefModel.getPROP_NAME());
            }
            if (!StringUtils.isEmpty((Object)propDefModel.getSHOW_NAME())) {
                attributeModel.setShow_name(propDefModel.getSHOW_NAME());
            }
            if (StringUtils.isEmpty((Object)propDefModel.getSHOW_ORDER())) continue;
            attributeModel.setShow_order(propDefModel.getSHOW_ORDER());
        }
    }

    private List<AttributeModel> setPropGrpToAttr(AttributeModel attributeModel, Long defId) {
        ArrayList<AttributeModel> attributeModels = new ArrayList<AttributeModel>();
        String querySql = this.constant.getAttrRelSql() + defId;
        logger.info(querySql);
        List propRelModels = PropRelModel.toObject(this.jdbcTemplate.queryForList(querySql));
        for (PropRelModel propRelModel : propRelModels) {
            if (StringUtils.isEmpty((Object)propRelModel.getCOMMODITY_PROP_GRP_ID())) continue;
            Long grpId = propRelModel.getCOMMODITY_PROP_GRP_ID();
            String queryGrpSql = this.constant.getAttrGrpSql() + grpId;
            logger.info(queryGrpSql);
            List propGrpModels = PropGrpModel.toObject(this.jdbcTemplate.queryForList(queryGrpSql));
            for (PropGrpModel propGrpModel : propGrpModels) {
                AttributeModel attrModel = new AttributeModel();
                BeanUtils.copyProperties((Object)attributeModel, (Object)attrModel);
                if (!StringUtils.isEmpty((Object)propGrpModel.getCOMMODITY_PROP_GRP_ID())) {
                    attrModel.setCommodity_prop_grp_id(propGrpModel.getCOMMODITY_PROP_GRP_ID());
                }
                if (!StringUtils.isEmpty((Object)propGrpModel.getCOMMODITY_PROP_GRP_CODE())) {
                    attrModel.setCommodity_prop_grp_code(propGrpModel.getCOMMODITY_PROP_GRP_CODE());
                }
                if (!StringUtils.isEmpty((Object)propGrpModel.getCOMMODITY_PROP_GRP_NAME())) {
                    attrModel.setCommodity_prop_grp_name(propGrpModel.getCOMMODITY_PROP_GRP_NAME());
                }
                if (!StringUtils.isEmpty((Object)propGrpModel.getCOMMODITY_PROP_GRP_TYPE())) {
                    attrModel.setCommodity_prop_grp_type(propGrpModel.getCOMMODITY_PROP_GRP_TYPE());
                }
                if (!StringUtils.isEmpty((Object)propGrpModel.getPROP_GRP_STATUS())) {
                    attrModel.setProp_grp_status(propGrpModel.getPROP_GRP_STATUS());
                }
                attributeModels.add(attributeModel);
            }
        }
        logger.info("\u672c\u6b21\u5c5e\u6027\u5b9a\u4e49" + defId + ",\u5bf9\u5e94\u7684\u5c5e\u6027\u7ec4\u5927\u5c0f\uff1a" + attributeModels.size());
        return attributeModels;
    }
}

