/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.imp;

import com.google.gson.Gson;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.batchimp.imp.BO.CommodityInfoCheckReqBO;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class UccPutawayApproveProc
implements Runnable {
    private JdbcTemplate jdbcTemplate;
    private String supplierCode;
    private Integer supplierSource;
    private String pageNumber;
    private static final int DEAL_COUNT = 50;
    private static final Logger log = LoggerFactory.getLogger(UccPutawayApproveProc.class);
    private final Long CHANNEL_ID = 1002L;
    private int channel_count;
    private int channel_id;

    public UccPutawayApproveProc(JdbcTemplate jdbcTemplate, String supplierCode, Integer supplierSource, String pageNumber, int channel_id, int channel_count) {
        this.jdbcTemplate = jdbcTemplate;
        this.supplierCode = supplierCode;
        this.supplierSource = supplierSource;
        this.pageNumber = pageNumber;
        this.channel_count = channel_count;
        this.channel_id = channel_id;
    }

    @Override
    public void run() {
        Long aLong = (Long)this.jdbcTemplate.queryForObject("select SUPPLIER_ID from ucc_supplier where SUPPLIER_CODE=? and SUPPLIER_SOURCE=?", Long.class, new Object[]{this.supplierCode, this.supplierSource});
        Long shopId = (Long)this.jdbcTemplate.queryForObject("select SUPPLIER_SHOP_ID from ucc_supplier_shop where SUPPLIER_ID=?", Long.class, new Object[]{aLong});
        HttpRequest http = new HttpRequest();
        String urlApproval = PropertiesUtil.getProperties("elcCommodityExaminationUrl");
        String urlSyncEs = PropertiesUtil.getProperties("syncEsUrl");
        if (!StringUtils.hasText((String)urlApproval) || !StringUtils.hasText((String)urlSyncEs)) {
            log.error("\u5ba1\u6838\u5730\u5740\u4e3a\u7a7a\u6216\u540c\u6b65es\u5730\u5740\u4e3a\u7a7a");
        } else {
            List maps = this.jdbcTemplate.queryForList("select COMMODITY_ID from ucc_commodity where SUPPLIER_SHOP_ID=? and mod(COMMODITY_ID,?)=?", new Object[]{shopId, this.channel_count, this.channel_id});
            ArrayList<Long> skuList = new ArrayList<Long>();
            if (!CollectionUtils.isEmpty((Collection)maps)) {
                for (Map next : maps) {
                    Long sku = (Long)next.get("COMMODITY_ID");
                    skuList.add(sku);
                }
            }
            int dealTimes = (int)Math.ceil((double)skuList.size() / 50.0);
            for (int i = 1; i <= dealTimes; ++i) {
                int startPos = (i - 1) * 50;
                int endPos = startPos + 50;
                if (endPos > skuList.size()) {
                    endPos = skuList.size();
                }
                List longs = skuList.subList(startPos, endPos);
                CommodityInfoCheckReqBO commodityInfoCheckReqBO = new CommodityInfoCheckReqBO();
                HashMap<String, Object> syncEsMap = new HashMap<String, Object>(8);
                Long[] commoditys = new Long[longs.size()];
                for (int j = 0; j < commoditys.length; ++j) {
                    commoditys[j] = (Long)longs.get(j);
                }
                commodityInfoCheckReqBO.setCommodityId(commoditys);
                commodityInfoCheckReqBO.setSupplierId(aLong + "");
                syncEsMap.put("operType", 0);
                syncEsMap.put("syncType", 0);
                syncEsMap.put("commodityIds", commoditys);
                syncEsMap.put("supplierId", aLong);
                Gson gson = new Gson();
                log.info("gson.toJson(commodityInfoCheckReqBO):" + gson.toJson((Object)commodityInfoCheckReqBO));
                log.info("gson.toJson(syncEsMap):" + gson.toJson(syncEsMap));
                ArrayList<Object[]> channelPutParmList = new ArrayList<Object[]>();
                Sequence sequenceUtil = Sequence.getInstance();
                for (int j = 0; j < commoditys.length; ++j) {
                    channelPutParmList.clear();
                    List maps1 = this.jdbcTemplate.queryForList("select SKU_ID,SUPPLIER_SHOP_ID from ucc_sku where COMMODITY_ID=?", new Object[]{commoditys[j]});
                    if (!CollectionUtils.isEmpty((Collection)maps1)) {
                        for (Map next : maps1) {
                            Object[] channelPutParm = new Object[]{sequenceUtil.nextId(), this.CHANNEL_ID, next.get("SUPPLIER_SHOP_ID"), next.get("SKU_ID"), 2, "sys", new Date(), null, null, null};
                            channelPutParmList.add(channelPutParm);
                        }
                    }
                    this.jdbcTemplate.batchUpdate("insert into UCC_CHANNEL_PUT(id,channel_id, supplier_shop_id, put_obj_id, put_obj_type, create_oper_id, create_time, update_oper_id, update_time, remark) values (?,?,?,?,?,?,?,?,?,?)", channelPutParmList);
                }
                http.sendPostJsoneshy(urlSyncEs, gson.toJson(syncEsMap));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage());
                }
                http.sendPostJsoneshy(urlApproval, gson.toJson((Object)commodityInfoCheckReqBO));
            }
        }
    }
}

