/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.imp;

import com.google.gson.Gson;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class UccSyncEsOnlyProc
implements Runnable {
    private JdbcTemplate jdbcTemplate;
    private String supplierCode;
    private Integer supplierSource;
    private static final int DEAL_COUNT = 50;
    private static final Logger log = LoggerFactory.getLogger(UccSyncEsOnlyProc.class);
    private int threadCount;
    private int threadId;

    public UccSyncEsOnlyProc(JdbcTemplate jdbcTemplate, String supplierCode, Integer supplierSource, int threadId, int threadCount) {
        this.jdbcTemplate = jdbcTemplate;
        this.supplierCode = supplierCode;
        this.supplierSource = supplierSource;
        this.threadCount = threadCount;
        this.threadId = threadId;
    }

    @Override
    public void run() {
        Long aLong = (Long)this.jdbcTemplate.queryForObject("select SUPPLIER_ID from ucc_supplier where SUPPLIER_CODE=? and SUPPLIER_SOURCE=?", Long.class, new Object[]{this.supplierCode, this.supplierSource});
        Long shopId = (Long)this.jdbcTemplate.queryForObject("select SUPPLIER_SHOP_ID from ucc_supplier_shop where SUPPLIER_ID=?", Long.class, new Object[]{aLong});
        HttpRequest http = new HttpRequest();
        String urlSyncEs = PropertiesUtil.getProperties("syncEsUrl");
        if (!StringUtils.hasText((String)urlSyncEs)) {
            log.error("\u540c\u6b65es\u5730\u5740\u4e3a\u7a7a");
        } else {
            List maps = this.jdbcTemplate.queryForList("select COMMODITY_ID from ucc_commodity where SUPPLIER_SHOP_ID=? and mod(COMMODITY_ID,?)=?", new Object[]{shopId, this.threadCount, this.threadId});
            ArrayList<Long> skuList = new ArrayList<Long>();
            if (!CollectionUtils.isEmpty((Collection)maps)) {
                for (Map next : maps) {
                    Long sku = (Long)next.get("COMMODITY_ID");
                    skuList.add(sku);
                }
            }
            int dealTimes = (int)Math.ceil((double)skuList.size() / 50.0);
            for (int i = 1; i <= dealTimes; ++i) {
                int startPos = (i - 1) * 50;
                int endPos = startPos + 50;
                if (endPos > skuList.size()) {
                    endPos = skuList.size();
                }
                List longs = skuList.subList(startPos, endPos);
                HashMap<String, Object> syncEsMap = new HashMap<String, Object>(8);
                Long[] commoditys = new Long[longs.size()];
                for (int j = 0; j < commoditys.length; ++j) {
                    commoditys[j] = (Long)longs.get(j);
                }
                syncEsMap.put("operType", 0);
                syncEsMap.put("syncType", 0);
                syncEsMap.put("commodityIds", commoditys);
                syncEsMap.put("supplierId", aLong);
                Gson gson = new Gson();
                log.info("gson.toJson(syncEsMap):" + gson.toJson(syncEsMap));
                http.sendPostJsoneshy(urlSyncEs, gson.toJson(syncEsMap));
            }
        }
    }
}

