/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.imp.worker;

import com.tydic.commodity.batchimp.imp.UccBuildConfigurationProc;
import com.tydic.commodity.batchimp.imp.UccImpCommodityProc;
import com.tydic.commodity.batchimp.imp.UccImpPropProc;
import com.tydic.commodity.batchimp.imp.UccPutawayApproveProc;
import com.tydic.commodity.batchimp.initialize.utils.DataPool;
import com.tydic.commodity.utils.InitCacheSequence;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.jdbc.core.JdbcTemplate;

public class UccRunner
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(UccRunner.class);
    JdbcTemplate jdbcTemplate = DataPool.getJdbcTemplatePre();
    private static final String SUPPLIER_CODE_EHSY = "qst";
    private static final String SUPPLIER_CODE_JD = "jd";
    private static final String SUPPLIER_CODE_SUNING = "suning";
    private static final String SUPPLIER_CODE_ESKY = "esky";
    private static final String SUPPLIER_CODE_DELI = "deli";
    private static final String SUPPLIER_CODE_ZKH = "zkh";
    private static final String SUPPLIER_CODE_GRY = "grainger";

    public static void mains(String[] args) throws Exception {
        new UccRunner().run(SUPPLIER_CODE_SUNING, "2", "5", null);
    }

    public void run(String ... args) throws Exception {
        if (args.length <= 0) {
            log.info("\u9700\u8981\u8f93\u5165\u53c2\u6570");
        } else {
            String supplierCode = args[0];
            Integer supplierSource = Integer.valueOf(args[1]);
            String step = args[1];
            String pageNumber = args[2];
            List maps = this.jdbcTemplate.queryForList("select t2.SUPPLIER_SHOP_ID,t2.SUPPLIER_NAME from ucc_supplier t1,ucc_supplier_shop t2 where t1.SUPPLIER_ID = t2.SUPPLIER_ID and t1.SUPPLIER_CODE=?", new Object[]{supplierCode});
            if (CollectionUtils.isEmpty((Collection)maps)) {
                log.info("\u6ca1\u6709\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u7f16\u7801\u4fe1\u606f");
            } else {
                Iterator iterator = maps.iterator();
                Long supplierShopId = 0L;
                String supplierName = "";
                while (iterator.hasNext()) {
                    Map next = (Map)iterator.next();
                    supplierShopId = (Long)next.get("SUPPLIER_SHOP_ID");
                    supplierName = next.get("SUPPLIER_NAME").toString();
                }
                switch (step) {
                    case "1": {
                        break;
                    }
                    case "2": {
                        UccImpPropProc uccImpPropProc = new UccImpPropProc(this.jdbcTemplate, supplierCode, supplierSource, 0, 1);
                        uccImpPropProc.run();
                        break;
                    }
                    case "3": {
                        InitCacheSequence initCacheSequence = new InitCacheSequence(this.jdbcTemplate);
                        UccImpCommodityProc uccImpCommodityProc = new UccImpCommodityProc(this.jdbcTemplate, supplierSource, supplierShopId + "", supplierCode, supplierName, 0, 1, initCacheSequence);
                        uccImpCommodityProc.run();
                        initCacheSequence.clearCache();
                        break;
                    }
                    case "4": {
                        UccBuildConfigurationProc uccBuildConfigurationProc = new UccBuildConfigurationProc(this.jdbcTemplate, supplierCode, supplierSource, 0, 1);
                        uccBuildConfigurationProc.run();
                        break;
                    }
                    case "5": {
                        UccPutawayApproveProc uccPutawayApproveProc = new UccPutawayApproveProc(this.jdbcTemplate, supplierCode, supplierSource, pageNumber, 0, 1);
                        uccPutawayApproveProc.run();
                        break;
                    }
                    default: {
                        log.info("\u4e0d\u652f\u6301\u7684\u6b65\u9aa4!");
                    }
                }
            }
        }
    }
}

