/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.utils;

import com.tydic.commodity.util.CacheMap;
import com.tydic.commodity.utils.SequenceUtil;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class InitCacheSequence {
    private static final Logger log = LoggerFactory.getLogger(InitCacheSequence.class);
    private JdbcTemplate jdbcTemplate;
    private CacheMap cacheMap = CacheMap.getInstance();

    public InitCacheSequence(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.init(jdbcTemplate);
    }

    private void init(JdbcTemplate jdbcTemplate) {
        SequenceUtil sequenceCom = new SequenceUtil(jdbcTemplate, "SEQ_UCC_COMMODITY");
        SequenceUtil sequenceSku = new SequenceUtil(jdbcTemplate, "SEQ_UCC_SKU");
        ConcurrentLinkedQueue<Long> comQueue = new ConcurrentLinkedQueue<Long>();
        ConcurrentLinkedQueue<Long> skuQueue = new ConcurrentLinkedQueue<Long>();
        try {
            long[] comIds = sequenceCom.nextIds(1000);
            long[] skuIds = sequenceSku.nextIds(1000);
            this.addToQueue(comIds, comQueue);
            this.addToQueue(skuIds, skuQueue);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.cacheMap.putValue("UCC_INIT_SEQ_UCC_COMMODITY", comQueue);
        this.cacheMap.putValue("UCC_INIT_SEQ_UCC_SKU", skuQueue);
    }

    private void addToQueue(long[] ids, Queue<Long> queue) {
        for (long id : ids) {
            queue.add(id);
        }
    }

    public Long getId(String sequenceKey) {
        Long id = 0L;
        try {
            ConcurrentLinkedQueue<Long> value = (ConcurrentLinkedQueue<Long>)CacheMap.getInstance().getValueByKey(sequenceKey);
            if (CollectionUtils.isEmpty((Collection)value)) {
                if (null == value) {
                    value = new ConcurrentLinkedQueue<Long>();
                }
                SequenceUtil sequenceUtil = new SequenceUtil(this.jdbcTemplate, StringUtils.replace((String)sequenceKey, (String)"UCC_INIT_", (String)""));
                long[] ids = sequenceUtil.nextIds(1000);
                this.addToQueue(ids, value);
            }
            id = (Long)value.poll();
            this.cacheMap.putValue(sequenceKey, value);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return id;
    }

    public void clearCache() {
        this.cacheMap.remove("UCC_INIT_SEQ_UCC_COMMODITY");
        this.cacheMap.remove("UCC_INIT_SEQ_UCC_SKU");
    }
}

