/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity;

import com.tydic.commodity.batchimp.imp.UccBuildConfigurationProc;
import com.tydic.commodity.batchimp.imp.UccImpCommodityProc;
import com.tydic.commodity.batchimp.imp.UccImpPropProc;
import com.tydic.commodity.batchimp.imp.UccPutawayApproveOnlyProc;
import com.tydic.commodity.batchimp.imp.UccPutawayApproveProc;
import com.tydic.commodity.batchimp.initialize.req.processor.deli.DeliApiGetDetailProc;
import com.tydic.commodity.batchimp.initialize.req.processor.deli.DeliApiGetPageNumProc;
import com.tydic.commodity.batchimp.initialize.req.processor.deli.DeliApiGetSellPriceProc;
import com.tydic.commodity.batchimp.initialize.req.processor.deli.DeliApiGetSkuByPageProc;
import com.tydic.commodity.batchimp.initialize.req.processor.eshy.EshyApiGetDetailProc;
import com.tydic.commodity.batchimp.initialize.req.processor.eshy.EshyApiGetPageNumProc;
import com.tydic.commodity.batchimp.initialize.req.processor.eshy.EshyApiGetSellPrice;
import com.tydic.commodity.batchimp.initialize.req.processor.eshy.EshyApiGetSkuByPageNumProc;
import com.tydic.commodity.batchimp.initialize.req.processor.eshy.EshyApiGetTokenProc;
import com.tydic.commodity.batchimp.initialize.req.processor.grainger.GrgApiGetDetailProc;
import com.tydic.commodity.batchimp.initialize.req.processor.grainger.GrgApiGetPageNumProc;
import com.tydic.commodity.batchimp.initialize.req.processor.grainger.GrgApiGetSellPriceProc;
import com.tydic.commodity.batchimp.initialize.req.processor.grainger.GrgApiGetSkuByPageNumProc;
import com.tydic.commodity.batchimp.initialize.req.processor.grainger.GrgApiGetTokenProc;
import com.tydic.commodity.batchimp.initialize.req.processor.jd.JDApiGetSkuPageProc;
import com.tydic.commodity.batchimp.initialize.req.processor.jd.JDApiPriceProc;
import com.tydic.commodity.batchimp.initialize.req.processor.jd.JDApiProductGetNumPageProc;
import com.tydic.commodity.batchimp.initialize.req.processor.jd.JDApiSkuDetailProc;
import com.tydic.commodity.batchimp.initialize.req.processor.linkedmall.LinkedMallGetItemsProc;
import com.tydic.commodity.batchimp.initialize.req.processor.qst.QstApiGetDetailProc;
import com.tydic.commodity.batchimp.initialize.req.processor.qst.QstApiGetPageNumProc;
import com.tydic.commodity.batchimp.initialize.req.processor.qst.QstApiGetSellPrice;
import com.tydic.commodity.batchimp.initialize.req.processor.qst.QstApiGetSkuByPageNumProc;
import com.tydic.commodity.batchimp.initialize.req.processor.qst.QstApiGetTokenProc;
import com.tydic.commodity.batchimp.initialize.req.processor.suning.NewSuningApiGetDetailProc;
import com.tydic.commodity.batchimp.initialize.req.processor.suning.NewSuningApiGetPageNumProc;
import com.tydic.commodity.batchimp.initialize.req.processor.suning.NewSuningApiGetSellPrice;
import com.tydic.commodity.batchimp.initialize.req.processor.suning.NewSuningApiGetSkuByPageProc;
import com.tydic.commodity.batchimp.initialize.req.processor.suning.NewSunningApiGetTokenProc;
import com.tydic.commodity.batchimp.initialize.req.processor.zjj.OrganRule;
import com.tydic.commodity.batchimp.initialize.req.processor.zkh.ZkhApiGetDetailProc;
import com.tydic.commodity.batchimp.initialize.req.processor.zkh.ZkhApiGetPageNumProc;
import com.tydic.commodity.batchimp.initialize.req.processor.zkh.ZkhApiGetSellPrice;
import com.tydic.commodity.batchimp.initialize.req.processor.zkh.ZkhApiGetSkuByPageProc;
import com.tydic.commodity.batchimp.initialize.resp.model.deli.DeliToken;
import com.tydic.commodity.batchimp.initialize.utils.DataPool;
import com.tydic.commodity.utils.SequenceMem;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

public class UccInitRunner {
    private static final Logger log = LoggerFactory.getLogger(UccInitRunner.class);
    JdbcTemplate jdbcTemplate = DataPool.getJdbcTemplatePre();
    private static final String SUPPLIER_CODE_QST = "qst";
    private static final String SUPPLIER_CODE_JD = "jd";
    private static final String SUPPLIER_CODE_SUNING = "suning";
    private static final String SUPPLIER_CODE_EHSY = "ehsy";
    private static final String SUPPLIER_CODE_DELI = "deli";
    private static final String SUPPLIER_CODE_ZKH = "zkh";
    private static final String SUPPLIER_CODE_GRY = "grainger";
    private static final String SUPPLIER_CODE_LINKEDMALL = "linkedmall";
    private static Integer threadCount = 1;

    public static void main(String[] args) throws Exception {
        String supplierCode = args[0];
        String step = args[1];
        String pageNumber = args[2];
        String token = args[3];
        String thread = args[4];
        if (!StringUtils.isEmpty((Object)thread)) {
            threadCount = Integer.parseInt(thread);
        }
        log.info(">>>>Program start..." + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        log.info("\u4f9b\u5e94\u5546\u7f16\u7801:" + supplierCode);
        log.info("\u6b65\u9aa4:" + step);
        log.info("\u9700\u8981\u5355\u72ec\u5904\u7406\u7684\u9875\u7801:" + pageNumber);
        log.info("token:" + token);
        log.info("\u7ebf\u7a0b\u603b\u6570:" + threadCount);
        new UccInitRunner().run(supplierCode, step, pageNumber, token);
        log.info(">>>>Program end..." + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
    }

    public void run(String ... args) throws Exception {
        if (args.length <= 0) {
            log.info("\u9700\u8981\u8f93\u5165\u53c2\u6570");
        } else {
            String supplierCode = args[0];
            String step = args[1];
            String parm = args[2];
            String token = args[3];
            if (StringUtils.isEmpty((Object)supplierCode)) {
                log.info("\u94fa\u8d27\u5355\u4f4dCODE\u4e0d\u53ef\u4e3a\u7a7a");
            } else {
                switch (supplierCode) {
                    case "qst": {
                        this.qstApiProc(step, parm, token);
                        break;
                    }
                    case "jd": {
                        if (StringUtils.isEmpty((Object)token)) {
                            log.info("\u4eac\u4e1c\u8bf7\u8f93\u5165token");
                            break;
                        }
                        this.jdApiProc(step, parm, token);
                        break;
                    }
                    case "suning": {
                        if (StringUtils.isEmpty((Object)token)) {
                            log.info("\u82cf\u5b81\u8bf7\u8f93\u5165token");
                            break;
                        }
                        this.SuningApiProc(step, parm, token);
                        break;
                    }
                    case "ehsy": {
                        this.EskyApiProc(step, parm, token);
                        break;
                    }
                    case "deli": {
                        this.DeliApiProc(step, parm, token);
                        break;
                    }
                    case "zkh": {
                        if (StringUtils.isEmpty((Object)token)) {
                            log.info(" \u9707\u5764\u884c\u8bf7\u8f93\u5165token");
                            break;
                        }
                        this.ZkhApiProc(step, parm, token);
                        break;
                    }
                    case "grainger": {
                        this.GryApiProc(step, parm, token);
                        break;
                    }
                    case "linkedmall": {
                        this.linkedMallProc(step, parm, token);
                        break;
                    }
                    default: {
                        log.info("\u4e0d\u652f\u6301\u7684\u4f9b\u5e94\u5546!");
                    }
                }
            }
        }
    }

    private void qstApiProc(String step, String parm, String tokenStr) throws Exception {
        DeliToken token = new DeliToken();
        if (!StringUtils.isEmpty((Object)tokenStr)) {
            token.setAccess_token(tokenStr);
        } else {
            QstApiGetTokenProc qstApiGetTokenProc = new QstApiGetTokenProc(this.jdbcTemplate);
            token = qstApiGetTokenProc.run();
        }
        int total = threadCount;
        String pageNumber = null;
        if (!StringUtils.isEmpty((Object)parm)) {
            pageNumber = parm;
        }
        switch (step) {
            case "1": {
                this.jdbcTemplate.update("delete from UCC_COMMODITY_PAGE_NUM where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_QST});
                QstApiGetPageNumProc qstApiGetPageNumProc = new QstApiGetPageNumProc(this.jdbcTemplate, token, SUPPLIER_CODE_QST);
                qstApiGetPageNumProc.run();
                break;
            }
            case "2": {
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_SET where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_QST});
                for (int i = 0; i < total; ++i) {
                    QstApiGetSkuByPageNumProc qstApiGetSkuByPageNumProc = new QstApiGetSkuByPageNumProc(this.jdbcTemplate, token, i, total, pageNumber, SUPPLIER_CODE_QST);
                    Thread t1 = new Thread(qstApiGetSkuByPageNumProc);
                    t1.start();
                }
                break;
            }
            case "3": {
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_DETAIL where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_QST});
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_ATTR where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_QST});
                for (int i = 0; i < total; ++i) {
                    QstApiGetDetailProc qstApiGetDetailProc = new QstApiGetDetailProc(this.jdbcTemplate, token, i, total, SUPPLIER_CODE_QST);
                    Thread d1 = new Thread(qstApiGetDetailProc);
                    d1.start();
                }
                break;
            }
            case "4": {
                this.jdbcTemplate.update("delete from EXTERNAL_PRICE where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_QST});
                for (int i = 0; i < total; ++i) {
                    QstApiGetSellPrice qstApiGetSellPrice = new QstApiGetSellPrice(this.jdbcTemplate, token, i, total, SUPPLIER_CODE_QST);
                    Thread d1 = new Thread(qstApiGetSellPrice);
                    d1.start();
                }
                break;
            }
            default: {
                this.uccRunnerMethod(SUPPLIER_CODE_QST, step, pageNumber);
            }
        }
    }

    private void jdApiProc(String step, String parm, String tokenStr) throws Exception {
        String access_token = tokenStr;
        log.info("access_token:" + access_token);
        int total = threadCount;
        String pageNumber = null;
        if (!StringUtils.isEmpty((Object)parm)) {
            pageNumber = parm;
        }
        switch (step) {
            case "1": {
                this.jdbcTemplate.update("delete from UCC_COMMODITY_PAGE_NUM where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_JD});
                JDApiProductGetNumPageProc jDApiProductGetNumPageProc = new JDApiProductGetNumPageProc(access_token, this.jdbcTemplate, SUPPLIER_CODE_JD);
                jDApiProductGetNumPageProc.run();
                break;
            }
            case "2": {
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_SET where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_JD});
                for (int i = 0; i < total; ++i) {
                    JDApiGetSkuPageProc jdApiGetSkuPageProc = new JDApiGetSkuPageProc(this.jdbcTemplate, access_token, i, total, pageNumber, SUPPLIER_CODE_JD);
                    Thread t1 = new Thread(jdApiGetSkuPageProc);
                    t1.start();
                }
                break;
            }
            case "3": {
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_DETAIL where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_JD});
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_ATTR where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_JD});
                for (int i = 0; i < total; ++i) {
                    JDApiSkuDetailProc jDApiSkuDetailProc = new JDApiSkuDetailProc(access_token, this.jdbcTemplate, i, total, SUPPLIER_CODE_JD);
                    Thread t1 = new Thread(jDApiSkuDetailProc);
                    t1.start();
                }
                break;
            }
            case "4": {
                this.jdbcTemplate.update("delete from EXTERNAL_PRICE where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_JD});
                for (int i = 0; i < total; ++i) {
                    JDApiPriceProc jdApiPriceProc = new JDApiPriceProc(access_token, this.jdbcTemplate, i, total, SUPPLIER_CODE_JD);
                    Thread t1 = new Thread(jdApiPriceProc);
                    t1.start();
                }
                break;
            }
            default: {
                this.uccRunnerMethod(SUPPLIER_CODE_JD, step, pageNumber);
            }
        }
    }

    private void ZJJ() throws Exception {
        OrganRule or = new OrganRule(this.jdbcTemplate);
        or.ParseLevel();
    }

    private void SuningApiProc(String step, String parm, String tokenStr) throws Exception {
        NewSunningApiGetTokenProc newSunningApiGetTokenProc = new NewSunningApiGetTokenProc(this.jdbcTemplate);
        DeliToken token = new DeliToken();
        token.setAccess_token(tokenStr);
        int total = threadCount;
        String pageNumber = null;
        if (!StringUtils.isEmpty((Object)parm)) {
            pageNumber = parm;
        }
        switch (step) {
            case "1": {
                this.jdbcTemplate.update("delete from UCC_COMMODITY_PAGE_NUM where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_SUNING});
                NewSuningApiGetPageNumProc newSuningApiGetPageNumProc = new NewSuningApiGetPageNumProc(this.jdbcTemplate, token.getAccess_token(), SUPPLIER_CODE_SUNING);
                newSuningApiGetPageNumProc.run();
                break;
            }
            case "2": {
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_SET where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_SUNING});
                for (int i = 0; i < total; ++i) {
                    NewSuningApiGetSkuByPageProc newSuningApiGetSkuByPageProc = new NewSuningApiGetSkuByPageProc(this.jdbcTemplate, token.getAccess_token(), i, total, pageNumber, SUPPLIER_CODE_SUNING);
                    Thread t1 = new Thread(newSuningApiGetSkuByPageProc);
                    t1.start();
                }
                break;
            }
            case "3": {
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_ATTR where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_SUNING});
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_DETAIL where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_SUNING});
                this.jdbcTemplate.update("delete from external_commodity_detail where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_SUNING});
                for (int i = 0; i < total; ++i) {
                    NewSuningApiGetDetailProc newSuningApiGetDetailProc = new NewSuningApiGetDetailProc(this.jdbcTemplate, token.getAccess_token(), i, total, SUPPLIER_CODE_SUNING);
                    Thread d1 = new Thread(newSuningApiGetDetailProc);
                    d1.start();
                }
                break;
            }
            case "4": {
                this.jdbcTemplate.update("delete from EXTERNAL_PRICE where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_SUNING});
                for (int i = 0; i < total; ++i) {
                    NewSuningApiGetSellPrice newSuningApiGetSellPrice = new NewSuningApiGetSellPrice(this.jdbcTemplate, token.getAccess_token(), i, total, SUPPLIER_CODE_SUNING);
                    Thread d1 = new Thread(newSuningApiGetSellPrice);
                    d1.start();
                }
                break;
            }
            default: {
                this.uccRunnerMethod(SUPPLIER_CODE_SUNING, step, pageNumber);
            }
        }
    }

    private void EskyApiProc(String step, String parm, String tokenStr) throws Exception {
        DeliToken token = new DeliToken();
        if (!StringUtils.isEmpty((Object)tokenStr)) {
            token.setAccess_token(tokenStr);
        } else {
            EshyApiGetTokenProc eshyApiGetTokenProc = new EshyApiGetTokenProc(this.jdbcTemplate);
            token = eshyApiGetTokenProc.run();
        }
        int total = threadCount;
        String pageNumber = null;
        if (!StringUtils.isEmpty((Object)parm)) {
            pageNumber = parm;
        }
        switch (step) {
            case "1": {
                this.jdbcTemplate.update("delete from UCC_COMMODITY_PAGE_NUM where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_EHSY});
                EshyApiGetPageNumProc eshyApiGetPageNumProc = new EshyApiGetPageNumProc(this.jdbcTemplate, token, SUPPLIER_CODE_EHSY);
                eshyApiGetPageNumProc.run();
                break;
            }
            case "2": {
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_SET where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_EHSY});
                for (int i = 0; i < total; ++i) {
                    EshyApiGetSkuByPageNumProc eshyApiGetSkuByPageNumProc = new EshyApiGetSkuByPageNumProc(this.jdbcTemplate, token, i, total, pageNumber, SUPPLIER_CODE_EHSY);
                    Thread t1 = new Thread(eshyApiGetSkuByPageNumProc);
                    t1.start();
                }
                break;
            }
            case "3": {
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_DETAIL where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_EHSY});
                this.jdbcTemplate.update("delete from external_commodity_detail where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_EHSY});
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_ATTR where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_EHSY});
                for (int i = 0; i < total; ++i) {
                    EshyApiGetDetailProc eshyApiGetDetailProc = new EshyApiGetDetailProc(this.jdbcTemplate, token, i, total, SUPPLIER_CODE_EHSY);
                    Thread d1 = new Thread(eshyApiGetDetailProc);
                    d1.start();
                }
                break;
            }
            case "4": {
                this.jdbcTemplate.update("delete from EXTERNAL_PRICE where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_EHSY});
                for (int i = 0; i < total; ++i) {
                    EshyApiGetSellPrice eshyApiGetSellPrice = new EshyApiGetSellPrice(this.jdbcTemplate, token, i, total, SUPPLIER_CODE_EHSY);
                    Thread d1 = new Thread(eshyApiGetSellPrice);
                    d1.start();
                }
                break;
            }
            default: {
                this.uccRunnerMethod(SUPPLIER_CODE_EHSY, step, pageNumber);
            }
        }
    }

    private void GryApiProc(String step, String parm, String tokenStr) throws Exception {
        DeliToken token = new DeliToken();
        if (!StringUtils.isEmpty((Object)tokenStr)) {
            token.setAccess_token(tokenStr);
        } else {
            GrgApiGetTokenProc grgApiGetTokenProc = new GrgApiGetTokenProc(this.jdbcTemplate);
            token = grgApiGetTokenProc.run();
        }
        int total = threadCount;
        String pageNumber = null;
        if (!StringUtils.isEmpty((Object)parm)) {
            pageNumber = parm;
        }
        switch (step) {
            case "1": {
                this.jdbcTemplate.update("delete from UCC_COMMODITY_PAGE_NUM where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_GRY});
                GrgApiGetPageNumProc grgApiGetPageNumProc = new GrgApiGetPageNumProc(this.jdbcTemplate, token, SUPPLIER_CODE_GRY);
                grgApiGetPageNumProc.run();
                break;
            }
            case "2": {
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_SET where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_GRY});
                for (int i = 0; i < total; ++i) {
                    GrgApiGetSkuByPageNumProc grgApiGetSkuByPageNumProc = new GrgApiGetSkuByPageNumProc(this.jdbcTemplate, token, i, total, pageNumber, SUPPLIER_CODE_GRY);
                    Thread t1 = new Thread(grgApiGetSkuByPageNumProc);
                    t1.start();
                }
                break;
            }
            case "3": {
                for (int i = 0; i < total; ++i) {
                    GrgApiGetDetailProc grgApiGetDetailProc = new GrgApiGetDetailProc(this.jdbcTemplate, token, i, total, SUPPLIER_CODE_GRY);
                    Thread d1 = new Thread(grgApiGetDetailProc);
                    d1.start();
                }
                break;
            }
            case "4": {
                this.jdbcTemplate.update("delete from EXTERNAL_PRICE where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_GRY});
                for (int i = 0; i < total; ++i) {
                    GrgApiGetSellPriceProc grgApiGetSellPriceProc = new GrgApiGetSellPriceProc(this.jdbcTemplate, token, i, total, SUPPLIER_CODE_GRY);
                    Thread d1 = new Thread(grgApiGetSellPriceProc);
                    d1.start();
                }
                break;
            }
            default: {
                this.uccRunnerMethod(SUPPLIER_CODE_GRY, step, pageNumber);
            }
        }
    }

    private void DeliApiProc(String step, String parm, String tokenStr) throws Exception {
        DeliToken token = new DeliToken();
        if (!StringUtils.isEmpty((Object)tokenStr)) {
            token.setAccess_token(tokenStr);
        }
        int total = threadCount;
        String pageNumber = null;
        if (!StringUtils.isEmpty((Object)parm)) {
            pageNumber = parm;
        }
        switch (step) {
            case "1": {
                this.jdbcTemplate.update("delete from UCC_COMMODITY_PAGE_NUM where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_DELI});
                DeliApiGetPageNumProc deliApiGetPageNumProc = new DeliApiGetPageNumProc(this.jdbcTemplate, token, SUPPLIER_CODE_DELI);
                deliApiGetPageNumProc.run();
                break;
            }
            case "2": {
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_SET where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_DELI});
                for (int i = 0; i < total; ++i) {
                    DeliApiGetSkuByPageProc deliApiGetSkuByPageProc = new DeliApiGetSkuByPageProc(this.jdbcTemplate, token, i, total, pageNumber, SUPPLIER_CODE_DELI);
                    Thread t1 = new Thread(deliApiGetSkuByPageProc);
                    t1.start();
                }
                break;
            }
            case "3": {
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_DETAIL where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_DELI});
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_ATTR where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_DELI});
                for (int i = 0; i < total; ++i) {
                    DeliApiGetDetailProc deliApiGetDetailProc = new DeliApiGetDetailProc(this.jdbcTemplate, token, i, total, SUPPLIER_CODE_DELI);
                    Thread d1 = new Thread(deliApiGetDetailProc);
                    d1.start();
                }
                break;
            }
            case "4": {
                this.jdbcTemplate.update("delete from EXTERNAL_PRICE where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_DELI});
                for (int i = 0; i < total; ++i) {
                    DeliApiGetSellPriceProc deliApiGetSellPriceProc = new DeliApiGetSellPriceProc(this.jdbcTemplate, token, i, total, SUPPLIER_CODE_DELI);
                    Thread d1 = new Thread(deliApiGetSellPriceProc);
                    d1.start();
                }
                break;
            }
            default: {
                this.uccRunnerMethod(SUPPLIER_CODE_DELI, step, pageNumber);
            }
        }
    }

    private void ZkhApiProc(String step, String parm, String tokenStr) throws Exception {
        DeliToken token = new DeliToken();
        token.setAccess_token(tokenStr);
        int total = threadCount;
        String pageNumber = null;
        if (!StringUtils.isEmpty((Object)parm)) {
            pageNumber = parm;
        }
        switch (step) {
            case "1": {
                this.jdbcTemplate.update("delete from UCC_COMMODITY_PAGE_NUM where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_ZKH});
                ZkhApiGetPageNumProc zkhApiGetPageNumProc = new ZkhApiGetPageNumProc(this.jdbcTemplate, token, SUPPLIER_CODE_ZKH);
                zkhApiGetPageNumProc.run();
                break;
            }
            case "2": {
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_SET where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_ZKH});
                for (int i = 0; i < total; ++i) {
                    ZkhApiGetSkuByPageProc zkhApiGetSkuByPageProc = new ZkhApiGetSkuByPageProc(this.jdbcTemplate, token, i, total, pageNumber, SUPPLIER_CODE_ZKH);
                    Thread t1 = new Thread(zkhApiGetSkuByPageProc);
                    t1.start();
                }
                break;
            }
            case "3": {
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_DETAIL where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_ZKH});
                this.jdbcTemplate.update("delete from EXTERNAL_SKU_ATTR where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_ZKH});
                for (int i = 0; i < total; ++i) {
                    ZkhApiGetDetailProc zkhApiGetDetailProc = new ZkhApiGetDetailProc(this.jdbcTemplate, token, i, total, SUPPLIER_CODE_ZKH);
                    Thread d1 = new Thread(zkhApiGetDetailProc);
                    d1.start();
                }
                break;
            }
            case "4": {
                this.jdbcTemplate.update("delete from EXTERNAL_PRICE where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_ZKH});
                for (int i = 0; i < total; ++i) {
                    ZkhApiGetSellPrice zkhApiGetSellPrice = new ZkhApiGetSellPrice(this.jdbcTemplate, token, i, total, SUPPLIER_CODE_ZKH);
                    Thread d1 = new Thread(zkhApiGetSellPrice);
                    d1.start();
                }
                break;
            }
            default: {
                this.uccRunnerMethod(SUPPLIER_CODE_ZKH, step, pageNumber);
            }
        }
    }

    private void linkedMallProc(String step, String parm, String tokenStr) throws Exception {
        switch (step) {
            case "1": {
                this.jdbcTemplate.update("delete from external_sku_detail where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_LINKEDMALL});
                this.jdbcTemplate.update("delete from external_commodity_detail where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_LINKEDMALL});
                this.jdbcTemplate.update("delete from external_sku_attr where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_LINKEDMALL});
                this.jdbcTemplate.update("delete from external_price where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_LINKEDMALL});
                this.jdbcTemplate.update("delete from external_sku_pic where SUPPLIER_CODE=?", new Object[]{SUPPLIER_CODE_LINKEDMALL});
                LinkedMallGetItemsProc linkedMallGetItemsProc = new LinkedMallGetItemsProc(this.jdbcTemplate, SUPPLIER_CODE_LINKEDMALL);
                linkedMallGetItemsProc.run();
                break;
            }
            default: {
                this.uccRunnerMethod(SUPPLIER_CODE_LINKEDMALL, step, null);
            }
        }
    }

    public void uccRunnerMethod(String supplierCode, String step, String pageNumber) {
        List maps = this.jdbcTemplate.queryForList("select t2.SUPPLIER_SHOP_ID,t2.SUPPLIER_NAME from ucc_supplier t1,ucc_supplier_shop t2 where t1.SUPPLIER_ID = t2.SUPPLIER_ID and t1.SUPPLIER_CODE=?", new Object[]{supplierCode});
        if (CollectionUtils.isEmpty((Collection)maps)) {
            log.info("\u6ca1\u6709\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u7f16\u7801\u4fe1\u606f");
        } else {
            int total = threadCount;
            Iterator iterator = maps.iterator();
            Long supplierShopId = 0L;
            String supplierName = "";
            SequenceMem sequenceMem = new SequenceMem();
            sequenceMem.initData(this.jdbcTemplate, null);
            while (iterator.hasNext()) {
                Map next = (Map)iterator.next();
                supplierShopId = (Long)next.get("SUPPLIER_SHOP_ID");
                supplierName = next.get("SUPPLIER_NAME").toString();
            }
            switch (step) {
                case "5": {
                    break;
                }
                case "6": {
                    for (int i = 0; i < total; ++i) {
                        UccImpPropProc uccImpPropProc = new UccImpPropProc(this.jdbcTemplate, supplierCode, i, total, sequenceMem);
                        Thread t1 = new Thread(uccImpPropProc);
                        t1.start();
                    }
                    break;
                }
                case "7": {
                    for (int i = 0; i < total; ++i) {
                        UccImpCommodityProc uccImpCommodityProc = new UccImpCommodityProc(this.jdbcTemplate, supplierShopId + "", supplierCode, supplierName, i, total, sequenceMem);
                        Thread t1 = new Thread(uccImpCommodityProc);
                        t1.start();
                    }
                    break;
                }
                case "8": {
                    for (int i = 0; i < total; ++i) {
                        UccBuildConfigurationProc uccBuildConfigurationProc = new UccBuildConfigurationProc(this.jdbcTemplate, supplierCode, i, total);
                        Thread t1 = new Thread(uccBuildConfigurationProc);
                        t1.start();
                    }
                    break;
                }
                case "9": {
                    for (int i = 0; i < total; ++i) {
                        UccPutawayApproveProc uccPutawayApproveProc = new UccPutawayApproveProc(this.jdbcTemplate, supplierCode, pageNumber, i, total);
                        Thread t1 = new Thread(uccPutawayApproveProc);
                        t1.start();
                    }
                    break;
                }
                case "10": {
                    for (int i = 0; i < total; ++i) {
                        UccPutawayApproveOnlyProc uccPutawayApproveOnlyProc = new UccPutawayApproveOnlyProc(this.jdbcTemplate, supplierCode, pageNumber, i, total);
                        Thread t1 = new Thread(uccPutawayApproveOnlyProc);
                        t1.start();
                    }
                    break;
                }
                default: {
                    log.info("\u4e0d\u652f\u6301\u7684\u6b65\u9aa4!");
                }
            }
        }
    }
}

