/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.google.gson.Gson;
import com.tydic.commodity.atom.BO.UccDealPutawayApproveReqBO;
import com.tydic.commodity.atom.BO.UccDealPutawayApproveRespBO;
import com.tydic.commodity.atom.UccDealPutawayApproveAtomService;
import com.tydic.commodity.batchimp.imp.BO.CommodityInfoCheckReqBO;
import com.tydic.commodity.batchimp.imp.InsertDataService;
import com.tydic.commodity.utils.SequenceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class UccDealPutawayApproveAtomServiceImpl
implements UccDealPutawayApproveAtomService {
    private static final int DEAL_COUNT = 50;
    private final Long CHANNEL_ID = 1002L;
    private static final Logger log = LoggerFactory.getLogger(UccDealPutawayApproveAtomServiceImpl.class);

    @Override
    public UccDealPutawayApproveRespBO dealPutawayApprove(UccDealPutawayApproveReqBO uccDealPutawayApproveReqBO) {
        JdbcTemplate jdbcTemplate = uccDealPutawayApproveReqBO.getJdbcTemplate();
        String supplierCode = uccDealPutawayApproveReqBO.getSupplierCode();
        String pageNumber = uccDealPutawayApproveReqBO.getPageNumber();
        Long aLong = (Long)jdbcTemplate.queryForObject("select SUPPLIER_ID from ucc_supplier where SUPPLIER_CODE=?", Long.class, new Object[]{supplierCode});
        List maps = StringUtils.isEmpty((Object)pageNumber) ? jdbcTemplate.queryForList("select COMMODITY_ID from ucc_commodity where EXT_SKU_ID in (select sku from external_sku_detail where SUPPLIER_CODE = ? and SKU in  (" + uccDealPutawayApproveReqBO.getSkuListStr() + "))", new Object[]{supplierCode}) : jdbcTemplate.queryForList("select COMMODITY_ID from ucc_commodity where EXT_SKU_ID in (select SKU from external_sku_set where SUPPLIER_CODE = ? and PAGE_NUM=? and SKU in  (" + uccDealPutawayApproveReqBO.getSkuListStr() + "))", new Object[]{supplierCode, pageNumber});
        ArrayList<Long> skuList = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)maps)) {
            for (Map next : maps) {
                Long sku = (Long)next.get("COMMODITY_ID");
                skuList.add(sku);
            }
        }
        int dealTimes = (int)Math.ceil((double)skuList.size() / 50.0);
        ArrayList<CommodityInfoCheckReqBO> commodityInfoCheckReqBOList = new ArrayList<CommodityInfoCheckReqBO>();
        for (int i = 1; i <= dealTimes; ++i) {
            int startPos = (i - 1) * 50;
            int endPos = startPos + 50;
            if (endPos > skuList.size()) {
                endPos = skuList.size();
            }
            List longs = skuList.subList(startPos, endPos);
            CommodityInfoCheckReqBO commodityInfoCheckReqBO = new CommodityInfoCheckReqBO();
            Long[] commoditys = new Long[longs.size()];
            for (int j = 0; j < commoditys.length; ++j) {
                commoditys[j] = (Long)longs.get(j);
            }
            commodityInfoCheckReqBO.setCommodityId(commoditys);
            commodityInfoCheckReqBO.setSupplierId(aLong + "");
            Gson gson = new Gson();
            System.out.println("gson.toJson(commodityInfoCheckReqBO):" + gson.toJson((Object)commodityInfoCheckReqBO));
            ArrayList<Object[]> channelPutParmList = new ArrayList<Object[]>();
            SequenceUtil sequenceChannelPutId = new SequenceUtil(jdbcTemplate, "SEQ_CHNNEL_PUT_ID");
            for (int j = 0; j < commoditys.length; ++j) {
                List maps1 = jdbcTemplate.queryForList("select SKU_ID,SUPPLIER_SHOP_ID from ucc_sku where COMMODITY_ID=?", new Object[]{commoditys[j]});
                if (!CollectionUtils.isEmpty((Collection)maps1)) {
                    for (Map next : maps1) {
                        Object[] channelPutParm = new Object[]{sequenceChannelPutId.getSeqNext(), this.CHANNEL_ID, next.get("SUPPLIER_SHOP_ID"), next.get("SKU_ID"), 2, "sys", new Date(), null, null, null};
                        channelPutParmList.add(channelPutParm);
                    }
                }
                InsertDataService insertDataService = new InsertDataService(jdbcTemplate);
                if (commoditys[j] == null) continue;
                insertDataService.insertData(commoditys[j] + "");
                System.out.println("");
            }
            commodityInfoCheckReqBOList.add(commodityInfoCheckReqBO);
            jdbcTemplate.batchUpdate("insert into UCC_CHANNEL_PUT(id,channel_id, supplier_shop_id, put_obj_id, put_obj_type, create_oper_id, create_time, update_oper_id, update_time, remark) values (?,?,?,?,?,?,?,?,?,?)", channelPutParmList);
        }
        UccDealPutawayApproveRespBO uccDealPutawayApproveRespBO = new UccDealPutawayApproveRespBO();
        uccDealPutawayApproveRespBO.setRespCode("0000");
        uccDealPutawayApproveRespBO.setRespDesc("\u6210\u529f");
        uccDealPutawayApproveRespBO.setCommodityInfoCheckReqBOList(commodityInfoCheckReqBOList);
        return uccDealPutawayApproveRespBO;
    }
}

