/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.atom.BO.UccDealSkuDetailReqBO;
import com.tydic.commodity.atom.BO.UccDealSkuDetailRespBO;
import com.tydic.commodity.atom.BO.UccSkuAttrBO;
import com.tydic.commodity.atom.BO.UccSkuDetailBO;
import com.tydic.commodity.atom.UccDealSkuDetailAtomService;
import com.tydic.commodity.utils.HttpTool;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class UccDealSkuDetailAtomServiceImpl
implements UccDealSkuDetailAtomService {
    @Override
    public UccDealSkuDetailRespBO dealSkuDetail(UccDealSkuDetailReqBO uccDealSkuDetailReqBO) {
        String getDetailUrl = PropertiesUtil.getProperty("outinterface.getDetailurl");
        UccDealSkuDetailRespBO uccDealSkuDetailRespBO = new UccDealSkuDetailRespBO();
        List<String> skuCodeList = uccDealSkuDetailReqBO.getSkuCodeList();
        String supplierCode = uccDealSkuDetailReqBO.getSupplierCode();
        JdbcTemplate jdbcTemplate = uccDealSkuDetailReqBO.getJdbcTemplate();
        if (!CollectionUtils.isEmpty(skuCodeList)) {
            jdbcTemplate.update("delete from EXTERNAL_SKU_DETAIL where SUPPLIER_CODE=? and sku_source=1", new Object[]{supplierCode});
            jdbcTemplate.update("delete from EXTERNAL_SKU_ATTR where SUPPLIER_CODE=? and sku_source=1", new Object[]{supplierCode});
            for (String skuId : skuCodeList) {
                String imagePath;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("hsn", (Object)supplierCode);
                jsonObject.put("sku", (Object)skuId);
                jsonObject.put("isShow", (Object)false);
                String respJson = HttpTool.sendPostJson(getDetailUrl, jsonObject.toJSONString());
                JSONObject respObj = JSONObject.parseObject((String)respJson);
                boolean success = (Boolean)respObj.get((Object)"success");
                if (!success) {
                    uccDealSkuDetailRespBO.setRespCode("8888");
                    uccDealSkuDetailRespBO.setRespDesc("\u67e5\u8be2\u8be6\u60c5\u5931\u8d25," + respObj.getString("resultMessage"));
                    return uccDealSkuDetailRespBO;
                }
                UccSkuDetailBO uccSkuDetailBO = this.dealSkuDetailResult(respObj);
                if (uccSkuDetailBO != null && !StringUtils.isEmpty((Object)(imagePath = uccSkuDetailBO.getImagePath()))) {
                    imagePath = PropertiesUtil.getImageHeadProperty(supplierCode) + imagePath;
                    uccSkuDetailBO.setImagePath(imagePath);
                }
                if (uccSkuDetailBO == null) continue;
                jdbcTemplate.update("INSERT INTO EXTERNAL_SKU_DETAIL (SALE_UNIT,weight,PRODUCT_AREA,WARE_QD,IMAGE_PATH,BRAND_PIC,param,state,moq,BRAND_NAME,sku,MFG_SKU,upc,name,DELIVERY_TIME,introduction,sku_cate1,sku_cate2,sku_cate3,sku_cate4,SUPPLIER_CODE,sku_source) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{uccSkuDetailBO.getSaleUnit(), uccSkuDetailBO.getWeight(), uccSkuDetailBO.getProductArea(), uccSkuDetailBO.getWareQD(), uccSkuDetailBO.getImagePath(), uccSkuDetailBO.getBrandPic(), uccSkuDetailBO.getParam(), uccSkuDetailBO.getState(), uccSkuDetailBO.getMoq(), uccSkuDetailBO.getBrandName(), uccSkuDetailBO.getSku(), uccSkuDetailBO.getMfgSku(), uccSkuDetailBO.getUpc(), uccSkuDetailBO.getName(), uccSkuDetailBO.getDeliveryTime(), uccSkuDetailBO.getIntroduction(), uccSkuDetailBO.getSkuCate1(), uccSkuDetailBO.getSkuCate2(), uccSkuDetailBO.getSkuCate3(), uccSkuDetailBO.getSkuCate4(), supplierCode, 1});
                List<UccSkuAttrBO> uccSkuAttrBOList = uccSkuDetailBO.getUccSkuAttrBOList();
                if (CollectionUtils.isEmpty(uccSkuAttrBOList)) continue;
                for (UccSkuAttrBO uccSkuAttrBO : uccSkuAttrBOList) {
                    jdbcTemplate.update("INSERT INTO EXTERNAL_SKU_ATTR (sku,ATTR_CODE,ATTR_GROUP_CODE,ATTR_GROUP_NAME,ATTR_GROUP_SEQ,ATTR_NAME,ATTR_SEQ,ATTR_VALUE,SUPPLIER_CODE,sku_source) VALUES (?,?,?,?,?,?,?,?,?,?)", new Object[]{uccSkuAttrBO.getSku(), uccSkuAttrBO.getAttrCode(), uccSkuAttrBO.getAttrGroupCode(), uccSkuAttrBO.getAttrGroupName(), uccSkuAttrBO.getAttrGroupSeq(), uccSkuAttrBO.getAttrName(), uccSkuAttrBO.getAttrSeq(), uccSkuAttrBO.getAttrValue(), supplierCode, 1});
                }
            }
        }
        uccDealSkuDetailRespBO.setRespCode("0000");
        uccDealSkuDetailRespBO.setRespDesc("\u6210\u529f");
        return uccDealSkuDetailRespBO;
    }

    private UccSkuDetailBO dealSkuDetailResult(JSONObject respObj) {
        JSONObject result = respObj.getJSONObject("result");
        UccSkuDetailBO uccSkuDetailBO = new UccSkuDetailBO();
        uccSkuDetailBO.setBrandName(result.get((Object)"brandName") == null ? "empty" : result.getString("brandName"));
        uccSkuDetailBO.setBrandPic(result.get((Object)"brandPic") == null ? "empty" : result.getString("brandPic"));
        if (result.get((Object)"category") != null) {
            JSONArray category = result.getJSONArray("category");
            uccSkuDetailBO.setSkuCate1(result.getJSONArray("category").get(0).toString().replace("\"", "") == "" ? "empty" : result.getJSONArray("category").get(0).toString().replace("\"", ""));
            uccSkuDetailBO.setSkuCate2(result.getJSONArray("category").get(1).toString().replace("\"", "") == "" ? "empty" : result.getJSONArray("category").get(1).toString().replace("\"", ""));
            uccSkuDetailBO.setSkuCate3(result.getJSONArray("category").get(2).toString().replace("\"", "") == "" ? "empty" : result.getJSONArray("category").get(2).toString().replace("\"", ""));
            if (category.size() == 3) {
                uccSkuDetailBO.setSkuCate4(result.getJSONArray("category").get(2).toString().replace("\"", "") == "" ? "empty" : result.getJSONArray("category").get(2).toString().replace("\"", ""));
            } else {
                uccSkuDetailBO.setSkuCate4(result.getJSONArray("category").get(2).toString().replace("\"", "") == "" ? "empty" : result.getJSONArray("category").get(3).toString().replace("\"", ""));
            }
        }
        uccSkuDetailBO.setDeliveryTime(result.get((Object)"deliveryTime") == null ? "empty" : result.getString("deliveryTime"));
        uccSkuDetailBO.setImagePath(result.get((Object)"imagePath") == null ? "empty" : result.getString("imagePath"));
        uccSkuDetailBO.setIntroduction(result.get((Object)"introduction") == null ? "empty" : result.getString("introduction"));
        uccSkuDetailBO.setMfgSku(result.get((Object)"mfgSku") == null ? "empty" : result.getString("mfgSku"));
        uccSkuDetailBO.setMoq(result.get((Object)"moq") == null ? 1 : result.getInteger("moq"));
        uccSkuDetailBO.setName(result.get((Object)"name") == null ? "empty" : result.getString("name"));
        uccSkuDetailBO.setProductArea(result.get((Object)"productArea") == null ? "empty" : result.getString("productArea"));
        uccSkuDetailBO.setSaleUnit(result.get((Object)"saleUnit") == null ? "empty" : result.getString("saleUnit"));
        uccSkuDetailBO.setSku(result.get((Object)"sku") == null ? "empty" : result.getString("sku"));
        uccSkuDetailBO.setState(result.get((Object)"state") == null ? -1 : result.getInteger("state"));
        uccSkuDetailBO.setWareQD(result.get((Object)"wareQD") == null ? "empty" : result.getString("wareQD"));
        uccSkuDetailBO.setWeight(result.get((Object)"weight") == null ? "empty" : result.getString("weight"));
        uccSkuDetailBO.setUpc(result.get((Object)"upc") == null ? "" : result.getString("upc"));
        uccSkuDetailBO.setCategory3(result.getJSONArray("category").get(2).toString());
        if (result.get((Object)"param") != null) {
            JSONArray param = result.getJSONArray("param");
            ArrayList<UccSkuAttrBO> attrlist = new ArrayList<UccSkuAttrBO>();
            for (int i = 0; i < param.size(); ++i) {
                JSONObject jsonObject = param.getJSONObject(i);
                UccSkuAttrBO uccSkuAttrBO = new UccSkuAttrBO();
                uccSkuAttrBO.setSku(result.get((Object)"sku") == null ? "empty" : result.getString("sku"));
                uccSkuAttrBO.setAttrCode(jsonObject.get((Object)"attrCode") == null ? "empty" : jsonObject.getString("attrCode"));
                uccSkuAttrBO.setAttrGroupCode(jsonObject.get((Object)"attrGroupCode") == null ? "empty" : jsonObject.getString("attrGroupCode"));
                uccSkuAttrBO.setAttrGroupName(jsonObject.get((Object)"attrGroupName") == null ? "empty" : jsonObject.getString("attrGroupName"));
                uccSkuAttrBO.setAttrGroupSeq(jsonObject.get((Object)"attrGroupSeq") == null ? "empty" : jsonObject.getString("attrGroupSeq"));
                uccSkuAttrBO.setAttrName(jsonObject.get((Object)"attrName") == null ? "empty" : jsonObject.getString("attrName"));
                uccSkuAttrBO.setAttrSeq(jsonObject.get((Object)"attrSeq") == null ? "empty" : jsonObject.getString("attrSeq"));
                uccSkuAttrBO.setAttrValue(jsonObject.get((Object)"attrValue") == null ? "empty" : jsonObject.getString("attrValue"));
                attrlist.add(uccSkuAttrBO);
            }
            uccSkuDetailBO.setUccSkuAttrBOList(attrlist);
        }
        return uccSkuDetailBO;
    }
}

