/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.imp;

import com.tydic.commodity.utils.DBUtils;
import com.tydic.commodity.utils.SequenceMem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

public class UccImpPropProc
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(UccImpPropProc.class);
    private JdbcTemplate jdbcTemplate;
    private String supplierCode;
    private int channel_count;
    private int channel_id;
    private SequenceMem sequenceMem;

    public UccImpPropProc(JdbcTemplate jdbcTemplate, String supplierCode, int channel_id, int channel_count, SequenceMem sequenceMem) {
        this.jdbcTemplate = jdbcTemplate;
        this.supplierCode = supplierCode;
        this.channel_count = channel_count;
        this.channel_id = channel_id;
        this.sequenceMem = sequenceMem;
    }

    @Override
    public void run() {
        log.info("\u7ebf\u7a0b{}\u5f00\u59cb\u5904\u7406", (Object)this.channel_id);
        Date now = new Date();
        Long aLong = (Long)this.jdbcTemplate.queryForObject("select SUPPLIER_ID from ucc_supplier where SUPPLIER_CODE=?", Long.class, new Object[]{this.supplierCode});
        log.info("\u5904\u7406\u5c5e\u6027\u5f00\u59cb:SUPPLIER_ID:" + aLong + " SUPPLIER_CODE:" + this.supplierCode);
        List maps = this.jdbcTemplate.queryForList("select CATALOG_ID from ucc_ecommerce_import_log where SUPPLIER_CODE=? and mod(id,?)=?", new Object[]{this.supplierCode, this.channel_count, this.channel_id});
        if (!CollectionUtils.isEmpty((Collection)maps)) {
            log.info("\u7ebf\u7a0b:{}\u9700\u8981\u5904\u7406\u7684\u7c7b\u76ee\u6570\u91cf:{}", (Object)this.channel_id, (Object)maps.size());
            for (Map next : maps) {
                String catalogId = next.get("CATALOG_ID").toString();
                log.info("\u5916\u90e8\u7535\u5546\u7c7b\u76ee:" + catalogId);
                boolean runable = this.runable(catalogId, this.supplierCode);
                if (!runable) {
                    log.info("\u8be5\u7c7b\u76ee\u4e0d\u9700\u8981\u5904\u7406:" + catalogId);
                    continue;
                }
                ArrayList<Object[]> defParmList = new ArrayList<Object[]>();
                ArrayList<Object[]> relParmList = new ArrayList<Object[]>();
                ArrayList<Object[]> propValueList = new ArrayList<Object[]>();
                ArrayList<Object[]> skuPropListRel = new ArrayList<Object[]>();
                Long commodityPropGrpId = this.addPropGrp(catalogId, aLong);
                List maps1 = this.jdbcTemplate.queryForList("select sku,ATTR_NAME,ATTR_VALUE from EXTERNAL_SKU_ATTR where SKU in(select SKU from EXTERNAL_SKU_DETAIL where SKU_CATE4=? and SUPPLIER_CODE=?)", new Object[]{catalogId, this.supplierCode});
                if (!CollectionUtils.isEmpty((Collection)maps1)) {
                    for (Map next1 : maps1) {
                        String name = next1.get("attr_name").toString();
                        String sku = next1.get("sku").toString();
                        Integer filterFlag = 1;
                        if ("\u54c1\u724c".equals(name) || "-".equals(name)) {
                            filterFlag = 0;
                        }
                        List maps3 = this.jdbcTemplate.queryForList("select COMMODITY_PROP_DEF_ID from ucc_commodity_prop_def where REMARK=? and PROP_NAME=?", new Object[]{catalogId, name});
                        Long defId = 0L;
                        if (CollectionUtils.isEmpty((Collection)maps3)) {
                            defId = this.sequenceMem.getSeq("SEQ_UCC_COMMODITY_PROP_DEF_ID");
                            Object[] defParm = new Object[]{defId, "PROP_CODE", next1.get("attr_name"), next1.get("attr_name"), 1, 0, 500, 0, filterFlag, 0, 1, 0, 0, "sys", now, catalogId};
                            defParmList.add(defParm);
                        } else {
                            defId = (Long)((Map)maps3.iterator().next()).get("COMMODITY_PROP_DEF_ID");
                        }
                        String propValue = next1.get("ATTR_VALUE").toString();
                        List maps4 = this.jdbcTemplate.queryForList("select PROP_VALUE_LIST_ID from ucc_prop_value_list where remark=? and PROP_VALUE=?", new Object[]{catalogId, propValue});
                        Long propValueListId = 0L;
                        if (CollectionUtils.isEmpty((Collection)maps4)) {
                            Long seqNext = this.sequenceMem.getSeq("SEQ_UCC_PROP_VALUE_LIST_ID");
                            Object[] parm = new Object[]{seqNext, defId, "ATTR_VALUE_CODE", propValue, "sys", new Date(), catalogId};
                            propValueList.add(parm);
                            propValueListId = seqNext;
                        } else {
                            for (Map next2 : maps4) {
                                propValueListId = (Long)next2.get("PROP_VALUE_LIST_ID");
                            }
                        }
                        Object[] skuPropListRelParm = new Object[]{propValueListId, sku, now, catalogId};
                        skuPropListRel.add(skuPropListRelParm);
                        List maps5 = this.jdbcTemplate.queryForList("select 1 from ucc_rel_prop_grp_prop where REMARK=? and COMMODITY_PROP_DEF_ID=?", new Object[]{catalogId, defId});
                        if (!CollectionUtils.isEmpty((Collection)maps5)) continue;
                        Object[] parm = new Object[]{this.sequenceMem.getSeq("SEQ_REL_ID"), defId, commodityPropGrpId, 0, "sys", now, catalogId};
                        relParmList.add(parm);
                    }
                }
                DBUtils.batchUpdateWithPageation(this.jdbcTemplate, "INSERT INTO  ucc_commodity_prop_def(COMMODITY_PROP_DEF_ID, PROP_CODE,PROP_NAME,SHOW_NAME,PROP_TAG,PROP_TYPE,\nPROP_LEN,INPUT_TYPE,FILTER_FLAG,\nREQUIRED_FLAG,MULTI_FLAG,PROPERTY_LINK,SHOW_ORDER,create_oper_id,create_time,remark) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", defParmList);
                DBUtils.batchUpdateWithPageation(this.jdbcTemplate, "INSERT INTO ucc_prop_value_list (PROP_VALUE_LIST_ID, COMMODITY_PROP_DEF_ID,PROP_VALUE_LIST_CODE,PROP_VALUE,create_oper_id,CREATE_TIME,remark) values(?,?,?,?,?,?,?)", propValueList);
                DBUtils.batchUpdateWithPageation(this.jdbcTemplate, "insert into UCC_SKU_PROP_LIST_REL(PROP_VALUE_LIST_ID,SKU,CREATE_TIME,CATALOG_ID) values(?,?,?,?)", skuPropListRel);
                DBUtils.batchUpdateWithPageation(this.jdbcTemplate, "insert into ucc_rel_prop_grp_prop(REL_ID,COMMODITY_PROP_DEF_ID,COMMODITY_PROP_GRP_ID,SHOW_ORDER,CREATE_OPER_ID,CREATE_TIME,REMARK) values (?,?,?,?,?,?,?)", relParmList);
                List maps4 = this.jdbcTemplate.queryForList("select distinct SALE_UNIT from external_sku_detail where SUPPLIER_CODE=? and SKU_CATE4=?", new Object[]{this.supplierCode, catalogId});
                if (!CollectionUtils.isEmpty((Collection)maps4)) {
                    Iterator iterator4 = maps4.iterator();
                    ArrayList<Object[]> parmList = new ArrayList<Object[]>();
                    while (iterator4.hasNext()) {
                        List maps5;
                        Map next4 = (Map)iterator4.next();
                        String saleUnit = next4.get("SALE_UNIT").toString();
                        if (StringUtils.isEmpty((Object)saleUnit) || "empty".equals(saleUnit) || !CollectionUtils.isEmpty((Collection)(maps5 = this.jdbcTemplate.queryForList("select 1 from ucc_commodity_measure where MEASURE_NAME=?", new Object[]{saleUnit})))) continue;
                        Object[] parm = new Object[]{this.sequenceMem.getSeq("SEQ_MEASURE_ID"), saleUnit, 0, "sys", now, 0};
                        parmList.add(parm);
                    }
                    DBUtils.batchUpdateWithPageation(this.jdbcTemplate, "insert into ucc_commodity_measure (measure_id, measure_name, measure_type, create_login_id, create_time, is_delete) values (?,?,?,?,?,?)", parmList);
                }
                this.jdbcTemplate.update("update UCC_ECOMMERCE_IMPORT_LOG set prop_flag=2, update_date=sysdate() where CATALOG_ID=?", new Object[]{catalogId});
            }
        }
    }

    public Long addPropGrp(String catalogId, Long supplierId) {
        Date now = new Date();
        Long commodityPropGrpId = 0L;
        List maps4 = this.jdbcTemplate.queryForList("select  concat('GROUP_CODE',t1.COMMODITY_TYPE_ID) as code,t1.COMMODITY_TYPE_ID,\n       concat(COMMODITY_TYPE_NAME,'\u7ec4') as groupName,t2.CATALOG_ID from ucc_commodity_type t1,UCC_ECOMMERCE_CATALOG t2 where t1.COMMODITY_TYPE_ID = t2.COMMODITY_TYPE_ID and t2.SUPPLIER_ID=? and t2.CATALOG_ID=?", new Object[]{supplierId, catalogId});
        Iterator iterator2 = maps4.iterator();
        ArrayList<Object[]> groupList = new ArrayList<Object[]>();
        while (iterator2.hasNext()) {
            Map next = (Map)iterator2.next();
            Long commodityTypeId = (Long)next.get("COMMODITY_TYPE_ID");
            List maps = this.jdbcTemplate.queryForList("select COMMODITY_PROP_GRP_ID from ucc_commodity_prop_grp where COMMODITY_TYPE_ID=? and CREATE_OPER_ID=?", new Object[]{commodityTypeId, this.supplierCode});
            if (CollectionUtils.isEmpty((Collection)maps)) {
                commodityPropGrpId = this.sequenceMem.getSeq("SEQ_UCC_COMMODITY_PROP_GRP_ID");
                Object[] parm = new Object[]{commodityPropGrpId, next.get("code"), next.get("COMMODITY_TYPE_ID"), next.get("groupName"), 1, 1, this.supplierCode, now, next.get("CATALOG_ID")};
                groupList.add(parm);
                continue;
            }
            for (Map next1 : maps) {
                commodityPropGrpId = (Long)next1.get("COMMODITY_PROP_GRP_ID");
            }
        }
        DBUtils.batchUpdateWithPageation(this.jdbcTemplate, "insert into ucc_commodity_prop_grp(COMMODITY_PROP_GRP_ID,COMMODITY_PROP_GRP_CODE,COMMODITY_TYPE_ID,COMMODITY_PROP_GRP_NAME,COMMODITY_PROP_GRP_TYPE,PROP_GRP_STATUS,CREATE_OPER_ID,CREATE_TIME,REMARK) values(?,?,?,?,?,?,?,?,?)", groupList);
        return commodityPropGrpId;
    }

    public boolean runable(String catalogId, String supplierCode) {
        List maps1 = this.jdbcTemplate.queryForList("select 1 from ucc_ecommerce_catalog where CATALOG_ID=?", new Object[]{catalogId});
        if (CollectionUtils.isEmpty((Collection)maps1)) {
            return false;
        }
        List maps = this.jdbcTemplate.queryForList("select id, prop_flag from UCC_ECOMMERCE_IMPORT_LOG where CATALOG_ID=? and SUPPLIER_CODE=?", new Object[]{catalogId, supplierCode});
        if (!CollectionUtils.isEmpty((Collection)maps)) {
            Map map = (Map)maps.get(0);
            Integer propFlag = (Integer)map.get("prop_flag");
            if (propFlag == 0) {
                this.jdbcTemplate.update("update UCC_ECOMMERCE_IMPORT_LOG set prop_flag=1, update_date=sysdate() where CATALOG_ID=? and SUPPLIER_CODE=?", new Object[]{catalogId, supplierCode});
                return true;
            }
            if (propFlag == 1) {
                log.info("\u9700\u8981\u6e05\u7406\u7684\u7c7b\u76ee:" + catalogId);
                this.jdbcTemplate.update("delete from ucc_commodity_prop_grp where REMARK=?", new Object[]{catalogId});
                this.jdbcTemplate.update("delete from ucc_commodity_prop_def where REMARK=?", new Object[]{catalogId});
                this.jdbcTemplate.update("delete from ucc_prop_value_list where REMARK=?", new Object[]{catalogId});
                this.jdbcTemplate.update("delete from UCC_SKU_PROP_LIST_REL where CATALOG_ID=?", new Object[]{catalogId});
                this.jdbcTemplate.update("delete from ucc_rel_prop_grp_prop where REMARK=?", new Object[]{catalogId});
                return true;
            }
            return false;
        }
        return false;
    }
}

