/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.imp;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tydic.commodity.batchimp.imp.BO.CommodityInfoCheckReqBO;
import com.tydic.commodity.batchimp.imp.InsertDataService;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.utils.SequenceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class UccPutawayApproveProc
implements Runnable {
    private JdbcTemplate jdbcTemplate;
    private String supplierCode;
    private String pageNumber;
    private static final int DEAL_COUNT = 50;
    private static final Logger log = LoggerFactory.getLogger(UccPutawayApproveProc.class);
    private final Long CHANNEL_ID = 1002L;
    private int channel_count;
    private int channel_id;

    public UccPutawayApproveProc(JdbcTemplate jdbcTemplate, String supplierCode, String pageNumber, int channel_id, int channel_count) {
        this.jdbcTemplate = jdbcTemplate;
        this.supplierCode = supplierCode;
        this.pageNumber = pageNumber;
        this.channel_count = channel_count;
        this.channel_id = channel_id;
    }

    @Override
    public void run() {
        Long aLong = (Long)this.jdbcTemplate.queryForObject("select SUPPLIER_ID from ucc_supplier where SUPPLIER_CODE=?", Long.class, new Object[]{this.supplierCode});
        Long shopId = (Long)this.jdbcTemplate.queryForObject("select SUPPLIER_SHOP_ID from ucc_supplier_shop where SUPPLIER_ID=?", Long.class, new Object[]{aLong});
        HttpRequest http = new HttpRequest();
        String url = PropertiesUtil.getProperty("elcCommodityExaminationUrl");
        if (StringUtils.isEmpty((Object)url)) {
            log.error("\u5ba1\u6838\u5730\u5740\u4e3a\u7a7a");
        } else {
            List maps = this.jdbcTemplate.queryForList("select COMMODITY_ID from ucc_commodity where SUPPLIER_SHOP_ID=? and mod(COMMODITY_ID,?)=?", new Object[]{shopId, this.channel_count, this.channel_id});
            ArrayList<Long> skuList = new ArrayList<Long>();
            if (!CollectionUtils.isEmpty((Collection)maps)) {
                for (Map next : maps) {
                    Long sku = (Long)next.get("COMMODITY_ID");
                    skuList.add(sku);
                }
            }
            int dealTimes = (int)Math.ceil((double)skuList.size() / 50.0);
            for (int i = 1; i <= dealTimes; ++i) {
                int startPos = (i - 1) * 50;
                int endPos = startPos + 50;
                if (endPos > skuList.size()) {
                    endPos = skuList.size();
                }
                List longs = skuList.subList(startPos, endPos);
                CommodityInfoCheckReqBO commodityInfoCheckReqBO = new CommodityInfoCheckReqBO();
                Long[] commoditys = new Long[longs.size()];
                for (int j = 0; j < commoditys.length; ++j) {
                    commoditys[j] = (Long)longs.get(j);
                }
                commodityInfoCheckReqBO.setCommodityId(commoditys);
                commodityInfoCheckReqBO.setSupplierId(aLong + "");
                Gson gson = new Gson();
                log.info("gson.toJson(commodityInfoCheckReqBO):" + gson.toJson((Object)commodityInfoCheckReqBO));
                ArrayList<Object[]> channelPutParmList = new ArrayList<Object[]>();
                SequenceUtil sequenceChannelPutId = new SequenceUtil(this.jdbcTemplate, "SEQ_CHNNEL_PUT_ID");
                for (int j = 0; j < commoditys.length; ++j) {
                    channelPutParmList.clear();
                    List maps1 = this.jdbcTemplate.queryForList("select SKU_ID,SUPPLIER_SHOP_ID from ucc_sku where COMMODITY_ID=?", new Object[]{commoditys[j]});
                    if (!CollectionUtils.isEmpty((Collection)maps1)) {
                        for (Map next : maps1) {
                            Object[] channelPutParm = new Object[]{sequenceChannelPutId.getSeqNext(), this.CHANNEL_ID, next.get("SUPPLIER_SHOP_ID"), next.get("SKU_ID"), 2, "sys", new Date(), null, null, null};
                            channelPutParmList.add(channelPutParm);
                        }
                    }
                    this.jdbcTemplate.batchUpdate("insert into UCC_CHANNEL_PUT(id,channel_id, supplier_shop_id, put_obj_id, put_obj_type, create_oper_id, create_time, update_oper_id, update_time, remark) values (?,?,?,?,?,?,?,?,?,?)", channelPutParmList);
                    InsertDataService insertDataService = new InsertDataService(this.jdbcTemplate);
                    if (commoditys[j] == null) continue;
                    insertDataService.insertData(commoditys[j] + "");
                }
                JsonParser parse = new JsonParser();
                String s = http.sendPostJsoneshy(url, gson.toJson((Object)commodityInfoCheckReqBO));
                JsonObject asJsonObject = parse.parse(s).getAsJsonObject();
                String respCode = asJsonObject.get("respCode").getAsString();
                if ("0000".equals(respCode)) {
                    log.info("\u53d1\u9001\u5ba1\u6838\u6210\u529f");
                    continue;
                }
                String respDesc = asJsonObject.get("respDesc").getAsString();
                log.info("\u53d1\u9001\u5ba1\u6838\u5931\u8d25:" + respDesc);
            }
        }
    }
}

