/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.comm;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tydic.commodity.batchimp.initialize.req.processor.comm.bo.ImportPicReqBO;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;

public class CommProc {
    private static final Logger log = LoggerFactory.getLogger(CommProc.class);

    public void importPic(String url, ImportPicReqBO importPicReqBO, JdbcTemplate jdbcTemplate, String supplierCode) {
        HttpRequest http = new HttpRequest();
        Gson gson = new Gson();
        String orgInfo = http.sendPostJsoneshy(url, gson.toJson((Object)importPicReqBO));
        System.out.println(orgInfo);
        JsonParser parser = new JsonParser();
        JsonObject resultObj = parser.parse(orgInfo).getAsJsonObject();
        boolean success = resultObj.get("success").getAsBoolean();
        if (success) {
            if (!resultObj.get("result").getAsJsonArray().isJsonNull()) {
                JsonArray result = resultObj.get("result").getAsJsonArray();
                ArrayList<Object[]> parmList = new ArrayList<Object[]>();
                for (JsonElement jsonElement : result) {
                    JsonObject asJsonObject = jsonElement.getAsJsonObject();
                    String sku = asJsonObject.get("sku").getAsString();
                    JsonArray skuPic = asJsonObject.get("skuPic").getAsJsonArray();
                    for (JsonElement subJsonElement : skuPic) {
                        JsonObject asJsonObject1 = subJsonElement.getAsJsonObject();
                        String path = asJsonObject1.get("path").getAsString();
                        String isPrimary = asJsonObject1.get("isPrimary").getAsString();
                        int orderSort = asJsonObject1.get("orderSort").getAsInt();
                        if (path.indexOf(",") > 0) {
                            String[] split = path.split(",");
                            path = split[0];
                        }
                        Object[] parm = new Object[]{sku, isPrimary, orderSort, path, supplierCode};
                        parmList.add(parm);
                    }
                }
                jdbcTemplate.batchUpdate("insert into EXTERNAL_SKU_PIC(SKU,IS_PRIMARY,ORDER_SORT,PATH,SUPPLIER_CODE) values (?,?,?,?,?)", parmList);
            } else {
                log.info("\u6ca1\u6709\u8fd4\u56de\u56fe\u7247\u4fe1\u606f");
            }
        } else {
            String resultMessage = resultObj.get("resultMessage").getAsString();
            log.info("\u8bf7\u6c42\u5931\u8d25:" + resultMessage);
        }
    }

    public static void addCatalogLog(JdbcTemplate jdbcTemplate, String supplierCode, String catalogId) {
        List maps = jdbcTemplate.queryForList("select 1 from ucc_ecommerce_import_log where CATALOG_ID=? and SUPPLIER_CODE=?", new Object[]{catalogId, supplierCode});
        if (CollectionUtils.isEmpty((Collection)maps)) {
            jdbcTemplate.update("insert into UCC_ECOMMERCE_IMPORT_LOG (CATALOG_ID,run_date,prop_flag,commodity_flag,SUPPLIER_CODE) values (?,sysdate(),?,?,?)", new Object[]{catalogId, 0, 0, supplierCode});
        }
    }
}

