/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.eshy;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tydic.commodity.batchimp.initialize.req.model.ehsy.EshyGetSellPriceReq;
import com.tydic.commodity.batchimp.initialize.resp.model.deli.DeliToken;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class EshyApiGetSellPrice
implements Runnable {
    private String apiuri = "http://sp-test.ehsy.com/mall/getSellPrice";
    private JdbcTemplate jdbcTemplate;
    private DeliToken token;
    private int channel_id;
    private int total;
    private String supplierCode;
    private static final Logger log = LoggerFactory.getLogger(EshyApiGetSellPrice.class);

    public EshyApiGetSellPrice(JdbcTemplate jdbcTemplate, DeliToken token, int channel_id, int total, String supplierCode) {
        this.jdbcTemplate = jdbcTemplate;
        this.token = token;
        this.channel_id = channel_id;
        this.total = total;
        this.supplierCode = supplierCode;
    }

    @Override
    public void run() {
        List rows = this.jdbcTemplate.queryForList("select a.sku from EXTERNAL_SKU_SET a where mod(a.id,?) = ?  and sku not in(select sku from EXTERNAL_PRICE where SUPPLIER_CODE=?) and SUPPLIER_CODE=?", new Object[]{this.total, this.channel_id, this.supplierCode, this.supplierCode});
        Iterator it = rows.iterator();
        HttpRequest http = new HttpRequest();
        while (it.hasNext()) {
            Map map = (Map)it.next();
            String sku = map.get("sku").toString();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timestamp = df.format(new Date());
            ArrayList<String> skulist = new ArrayList<String>();
            skulist.add(sku);
            EshyGetSellPriceReq eshyGetSellPriceReq = new EshyGetSellPriceReq();
            eshyGetSellPriceReq.setSku(skulist);
            eshyGetSellPriceReq.setToken(this.token.getAccess_token());
            eshyGetSellPriceReq.setTimestamp(timestamp);
            String org_info = "";
            try {
                Gson gson = new Gson();
                log.info("org_req = " + gson.toJson((Object)eshyGetSellPriceReq));
                org_info = http.sendPostJsoneshy(this.apiuri, gson.toJson((Object)eshyGetSellPriceReq));
                log.info("org_info = " + org_info);
                JsonParser parser = new JsonParser();
                if (parser.parse(org_info).getAsJsonObject().get("result").getAsJsonArray().get(0).getAsJsonObject().isJsonNull()) continue;
                JsonObject json_result = parser.parse(org_info).getAsJsonObject().get("result").getAsJsonArray().get(0).getAsJsonObject();
                this.jdbcTemplate.update("INSERT INTO EXTERNAL_PRICE (sku,EXTERNAL_PRICE,CON_PRICE,SUPPLIER_CODE) VALUES (?,?,?,?)", new Object[]{sku, json_result.get("ecPrice").getAsDouble(), json_result.get("price").getAsDouble(), this.supplierCode});
                log.info("sku + attr in db = " + eshyGetSellPriceReq.getSku());
            }
            catch (Exception e) {
                log.info(e.toString() + "error_sku:" + sku);
                log.info(e.toString() + " error_json: " + org_info);
                System.out.println(e.toString());
            }
        }
    }
}

