/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.grainger;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tydic.commodity.batchimp.initialize.req.model.grg.GrgGetPageNumReq;
import com.tydic.commodity.batchimp.initialize.resp.model.deli.DeliPageNum;
import com.tydic.commodity.batchimp.initialize.resp.model.deli.DeliToken;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class GrgApiGetPageNumProc {
    private String token;
    private String apiuri;
    private JdbcTemplate jdbcTemplate;
    private String clientId;
    private static final Logger log = LoggerFactory.getLogger(GrgApiGetPageNumProc.class);
    private String supplierCode;

    public GrgApiGetPageNumProc(JdbcTemplate jdbcTemplate, DeliToken token, String supplierCode) {
        this.token = token.getAccess_token();
        this.apiuri = "http://222.68.255.182/getPageNum";
        this.jdbcTemplate = jdbcTemplate;
        this.clientId = token.getClientId();
        this.supplierCode = supplierCode;
    }

    public void run() throws Exception {
        HttpRequest http = new HttpRequest();
        log.info(this.apiuri);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = df.format(new Date());
        GrgGetPageNumReq grgGetPageNumReq = new GrgGetPageNumReq();
        grgGetPageNumReq.setToken(this.token);
        grgGetPageNumReq.setAppkey("85df644d5922089056d179fb749d52ca");
        grgGetPageNumReq.setTimestamp(timestamp);
        grgGetPageNumReq.setSerialnumber("123");
        Gson gson = new Gson();
        log.info(gson.toJson((Object)grgGetPageNumReq));
        String org_json = http.sendPostJsoneshy(this.apiuri, gson.toJson((Object)grgGetPageNumReq));
        log.info(org_json);
        JsonParser parse = new JsonParser();
        JsonObject asJsonObject = parse.parse(org_json).getAsJsonObject();
        boolean success = asJsonObject.get("success").getAsBoolean();
        if (!success) {
            log.info("\u83b7\u53d6\u5546\u54c1\u6c60\u5931\u8d25:" + asJsonObject.get("resultMessage").getAsString());
        } else {
            ArrayList<Object[]> skupoollist = new ArrayList<Object[]>();
            JsonArray jsonArray = asJsonObject.get("result").getAsJsonArray();
            for (JsonElement elem : jsonArray) {
                DeliPageNum sp = new DeliPageNum();
                sp.setName(elem.getAsJsonObject().get("name").getAsString());
                sp.setPage_num(elem.getAsJsonObject().get("page_num").getAsString());
                Object[] obj = new Object[]{sp.getName(), sp.getPage_num(), this.supplierCode};
                skupoollist.add(obj);
            }
            this.jdbcTemplate.batchUpdate("INSERT INTO UCC_COMMODITY_PAGE_NUM(name, page_num,SUPPLIER_CODE) VALUES (?,?,?)", skupoollist);
            this.jdbcTemplate.update("UPDATE UCC_COMMODITY_PAGE_NUM SET curr_page_no = 0,flag = 0,total_page_count = 1 where SUPPLIER_CODE = ?", new Object[]{this.supplierCode});
        }
    }
}

