/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.jd;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tydic.commodity.batchimp.initialize.resp.model.jd.JDSkuCate;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class JDApiGetCategoryProc {
    private String token;
    private String apiuri;
    private JdbcTemplate jdbcTemplate;
    private static final Logger log = LoggerFactory.getLogger(JDApiGetCategoryProc.class);

    public JDApiGetCategoryProc(String token, JdbcTemplate jdbcTemplate) {
        this.token = token;
        this.apiuri = "https://bizapi.jd.com/api/product/getCategorys";
        this.jdbcTemplate = jdbcTemplate;
    }

    public void run() throws Exception {
        this.jdbcTemplate.execute("delete from jd_cate");
        log.info(this.apiuri + this.token);
        String org_json0 = HttpRequest.sendPost(this.apiuri, "token=" + this.token + "&pageNo=1&pageSize=5000&catClass=" + 0);
        String org_json1 = HttpRequest.sendPost(this.apiuri, "token=" + this.token + "&pageNo=1&pageSize=5000&catClass=" + 1);
        String org_json2 = HttpRequest.sendPost(this.apiuri, "token=" + this.token + "&pageNo=1&pageSize=5000&catClass=" + 2);
        String org_json22 = HttpRequest.sendPost(this.apiuri, "token=" + this.token + "&pageNo=2&pageSize=5000&catClass=" + 2);
        log.info("org_json0 = " + org_json0);
        log.info("org_json1 = " + org_json1);
        log.info("org_json2 = " + org_json2);
        log.info("org_json22 = " + org_json22);
        ArrayList<String> json_list = new ArrayList<String>();
        json_list.add(org_json0);
        json_list.add(org_json1);
        json_list.add(org_json2);
        json_list.add(org_json22);
        Iterator iterator = json_list.iterator();
        while (iterator.hasNext()) {
            JsonParser parse = new JsonParser();
            String json = (String)iterator.next();
            if (parse.parse(json).getAsJsonObject().get("result").isJsonNull()) continue;
            JsonArray jsonArr = parse.parse(json).getAsJsonObject().get("result").getAsJsonObject().get("categorys").getAsJsonArray();
            ArrayList<Object[]> skucatelist = new ArrayList<Object[]>();
            for (int i = 0; i < jsonArr.size(); ++i) {
                JsonObject subObject = jsonArr.get(i).getAsJsonObject();
                JDSkuCate jc = new JDSkuCate();
                jc.setCatClass(subObject.get("catClass").getAsInt());
                jc.setCatId(subObject.get("catId").getAsInt());
                jc.setName(subObject.get("name").getAsString());
                jc.setParentId(subObject.get("parentId").getAsInt());
                jc.setState(subObject.get("state").getAsInt());
                Object[] obj = new Object[]{jc.getCatClass(), jc.getCatId(), jc.getName(), jc.getParentId(), jc.getState()};
                skucatelist.add(obj);
            }
            this.jdbcTemplate.batchUpdate("INSERT INTO jd_cate(catClass,catId,name,parentId,state) VALUES (?,?,?,?,?)", skucatelist);
        }
    }
}

