/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.jd;

import com.google.gson.JsonParser;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class JDApiPriceProc
implements Runnable {
    private String token;
    private String apiuri1;
    private String apiuri2;
    private String apiuri3;
    private JdbcTemplate jdbcTemplate;
    private int channel_id;
    private int channel_count;
    private static final Logger log = LoggerFactory.getLogger(JDApiPriceProc.class);
    private String supplierCode;

    public JDApiPriceProc(String token, JdbcTemplate jdbcTemplate, int channel_id, int channel_count, String supplierCode) {
        this.token = token;
        this.apiuri1 = "https://bizapi.jd.com/api/price/getJdPrice";
        this.apiuri2 = "https://bizapi.jd.com/api/price/getPrice";
        this.apiuri3 = "https://bizapi.jd.com/api/price/getSellPrice";
        this.jdbcTemplate = jdbcTemplate;
        this.channel_id = channel_id;
        this.channel_count = channel_count;
        this.supplierCode = supplierCode;
    }

    @Override
    public void run() {
        log.info("channel_id = [" + this.channel_id + "] start");
        List rows = this.jdbcTemplate.queryForList("select page_num,sku from EXTERNAL_SKU_SET where mod(sku,?) = ? and SUPPLIER_CODE=? limit 10000", new Object[]{this.channel_count, this.channel_id, this.supplierCode});
        ArrayList<Object[]> sku_detail_list_obj = new ArrayList<Object[]>();
        JsonParser parse = new JsonParser();
        String org_json1 = null;
        String org_json2 = null;
        String org_json3 = null;
        int batch_count = 0;
        for (Map map : rows) {
            long sku = Long.parseLong(map.get("sku").toString());
            try {
                org_json1 = HttpRequest.sendPost(this.apiuri1, "token=" + this.token + "&sku=" + sku);
                org_json2 = HttpRequest.sendPost(this.apiuri2, "token=" + this.token + "&sku=" + sku);
                org_json3 = HttpRequest.sendPost(this.apiuri3, "token=" + this.token + "&sku=" + sku);
                log.info("JDPRICE = " + org_json1);
                log.info("CONPRICE = " + org_json2);
                log.info("SELLPRICE = " + org_json3);
                float jdprice = -1.0f;
                float conprice = -1.0f;
                float sellprice = -1.0f;
                if (org_json1.indexOf("html") == -1 && parse.parse(org_json1).getAsJsonObject().get("result") != null && parse.parse(org_json1).getAsJsonObject().get("result").getAsJsonArray().size() > 0) {
                    jdprice = parse.parse(org_json1).getAsJsonObject().get("result").getAsJsonArray().get(0).getAsJsonObject().get("jdPrice").getAsFloat();
                }
                if (org_json2.indexOf("html") == -1 && parse.parse(org_json2).getAsJsonObject().get("result") != null && parse.parse(org_json2).getAsJsonObject().get("result").getAsJsonArray().size() > 0) {
                    conprice = parse.parse(org_json2).getAsJsonObject().get("result").getAsJsonArray().get(0).getAsJsonObject().get("price").getAsFloat();
                }
                if (org_json3.indexOf("html") == -1 && parse.parse(org_json3).getAsJsonObject().get("result") != null && parse.parse(org_json3).getAsJsonObject().get("result").getAsJsonArray().size() > 0) {
                    sellprice = parse.parse(org_json3).getAsJsonObject().get("result").getAsJsonArray().get(0).getAsJsonObject().get("price").getAsFloat();
                }
                Object[] obj = new Object[]{sku, Float.valueOf(jdprice), Float.valueOf(conprice), Float.valueOf(sellprice), this.supplierCode};
                sku_detail_list_obj.add(obj);
                if (batch_count == 500) {
                    this.jdbcTemplate.batchUpdate("INSERT INTO EXTERNAL_PRICE (sku,EXTERNAL_PRICE,CON_PRICE,SELL_PRICE,SUPPLIER_CODE) VALUES (?,?,?,?,?)", sku_detail_list_obj);
                    log.info("batch commit 500 :" + sku_detail_list_obj.size());
                    sku_detail_list_obj.clear();
                    batch_count = 0;
                }
                ++batch_count;
            }
            catch (Exception e) {
                log.info(e.toString() + "error_sku:" + sku);
                log.info(e.toString() + " error_json: " + org_json1);
                log.info(e.toString() + " error_json: " + org_json1);
                log.info(e.toString() + " error_json: " + org_json1);
            }
        }
        this.jdbcTemplate.batchUpdate("INSERT INTO EXTERNAL_PRICE (sku,EXTERNAL_PRICE,CON_PRICE,SELL_PRICE,SUPPLIER_CODE) VALUES (?,?,?,?,?)", sku_detail_list_obj);
        log.info("batch commit rest :" + sku_detail_list_obj.size());
        sku_detail_list_obj.clear();
        log.info("channel_id = [" + this.channel_id + "] end");
    }
}

