/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.jd;

import com.google.common.base.Splitter;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tydic.commodity.batchimp.initialize.req.processor.comm.CommProc;
import com.tydic.commodity.batchimp.initialize.resp.model.jd.JDSkuDetail;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class JDApiSkuDetailProc
implements Runnable {
    private String token;
    private String apiuri;
    private JdbcTemplate jdbcTemplate;
    private int channel_id;
    private int channel_count;
    private static final Logger log = LoggerFactory.getLogger(JDApiSkuDetailProc.class);
    private String supplierCode;
    private String imagePagtPrefix = "http://img13.360buyimg.com/n0/";

    public JDApiSkuDetailProc(String token, JdbcTemplate jdbcTemplate, int channel_id, int channel_count, String supplierCode) {
        this.token = token;
        this.apiuri = "https://bizapi.jd.com/api/product/getDetail";
        this.jdbcTemplate = jdbcTemplate;
        this.channel_id = channel_id;
        this.channel_count = channel_count;
        this.supplierCode = supplierCode;
    }

    @Override
    public void run() {
        log.info("channel_id = [" + this.channel_id + "] start");
        log.info(this.apiuri + this.token);
        List rows = this.jdbcTemplate.queryForList("select page_num,sku from EXTERNAL_SKU_SET where mod(sku,?) = ? and sku not in (select sku from EXTERNAL_SKU_DETAIL where SUPPLIER_CODE=?) and SUPPLIER_CODE=?", new Object[]{this.channel_count, this.channel_id, this.supplierCode, this.supplierCode});
        ArrayList<Object[]> sku_detail_list_obj = new ArrayList<Object[]>();
        ArrayList<JDSkuDetail> sku_detail_list = new ArrayList<JDSkuDetail>();
        JsonParser parse = new JsonParser();
        String org_json = null;
        int batch_count = 0;
        for (Map map : rows) {
            long sku = Long.parseLong(map.get("sku").toString());
            try {
                org_json = HttpRequest.sendPost(this.apiuri, "token=" + this.token + "&sku=" + sku);
                if (!parse.parse(org_json).getAsJsonObject().get("result").getAsJsonObject().isJsonNull()) {
                    JsonObject json_main = parse.parse(org_json).getAsJsonObject().get("result").getAsJsonObject();
                    JDSkuDetail jdskudetail = new JDSkuDetail();
                    jdskudetail.setSaleUnit(json_main.get("saleUnit").isJsonNull() ? "empty" : json_main.get("saleUnit").getAsString());
                    jdskudetail.setWeight(json_main.get("weight").isJsonNull() ? "empty" : json_main.get("weight").getAsString());
                    jdskudetail.setProductArea(json_main.get("productArea").isJsonNull() ? "empty" : json_main.get("productArea").getAsString());
                    jdskudetail.setWareQD(json_main.get("wareQD").isJsonNull() ? "empty" : json_main.get("wareQD").getAsString());
                    jdskudetail.setImagePath(json_main.get("imagePath").isJsonNull() ? "empty" : json_main.get("imagePath").getAsString());
                    jdskudetail.setParam(json_main.get("param").isJsonNull() ? "empty" : json_main.get("param").getAsString());
                    jdskudetail.setState(json_main.get("state").isJsonNull() ? -1 : json_main.get("state").getAsInt());
                    jdskudetail.setSku(json_main.get("sku").isJsonNull() ? -1L : json_main.get("sku").getAsLong());
                    jdskudetail.setBrandName(json_main.get("brandName").isJsonNull() ? "empty" : json_main.get("brandName").getAsString());
                    jdskudetail.setUpc(json_main.get("upc").isJsonNull() ? "" : json_main.get("upc").getAsString());
                    jdskudetail.setName(json_main.get("name").isJsonNull() ? "empty" : json_main.get("name").getAsString());
                    jdskudetail.setIntroduction(json_main.get("introduction").isJsonNull() ? "empty" : json_main.get("introduction").getAsString());
                    jdskudetail.setSku_cate1(json_main.get("category").isJsonNull() ? -1 : Integer.parseInt(json_main.get("category").getAsString().split(";")[0]));
                    jdskudetail.setSku_cate2(json_main.get("category").isJsonNull() ? -1 : Integer.parseInt(json_main.get("category").getAsString().split(";")[1]));
                    jdskudetail.setSku_cate3(json_main.get("category").isJsonNull() ? -1 : Integer.parseInt(json_main.get("category").getAsString().split(";")[2]));
                    String imagePath = jdskudetail.getImagePath();
                    if (!"empty".equals(imagePath)) {
                        imagePath = this.imagePagtPrefix + imagePath;
                    }
                    Object[] obj = new Object[]{jdskudetail.getSaleUnit(), jdskudetail.getWeight(), jdskudetail.getProductArea(), jdskudetail.getWareQD(), imagePath, null, jdskudetail.getParam(), jdskudetail.getState(), null, jdskudetail.getBrandName(), jdskudetail.getSku(), null, jdskudetail.getUpc(), jdskudetail.getName(), null, jdskudetail.getIntroduction(), jdskudetail.getSku_cate1(), jdskudetail.getSku_cate2(), jdskudetail.getSku_cate3(), jdskudetail.getSku_cate3(), this.supplierCode};
                    CommProc.addCatalogLog(this.jdbcTemplate, this.supplierCode, jdskudetail.getSku_cate3() + "");
                    sku_detail_list_obj.add(obj);
                    sku_detail_list.add(jdskudetail);
                    log.info("GET jdskudetail:" + jdskudetail.getSku() + "");
                    log.info("GET jdskudetail return:" + org_json);
                } else {
                    log.info("channel_id = [" + this.channel_id + "] sku = " + sku + " ERROR JSON :" + org_json);
                }
                if (batch_count == 500) {
                    this.jdbcTemplate.batchUpdate("INSERT INTO EXTERNAL_SKU_DETAIL (SALE_UNIT,weight,PRODUCT_AREA,WARE_QD,IMAGE_PATH,BRAND_PIC,param,state,moq,BRAND_NAME,sku,MFG_SKU,upc,name,DELIVERY_TIME,introduction,sku_cate1,sku_cate2,sku_cate3,sku_cate4,SUPPLIER_CODE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", sku_detail_list_obj);
                    log.info("batch commit 500 :" + sku_detail_list_obj.size());
                    sku_detail_list_obj.clear();
                    batch_count = 0;
                }
                ++batch_count;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info(e.toString() + "error_sku:" + sku);
                log.info(e.toString() + " error_json: " + org_json);
                System.out.println(e.toString());
            }
        }
        this.jdbcTemplate.batchUpdate("INSERT INTO EXTERNAL_SKU_DETAIL (SALE_UNIT,weight,PRODUCT_AREA,WARE_QD,IMAGE_PATH,BRAND_PIC,param,state,moq,BRAND_NAME,sku,MFG_SKU,upc,name,DELIVERY_TIME,introduction,sku_cate1,sku_cate2,sku_cate3,sku_cate4,SUPPLIER_CODE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", sku_detail_list_obj);
        log.info("batch commit rest :" + sku_detail_list_obj.size());
        sku_detail_list_obj.clear();
        log.info("channel_id = [" + this.channel_id + "] end");
        this.dealAttr();
    }

    public void dealAttr() {
        List rows = this.jdbcTemplate.queryForList("select sku,sku_cate1,sku_cate2,sku_cate3,param from EXTERNAL_SKU_DETAIL where mod(sku,?) = ?  and sku not in (select sku from EXTERNAL_SKU_ATTR where SUPPLIER_CODE=?) and SUPPLIER_CODE=?", new Object[]{this.channel_count, this.channel_id, this.supplierCode, this.supplierCode});
        for (Map map : rows) {
            try {
                ArrayList<Object[]> sku_detail_attr_obj = new ArrayList<Object[]>();
                List attr_cluster_level_list = Splitter.on((String)"<th class=\"tdTitle\" colspan=\"2\">").trimResults().omitEmptyStrings().splitToList((CharSequence)map.get("param").toString());
                log.info("SKU:" + map.get("sku").toString());
                for (int i = 1; i < attr_cluster_level_list.size(); ++i) {
                    String attr_cluster = ((String)attr_cluster_level_list.get(i)).split("</th>")[0];
                    for (int j = 1; j < ((String)attr_cluster_level_list.get(i)).split("</th>")[1].split("<td class=\"tdTitle\">").length; ++j) {
                        String attr_string = ((String)attr_cluster_level_list.get(i)).split("</th>")[1].split("<td class=\"tdTitle\">")[j];
                        String attr_name = attr_string.split("</td>")[0].replaceAll("<td>", "").replaceAll("</tr>", "").replaceAll("</table>", "").replaceAll("<tr>", "").replaceAll("<table>", "");
                        String attr_value = attr_string.split("</td>")[1].replaceAll("<td>", "").replaceAll("</tr>", "").replaceAll("</table>", "").replaceAll("<tr>", "").replaceAll("<table>", "");
                        Object[] obj = new Object[]{Long.parseLong(map.get("sku").toString()), "empty", "empty", "empty", "empty", attr_name, 1, attr_value, this.supplierCode};
                        sku_detail_attr_obj.add(obj);
                    }
                }
                this.jdbcTemplate.batchUpdate("INSERT INTO EXTERNAL_SKU_ATTR (sku,ATTR_CODE,ATTR_GROUP_CODE,ATTR_GROUP_NAME,ATTR_GROUP_SEQ,ATTR_NAME,ATTR_SEQ,ATTR_VALUE,SUPPLIER_CODE) VALUES (?,?,?,?,?,?,?,?,?)", sku_detail_attr_obj);
                log.info("SKU ATTR END ");
            }
            catch (Exception e) {
                log.info(e.toString() + " error_sku:" + map.get("sku").toString());
                log.info(e.toString() + " error_json: " + map.get("param").toString());
                System.out.println(e.toString());
            }
        }
    }
}

