/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.linkedmall;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.commodity.batchimp.initialize.utils.DataPool;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class LinkedMallEditCommodityTask
implements Runnable {
    private int channel_count;
    private int channel_id;
    private JdbcTemplate jdbcTemplate;

    public void setChannel_count(int channel_count) {
        this.channel_count = channel_count;
    }

    public void setChannel_id(int channel_id) {
        this.channel_id = channel_id;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public void run() {
        Long supplierShopId = 10025L;
        List tempCommodityList = this.jdbcTemplate.queryForList("select ext_sku_id,sku_title,sku_main_pic,sku_price,sku_detail,can_sale from temp_commdity_20191013 where mod(id,?)=?", new Object[]{this.channel_count, this.channel_id});
        int counti = 0;
        if (!CollectionUtils.isEmpty((Collection)tempCommodityList)) {
            for (Map tempCommodityParm : tempCommodityList) {
                Long commodityId;
                ++counti;
                String extItemId = this.object2String(tempCommodityParm.get("ext_sku_id"));
                String tempCommodityTitle = this.object2String(tempCommodityParm.get("sku_title"));
                String tempCommodityMainPic = this.object2String(tempCommodityParm.get("sku_main_pic"));
                String tempCommodityCanSale = this.object2String(tempCommodityParm.get("can_sale"));
                String tempCommodityDetail = this.object2String(tempCommodityParm.get("sku_detail"));
                String tempCommoditPrice = this.object2String(tempCommodityParm.get("sku_price"));
                try {
                    commodityId = (Long)this.jdbcTemplate.queryForObject("select COMMODITY_ID from UCC_COMMODITY where SUPPLIER_SHOP_ID=? and EXT_SKU_ID=? ", Long.class, new Object[]{supplierShopId, extItemId});
                }
                catch (Exception e) {
                    System.err.println("\u6ca1\u6709\u627e\u5230\u5546\u54c1:" + extItemId);
                    continue;
                }
                if (commodityId == null) continue;
                this.dealCommodity(supplierShopId, tempCommodityTitle, tempCommodityCanSale, tempCommodityDetail, commodityId);
                this.dealMainPic(tempCommodityMainPic, supplierShopId, commodityId);
                this.dealSkuStatus(tempCommodityCanSale, supplierShopId, commodityId);
                this.dealSkuPrice(supplierShopId, extItemId, tempCommoditPrice, commodityId);
            }
            System.err.println("\u7ebf\u7a0b:" + this.channel_id + "\u7ed3\u675f,\u5904\u7406\u5546\u54c1\u6570\u91cf:" + counti);
        }
    }

    private void dealSkuPrice(Long supplierShopId, String extItemId, String tempCommoditPrice, Long commodityId) {
        List tempSkuList = this.jdbcTemplate.queryForList("select item_id, sku_id, sku_pic, sku_title, sku_prop, sku_price, sku_sale_price from temp_sku_20191013 where item_id=?", new Object[]{extItemId});
        if (!CollectionUtils.isEmpty((Collection)tempSkuList)) {
            for (Map skuParm : tempSkuList) {
                Long aLong;
                BigDecimal bigDecimal;
                String sku_price = this.object2String(skuParm.get("sku_price"));
                String salePrice = this.object2String(skuParm.get("sku_sale_price"));
                String extSkuId = this.object2String(skuParm.get("sku_id"));
                if (extSkuId != null && "-1".equals(extSkuId)) {
                    extSkuId = extItemId;
                }
                Long skuId = 0L;
                try {
                    skuId = (Long)this.jdbcTemplate.queryForObject("select sku_id from UCC_SKU where SUPPLIER_SHOP_ID=? and COMMODITY_ID=? and EXT_SKU_ID=?", Long.class, new Object[]{supplierShopId, commodityId, extSkuId});
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("\u5f02\u5e38\u7684\u5355\u54c1:extSkuId:" + extSkuId + " commodity_id:" + commodityId);
                    continue;
                }
                if (skuId == 0L) continue;
                StringBuilder priceSb = new StringBuilder("update UCC_SKU_PRICE set ");
                ArrayList<Long> priceParm = new ArrayList<Long>();
                if (!StringUtils.isEmpty((Object)tempCommoditPrice)) {
                    priceSb.append(" MARKET_PRICE=?,");
                    try {
                        bigDecimal = MoneyUtils.Double2BigDecimal((Double)Double.parseDouble(tempCommoditPrice));
                        aLong = MoneyUtils.BigDecimal2Long((BigDecimal)bigDecimal);
                        priceParm.add(aLong);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!StringUtils.isEmpty((Object)sku_price)) {
                    priceSb.append(" AGREEMENT_PRICE=?,");
                    try {
                        bigDecimal = MoneyUtils.Double2BigDecimal((Double)Double.parseDouble(sku_price));
                        aLong = MoneyUtils.BigDecimal2Long((BigDecimal)bigDecimal);
                        priceParm.add(aLong);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (salePrice != null) {
                    priceSb.append(" SALE_PRICE=?,");
                    try {
                        bigDecimal = MoneyUtils.Double2BigDecimal((Double)Double.parseDouble(salePrice));
                        aLong = MoneyUtils.BigDecimal2Long((BigDecimal)bigDecimal);
                        priceParm.add(aLong);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                String substringPrice = "";
                if (priceSb.lastIndexOf(",") <= 0) continue;
                substringPrice = priceSb.substring(0, priceSb.lastIndexOf(","));
                substringPrice = substringPrice + " where SKU_ID=? and SUPPLIER_SHOP_ID=?";
                priceParm.add(skuId);
                priceParm.add(supplierShopId);
                Object[] objects = priceParm.toArray();
                System.err.println(substringPrice);
                System.err.println(Arrays.toString(objects));
                this.jdbcTemplate.update(substringPrice, objects);
            }
        }
    }

    private void dealSkuStatus(String tempCommodityCanSale, Long supplierShopId, Long commodityId) {
        if (!StringUtils.isEmpty((Object)tempCommodityCanSale)) {
            Integer skuStatus = 0;
            if ("\u5df2\u4e0b\u67b6".equals(tempCommodityCanSale)) {
                skuStatus = 7;
                this.jdbcTemplate.update("update ucc_sku set SKU_STATUS=? where COMMODITY_ID=? and SUPPLIER_SHOP_ID=?", new Object[]{skuStatus, commodityId, supplierShopId});
            }
        }
    }

    private void dealMainPic(String tempCommodityMainPic, Long supplierShopId, Long commodityId) {
        if (!StringUtils.isEmpty((Object)tempCommodityMainPic)) {
            if (!tempCommodityMainPic.startsWith("https:")) {
                tempCommodityMainPic = "https:" + tempCommodityMainPic;
            }
            this.jdbcTemplate.update("update UCC_COMMODITY_PIC set COMMODITY_PIC_URL=? where SUPPLIER_SHOP_ID=? and  COMMODITY_ID=? and COMMODITY_PIC_TYPE=1", new Object[]{tempCommodityMainPic, supplierShopId, commodityId});
        }
    }

    private void dealCommodity(Long supplierShopId, String tempCommodityTitle, String tempCommodityCanSale, String tempCommodityDetail, Long commodityId) {
        StringBuilder sb = new StringBuilder("update UCC_COMMODITY t1 set");
        ArrayList<Object> parm = new ArrayList<Object>();
        if (!StringUtils.isEmpty((Object)tempCommodityTitle)) {
            sb.append(" COMMODITY_NAME=?,");
            parm.add(tempCommodityTitle);
        }
        if (!StringUtils.isEmpty((Object)tempCommodityDetail)) {
            sb.append(" COMMODITY_PHONE_DETAIL_CHAR=?,");
            parm.add(tempCommodityDetail);
        }
        String substring = "";
        if (sb.lastIndexOf(",") > 0) {
            substring = sb.substring(0, sb.lastIndexOf(","));
            substring = substring + " where SUPPLIER_SHOP_ID=? and COMMODITY_ID=?";
            parm.add(supplierShopId);
            parm.add(commodityId);
            Object[] objects = parm.toArray();
            System.err.println(substring);
            System.err.println(Arrays.toString(objects));
            this.jdbcTemplate.update(substring, objects);
        }
    }

    public static Long round(Object price) {
        if (price != null) {
            Long ret = 0L;
            try {
                double parm = Double.parseDouble(price + "");
                if (parm < 1.0) {
                    BigDecimal parmBig = new BigDecimal(parm).setScale(2, 5);
                    ret = MoneyUtils.BigDecimal2Long((BigDecimal)parmBig);
                } else {
                    DecimalFormat df = new DecimalFormat("#.00");
                    String result = df.format(parm);
                    String lastPos = result.substring(result.indexOf(".") + 2, result.indexOf(".") + 3);
                    int lastInt = Integer.parseInt(lastPos);
                    double offsetDouble = 0.1 - Double.parseDouble("0.0" + lastPos);
                    double retVal = 0.0;
                    retVal = lastInt >= 5 ? parm + offsetDouble : parm - Double.parseDouble("0.0" + lastPos);
                    BigDecimal bigDecimal = new BigDecimal(retVal).setScale(2, 5);
                    ret = MoneyUtils.BigDecimal2Long((BigDecimal)bigDecimal);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ret;
        }
        return null;
    }

    private String object2String(Object parm) {
        if (parm == null) {
            return null;
        }
        return parm.toString();
    }

    public static void main(String[] args) {
        JdbcTemplate jdbcTemplate = DataPool.getJdbcTemplatePre();
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-call-runner-%d").build();
        ThreadPoolExecutor fixedThreadPool = new ThreadPoolExecutor(50, 50, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        System.out.println("\u6279\u91cf\u4fee\u6539\u5546\u54c1\u6570\u636e\u5f00\u59cb\uff01");
        long start = System.currentTimeMillis();
        int total = 20;
        for (int i = 0; i < total; ++i) {
            LinkedMallEditCommodityTask linkedMallEditCommodityTask = new LinkedMallEditCommodityTask();
            linkedMallEditCommodityTask.setChannel_id(i);
            linkedMallEditCommodityTask.setJdbcTemplate(jdbcTemplate);
            linkedMallEditCommodityTask.setChannel_count(total);
            fixedThreadPool.submit(linkedMallEditCommodityTask);
        }
        fixedThreadPool.shutdown();
        while (!fixedThreadPool.isTerminated()) {
        }
        System.out.println("\u6279\u91cf\u4fee\u6539\u5546\u54c1\u6570\u636e\u7ed3\u675f\uff01");
        long end = System.currentTimeMillis();
        long l = (end - start) / 1000L;
        System.out.println("\u5546\u54c1\u63a8\u9001\u7528\u65f6:" + l);
    }
}

