/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.linkedmall;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.tydic.commodity.batchimp.initialize.utils.DataPool;
import com.tydic.commodity.utils.HttpTool;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;

public class LinkedMallUpdateCommodityInfoTask
implements Runnable {
    private int channel_count;
    private int channel_id;
    private JdbcTemplate jdbcTemplate;

    public void setChannel_count(int channel_count) {
        this.channel_count = channel_count;
    }

    public void setChannel_id(int channel_id) {
        this.channel_id = channel_id;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public void run() {
        List mapList = this.jdbcTemplate.queryForList("SELECT COMMODITY_ID, EXT_SKU_ID, SUPPLIER_SHOP_ID FROM ucc_commodity WHERE COMMODITY_STATUS <> 4 AND mod(COMMODITY_ID,?)=?", new Object[]{this.channel_count, this.channel_id});
        if (!CollectionUtils.isEmpty((Collection)mapList)) {
            for (Map map : mapList) {
                LinkedHashMap params = new LinkedHashMap();
                params.put("supplierShopId", map.get("SUPPLIER_SHOP_ID"));
                params.put("commodityId", map.get("COMMODITY_ID"));
                params.put("extItemId", map.get("EXT_SKU_ID"));
                Gson gson = new Gson();
                String respJson = HttpTool.sendPostJson("http://127.0.0.1:9050/ucc/noauth/ability/imp/updateSkuInfo", gson.toJson(params));
                System.out.println(respJson);
            }
        }
    }

    public static void main(String[] args) {
        JdbcTemplate jdbcTemplate = DataPool.getJdbcTemplatePre();
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-call-runner-%d").build();
        ThreadPoolExecutor fixedThreadPool = new ThreadPoolExecutor(50, 50, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        System.out.println("\u6279\u91cf\u66f4\u65b0\u5546\u54c1\u5c5e\u6027\u5f00\u59cb\uff01");
        long start = System.currentTimeMillis();
        int total = 1;
        for (int i = 0; i < total; ++i) {
            LinkedMallUpdateCommodityInfoTask updateCommodityPropTask = new LinkedMallUpdateCommodityInfoTask();
            updateCommodityPropTask.setChannel_id(i);
            updateCommodityPropTask.setJdbcTemplate(jdbcTemplate);
            updateCommodityPropTask.setChannel_count(total);
            fixedThreadPool.submit(updateCommodityPropTask);
        }
        fixedThreadPool.shutdown();
        while (!fixedThreadPool.isTerminated()) {
        }
        System.out.println("\u6279\u91cf\u66f4\u65b0\u5546\u54c1\u5c5e\u6027\u7ed3\u675f\uff01");
        long end = System.currentTimeMillis();
        long l = (end - start) / 1000L;
        System.out.println("\u66f4\u65b0\u5546\u54c1\u5c5e\u6027\u7528\u65f6:" + l);
    }
}

