/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.linkedmall;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.tydic.commodity.batchimp.initialize.req.processor.linkedmall.LinkedmallSynchronizationCommdityTask;
import com.tydic.commodity.batchimp.initialize.utils.DataPool;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class LinkedmallSynchronizationCommdityProc {
    private JdbcTemplate jdbcTemplate;
    private int channel_count;
    private int channel_id;

    public LinkedmallSynchronizationCommdityProc(JdbcTemplate jdbcTemplate, int channel_count, int channel_id) {
        this.jdbcTemplate = jdbcTemplate;
        this.channel_count = channel_count;
        this.channel_id = channel_id;
    }

    public void run() {
        List tempCommdityList = this.jdbcTemplate.queryForList("select ext_sku_id, shop_name, sku_title, sku_main_pic, sku_pic, sku_price, sku_sale_price,can_sale from temp_commdity where mod(id,?) = ? ", new Object[]{this.channel_count, this.channel_id});
        if (!CollectionUtils.isEmpty((Collection)tempCommdityList)) {
            for (Map tempMap : tempCommdityList) {
                try {
                    String mainPic = this.object2String(tempMap.get("sku_main_pic"));
                    String skuPicChar = this.object2String(tempMap.get("sku_pic"));
                    String canSale = this.object2String(tempMap.get("can_sale"));
                    StringBuilder sb = new StringBuilder("update external_commodity_detail t1 ");
                    sb.append("set");
                    ArrayList<String> parm = new ArrayList<String>();
                    if (!StringUtils.isEmpty((Object)mainPic)) {
                        sb.append(" IMAGE_PATH=?,");
                        parm.add("https:" + mainPic);
                    }
                    if (!StringUtils.isEmpty((Object)skuPicChar)) {
                        sb.append(" INTRODUCTION=?,");
                        parm.add(skuPicChar);
                    }
                    if (!StringUtils.isEmpty((Object)canSale)) {
                        sb.append(" STATE=?,");
                        parm.add(canSale);
                    }
                    String substring = "";
                    if (sb.lastIndexOf(",") > 0) {
                        substring = sb.substring(0, sb.lastIndexOf(","));
                        substring = substring + " where sku=?";
                        parm.add((String)tempMap.get("ext_sku_id"));
                        Object[] objects = parm.toArray();
                        System.err.println(substring);
                        System.err.println(tempMap.get("ext_sku_id"));
                        this.jdbcTemplate.update(substring, objects);
                    }
                    Gson gson = new Gson();
                    List tempSkuList = this.jdbcTemplate.queryForList("select item_id, sku_id, sku_pic, sku_title, sku_prop, sku_price, sku_sale_price from temp_sku where item_id=?", new Object[]{tempMap.get("ext_sku_id")});
                    if (CollectionUtils.isEmpty((Collection)tempSkuList)) continue;
                    for (Map skuParm : tempSkuList) {
                        String skuProp;
                        String skuPic = this.object2String(skuParm.get("sku_pic"));
                        if (!StringUtils.isEmpty((Object)skuPic)) {
                            System.err.println("update external_sku_detail");
                            System.err.println(tempMap.get("ext_sku_id") + " and sku:" + skuParm.get("sku_id"));
                            this.jdbcTemplate.update("update external_sku_detail set IMAGE_PATH=? where item_id=? and sku=?", new Object[]{skuPic, skuParm.get("item_id"), skuParm.get("sku_id")});
                        }
                        if (!StringUtils.isEmpty((Object)(skuProp = this.object2String(skuParm.get("sku_prop"))))) {
                            String itemId = "";
                            List item_id = this.jdbcTemplate.queryForList("select 1 from external_sku_attr where SKU=?", new Object[]{skuParm.get("item_id")});
                            if (!CollectionUtils.isEmpty((Collection)item_id)) {
                                System.err.println("delete from external_sku_attr");
                                this.jdbcTemplate.update("delete from external_sku_attr where sku=? and attr_type=1", new Object[]{skuParm.get("item_id")});
                                itemId = this.object2String(skuParm.get("item_id"));
                            } else {
                                System.err.println("delete from external_sku_attr");
                                this.jdbcTemplate.update("delete from external_sku_attr where sku=? and attr_type=1", new Object[]{skuParm.get("sku_id")});
                                itemId = this.object2String(skuParm.get("sku_id"));
                            }
                            JsonObject jsonObject = (JsonObject)gson.fromJson(skuProp, JsonObject.class);
                            ArrayList<Object[]> attrList = new ArrayList<Object[]>();
                            if (jsonObject != null) {
                                for (Map.Entry next : jsonObject.entrySet()) {
                                    String key = (String)next.getKey();
                                    String value = jsonObject.get(key).getAsString();
                                    Object[] attrparm = new Object[]{itemId, "empty", "empty", "empty", "empty", key, 1, value, "linkedmall", 1};
                                    attrList.add(attrparm);
                                }
                            }
                            System.err.println("INSERT INTO EXTERNAL_SKU_ATTR");
                            System.err.println(tempMap.get("ext_sku_id") + " and sku:" + skuParm.get("sku_id"));
                            this.jdbcTemplate.batchUpdate("INSERT INTO EXTERNAL_SKU_ATTR (sku,ATTR_CODE,ATTR_GROUP_CODE,ATTR_GROUP_NAME,ATTR_GROUP_SEQ,ATTR_NAME,ATTR_SEQ,ATTR_VALUE,SUPPLIER_CODE,ATTR_TYPE) VALUES (?,?,?,?,?,?,?,?,?,?)", attrList);
                        }
                        String price = LinkedmallSynchronizationCommdityProc.round(skuParm.get("sku_price"));
                        String salePrice = LinkedmallSynchronizationCommdityProc.round(skuParm.get("sku_sale_price"));
                        StringBuilder priceSb = new StringBuilder("update external_price t1 ");
                        priceSb.append("set");
                        ArrayList<String> priceParm = new ArrayList<String>();
                        if (!StringUtils.isEmpty((Object)price)) {
                            priceSb.append(" EXTERNAL_PRICE=?,");
                            priceParm.add(price);
                        }
                        if (!StringUtils.isEmpty((Object)salePrice)) {
                            priceSb.append(" SELL_PRICE=?,");
                            priceParm.add(salePrice);
                        }
                        String substringPrice = "";
                        if (priceSb.lastIndexOf(",") <= 0) continue;
                        substringPrice = priceSb.substring(0, priceSb.lastIndexOf(","));
                        substringPrice = substringPrice + " where sku=?";
                        List item_id = this.jdbcTemplate.queryForList("select 1 from external_price where sku=?", new Object[]{skuParm.get("item_id")});
                        if (!CollectionUtils.isEmpty((Collection)item_id)) {
                            priceParm.add((String)skuParm.get("item_id"));
                        } else {
                            priceParm.add((String)skuParm.get("sku_id"));
                        }
                        Object[] objects = priceParm.toArray();
                        System.err.println(substringPrice);
                        System.err.println(tempMap.get("ext_sku_id") + " and sku:" + skuParm.get("sku_id"));
                        this.jdbcTemplate.update(substringPrice, objects);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String round(Object price) {
        if (price != null) {
            double parm = Double.parseDouble(price + "");
            DecimalFormat df = new DecimalFormat("#.00");
            String result = df.format(parm);
            String lastPos = result.substring(result.indexOf(".") + 2, result.indexOf(".") + 3);
            int lastInt = Integer.parseInt(lastPos);
            double offsetDouble = 0.1 - Double.parseDouble("0.0" + lastPos);
            double retVal = 0.0;
            retVal = lastInt >= 5 ? parm + offsetDouble : parm - Double.parseDouble("0.0" + lastPos);
            return new BigDecimal(retVal).setScale(2, 5).toString();
        }
        return null;
    }

    public String object2String(Object parm) {
        if (parm == null) {
            return "";
        }
        return parm.toString();
    }

    public static void main(String[] args) throws Exception {
        JdbcTemplate jdbcTemplate = DataPool.getJdbcTemplatePre();
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-call-runner-%d").build();
        ThreadPoolExecutor fixedThreadPool = new ThreadPoolExecutor(50, 50, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        System.out.println("\u5546\u54c1\u63a8\u9001\u5f00\u59cb\uff01");
        long start = System.currentTimeMillis();
        int total = 50;
        for (int i = 0; i < total; ++i) {
            LinkedmallSynchronizationCommdityTask task = new LinkedmallSynchronizationCommdityTask();
            task.setChannel_id(i);
            task.setJdbcTemplate(jdbcTemplate);
            task.setChannel_count(total);
            fixedThreadPool.submit(task);
        }
        fixedThreadPool.shutdown();
        while (true) {
            if (fixedThreadPool.isTerminated()) break;
            Thread.sleep(1000L);
        }
        System.out.println("\u5546\u54c1\u63a8\u9001\u6267\u884c\u7ed3\u675f\uff01");
        long end = System.currentTimeMillis();
        long l = (end - start) / 1000L;
        System.out.println("\u5546\u54c1\u63a8\u9001\u7528\u65f6:" + l);
    }
}

