/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.suning;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tydic.commodity.batchimp.initialize.req.model.deli.DeliGetSkuDetailReq;
import com.tydic.commodity.batchimp.initialize.resp.model.deli.DeliSkuAttr;
import com.tydic.commodity.batchimp.initialize.resp.model.deli.DeliSkuDetail;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class NewSuningApiGetDetailProc
implements Runnable {
    private String apiuri = "http://txapipre.cnsuning.com/inserv/getDetail";
    private JdbcTemplate jdbcTemplate;
    private String token;
    private int channel_id;
    private int total;
    private String supplierCode;
    private static final Logger log = LoggerFactory.getLogger(NewSuningApiGetDetailProc.class);

    public NewSuningApiGetDetailProc(JdbcTemplate jdbcTemplate, String token, int channel_id, int total, String supplierCode) {
        this.jdbcTemplate = jdbcTemplate;
        this.token = token;
        this.channel_id = channel_id;
        this.total = total;
        this.supplierCode = supplierCode;
    }

    @Override
    public void run() {
        List rows = this.jdbcTemplate.queryForList("select sku from EXTERNAL_SKU_SET where mod(id,?) = ? and  sku not in (select sku from EXTERNAL_SKU_DETAIL) and SUPPLIER_CODE=?", new Object[]{this.total, this.channel_id, this.supplierCode});
        for (Map map : rows) {
            String sku = map.get("sku").toString();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timestamp = df.format(new Date());
            DeliGetSkuDetailReq deliGetSkuDetailReq = new DeliGetSkuDetailReq();
            deliGetSkuDetailReq.setIsShow("false");
            deliGetSkuDetailReq.setSku(sku);
            String org_info = "";
            try {
                Gson gson = new Gson();
                HttpRequest http = new HttpRequest();
                JsonParser parser = new JsonParser();
                org_info = HttpRequest.sendPost(this.apiuri, "token=" + this.token + "&sku=" + deliGetSkuDetailReq.getSku() + "&isShow=" + deliGetSkuDetailReq.getIsShow() + "&serialNumber=111&timeStamp=" + timestamp + "&appkey=GDWL");
                if (parser.parse(org_info).getAsJsonObject().get("result").getAsJsonObject().isJsonNull()) continue;
                JsonObject json_result = parser.parse(org_info).getAsJsonObject().get("result").getAsJsonObject();
                DeliSkuDetail deliSkuDetail = new DeliSkuDetail();
                deliSkuDetail.setBrandName(json_result.get("brandName") == null || json_result.get("brandName").isJsonNull() ? "empty" : json_result.get("brandName").getAsString());
                deliSkuDetail.setBrandPic(json_result.get("brandPic") == null || json_result.get("brandPic").isJsonNull() ? "empty" : json_result.get("brandPic").getAsString());
                if (json_result.get("category") != null && !json_result.get("category").isJsonNull()) {
                    deliSkuDetail.setSku_cate4(json_result.get("category").getAsJsonArray().get(0).isJsonNull() ? "empty" : json_result.get("category").getAsJsonArray().get(0).getAsString());
                }
                deliSkuDetail.setDeliveryTime(json_result.get("deliveryTime") == null || json_result.get("deliveryTime").isJsonNull() ? "empty" : json_result.get("deliveryTime").getAsString());
                deliSkuDetail.setImagePath(json_result.get("imagePath") == null || json_result.get("imagePath").isJsonNull() ? "empty" : json_result.get("imagePath").getAsString());
                deliSkuDetail.setIntroduction(json_result.get("introduction") == null || json_result.get("introduction").isJsonNull() ? "empty" : json_result.get("introduction").getAsString());
                deliSkuDetail.setMfgSku(json_result.get("mfgSku") == null || json_result.get("mfgSku").isJsonNull() ? "empty" : json_result.get("mfgSku").getAsString());
                deliSkuDetail.setMoq(json_result.get("moq") == null || json_result.get("moq").isJsonNull() ? 1 : json_result.get("moq").getAsInt());
                deliSkuDetail.setName(json_result.get("name") == null || json_result.get("name").isJsonNull() ? "empty" : json_result.get("name").getAsString());
                deliSkuDetail.setProductArea(json_result.get("productArea") == null || json_result.get("productArea").isJsonNull() ? "empty" : json_result.get("productArea").getAsString());
                deliSkuDetail.setSaleUnit(json_result.get("saleUnit") == null || json_result.get("saleUnit").isJsonNull() ? "empty" : json_result.get("saleUnit").getAsString());
                deliSkuDetail.setSku(json_result.get("sku") == null || json_result.get("sku").isJsonNull() ? "empty" : json_result.get("sku").getAsString());
                deliSkuDetail.setState(json_result.get("state") == null || json_result.get("state").isJsonNull() ? -1 : json_result.get("state").getAsInt());
                deliSkuDetail.setWareQD(json_result.get("wareQD") == null || json_result.get("wareQD").isJsonNull() ? "empty" : json_result.get("wareQD").getAsString());
                deliSkuDetail.setWeight(json_result.get("weight") == null || json_result.get("weight").isJsonNull() ? "empty" : json_result.get("weight").getAsString());
                deliSkuDetail.setUpc(json_result.get("upc") == null || json_result.get("upc").isJsonNull() ? "" : json_result.get("upc").getAsString());
                if (json_result.get("param") != null && !json_result.get("param").isJsonNull()) {
                    JsonArray jsonArray = json_result.get("param").getAsJsonArray();
                    ArrayList<DeliSkuAttr> attrlist = new ArrayList<DeliSkuAttr>();
                    ArrayList<Object[]> attr_obj_list = new ArrayList<Object[]>();
                    for (JsonElement jsonElement : jsonArray) {
                        DeliSkuAttr deliSkuAttr = new DeliSkuAttr();
                        deliSkuAttr.setAttrCode(jsonElement.getAsJsonObject().get("attrCode") == null || jsonElement.getAsJsonObject().get("attrCode").isJsonNull() ? "empty" : jsonElement.getAsJsonObject().get("attrCode").getAsString());
                        deliSkuAttr.setAttrGroupCode(jsonElement.getAsJsonObject().get("attrGroupCode") == null || jsonElement.getAsJsonObject().get("attrGroupCode").isJsonNull() ? "empty" : jsonElement.getAsJsonObject().get("attrGroupCode").getAsString());
                        deliSkuAttr.setAttrGroupName(jsonElement.getAsJsonObject().get("attrGroupName") == null || jsonElement.getAsJsonObject().get("attrGroupName").isJsonNull() ? "empty" : jsonElement.getAsJsonObject().get("attrGroupName").getAsString());
                        deliSkuAttr.setAttrGroupSeq(jsonElement.getAsJsonObject().get("attrGroupSeq") == null || jsonElement.getAsJsonObject().get("attrGroupSeq").isJsonNull() ? "empty" : jsonElement.getAsJsonObject().get("attrGroupSeq").getAsString());
                        deliSkuAttr.setAttrName(jsonElement.getAsJsonObject().get("attrName") == null || jsonElement.getAsJsonObject().get("attrName").isJsonNull() ? "empty" : jsonElement.getAsJsonObject().get("attrName").getAsString());
                        deliSkuAttr.setAttrSeq(jsonElement.getAsJsonObject().get("attrSeq") == null || jsonElement.getAsJsonObject().get("attrSeq").isJsonNull() ? "empty" : jsonElement.getAsJsonObject().get("attrSeq").getAsString());
                        deliSkuAttr.setAttrValue(jsonElement.getAsJsonObject().get("attrValue") == null || jsonElement.getAsJsonObject().get("attrValue").isJsonNull() ? "empty" : jsonElement.getAsJsonObject().get("attrValue").getAsString());
                        attrlist.add(deliSkuAttr);
                        Object[] attr_obj = new Object[]{deliSkuDetail.getSku(), deliSkuAttr.getAttrCode(), deliSkuAttr.getAttrGroupCode(), deliSkuAttr.getAttrGroupName(), deliSkuAttr.getAttrGroupSeq(), deliSkuAttr.getAttrName(), deliSkuAttr.getAttrSeq(), deliSkuAttr.getAttrValue(), this.supplierCode, 0};
                        attr_obj_list.add(attr_obj);
                    }
                    this.jdbcTemplate.batchUpdate("INSERT INTO EXTERNAL_SKU_ATTR (sku,ATTR_CODE,ATTR_GROUP_CODE,ATTR_GROUP_NAME,ATTR_GROUP_SEQ,ATTR_NAME,ATTR_SEQ,ATTR_VALUE,SUPPLIER_CODE,attr_type) VALUES (?,?,?,?,?,?,?,?,?,?)", attr_obj_list);
                    deliSkuDetail.setAttrlist(attrlist);
                    attr_obj_list.clear();
                    attrlist.clear();
                }
                this.jdbcTemplate.update("INSERT INTO EXTERNAL_SKU_DETAIL (SALE_UNIT,weight,PRODUCT_AREA,WARE_QD,IMAGE_PATH,BRAND_PIC,param,state,moq,BRAND_NAME,sku,MFG_SKU,upc,name,DELIVERY_TIME,introduction,sku_cate1,sku_cate2,sku_cate3,sku_cate4,SUPPLIER_CODE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{deliSkuDetail.getSaleUnit(), deliSkuDetail.getWeight(), deliSkuDetail.getProductArea(), deliSkuDetail.getWareQD(), deliSkuDetail.getImagePath(), deliSkuDetail.getBrandPic(), deliSkuDetail.getParam(), deliSkuDetail.getState(), deliSkuDetail.getMoq(), deliSkuDetail.getBrandName(), deliSkuDetail.getSku(), deliSkuDetail.getMfgSku(), deliSkuDetail.getUpc(), deliSkuDetail.getName(), deliSkuDetail.getDeliveryTime(), deliSkuDetail.getIntroduction(), deliSkuDetail.getSku_cate1(), deliSkuDetail.getSku_cate2(), deliSkuDetail.getSku_cate3(), deliSkuDetail.getSku_cate4(), this.supplierCode});
                this.jdbcTemplate.update("INSERT INTO external_commodity_detail (SALE_UNIT,weight,PRODUCT_AREA,WARE_QD,IMAGE_PATH,BRAND_PIC,param,state,moq,BRAND_NAME,sku,MFG_SKU,upc,name,DELIVERY_TIME,introduction,sku_cate1,sku_cate2,sku_cate3,sku_cate4,SUPPLIER_CODE,item_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{deliSkuDetail.getSaleUnit(), deliSkuDetail.getWeight(), deliSkuDetail.getProductArea(), deliSkuDetail.getWareQD(), deliSkuDetail.getImagePath(), deliSkuDetail.getBrandPic(), deliSkuDetail.getParam(), deliSkuDetail.getState(), deliSkuDetail.getMoq(), deliSkuDetail.getBrandName(), deliSkuDetail.getSku(), deliSkuDetail.getMfgSku(), deliSkuDetail.getUpc(), deliSkuDetail.getName(), deliSkuDetail.getDeliveryTime(), deliSkuDetail.getIntroduction(), deliSkuDetail.getSku_cate1(), deliSkuDetail.getSku_cate2(), deliSkuDetail.getSku_cate3(), deliSkuDetail.getSku_cate4(), this.supplierCode, deliSkuDetail.getSku()});
            }
            catch (Exception e) {
                log.info(e.toString() + "error_sku:" + sku);
                log.info(e.toString() + " error_json: " + org_info);
                System.out.println(e.toString());
            }
        }
    }
}

