/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.suning;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tydic.commodity.batchimp.initialize.req.model.sunning.SunningGetSkuByPageReq;
import com.tydic.commodity.batchimp.initialize.resp.model.deli.DeliPageNum;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

public class NewSuningApiGetSkuByPageProc
implements Runnable {
    private String apiuri = "http://txapipre.cnsuning.com/inserv/getSkuByPage";
    private JdbcTemplate jdbcTemplate;
    private String token;
    private DeliPageNum deliPageNum;
    private int channel_count;
    private int channel_id;
    private String supplierCode;
    private String pageNumber;
    private static final Logger log = LoggerFactory.getLogger(NewSuningApiGetSkuByPageProc.class);

    public NewSuningApiGetSkuByPageProc(JdbcTemplate jdbcTemplate, String token, int channel_id, int channel_count, String pageNumber, String supplierCode) {
        this.jdbcTemplate = jdbcTemplate;
        this.token = token;
        this.deliPageNum = this.deliPageNum;
        this.channel_count = channel_count;
        this.channel_id = channel_id;
        this.pageNumber = pageNumber;
        this.supplierCode = supplierCode;
    }

    @Override
    public void run() {
        HttpRequest http = new HttpRequest();
        List rows = StringUtils.isEmpty((Object)this.pageNumber) ? this.jdbcTemplate.queryForList("select id,name,page_num,curr_page_no,total_page_count from UCC_COMMODITY_PAGE_NUM  where mod(id,?) = ? and flag = 0 and SUPPLIER_CODE=? limit 100000", new Object[]{this.channel_count, this.channel_id, this.supplierCode}) : this.jdbcTemplate.queryForList("select id,name,page_num,curr_page_no,total_page_count from UCC_COMMODITY_PAGE_NUM  where mod(id,?) = ? and flag = 0 and PAGE_NUM=? and SUPPLIER_CODE=? limit 100000", new Object[]{this.channel_count, this.channel_id, this.pageNumber, this.supplierCode});
        for (Map map : rows) {
            DeliPageNum deliPageNum = new DeliPageNum();
            deliPageNum.setName(map.get("name").toString());
            deliPageNum.setPage_num(map.get("page_num").toString());
            int pagecount = Integer.parseInt(map.get("total_page_count").toString());
            int curr_page_no = Integer.parseInt(map.get("curr_page_no").toString());
            log.info(this.apiuri);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timestamp = df.format(new Date());
            for (int i = curr_page_no + 1; i <= pagecount; ++i) {
                ArrayList<Object[]> sku_set_list = new ArrayList<Object[]>();
                Gson gson = new Gson();
                SunningGetSkuByPageReq sunningGetSkuByPageReq = new SunningGetSkuByPageReq();
                sunningGetSkuByPageReq.setPageNum(deliPageNum.getPage_num());
                sunningGetSkuByPageReq.setPageNo(i);
                sunningGetSkuByPageReq.setToken(this.token);
                sunningGetSkuByPageReq.setSerialNumber("sjd79and83cgem");
                sunningGetSkuByPageReq.setTimeStamp(timestamp);
                String parm = "token=" + this.token + "&pageNum=" + sunningGetSkuByPageReq.getPageNum() + "&pageNo=" + sunningGetSkuByPageReq.getPageNo() + "&serialNumber=" + sunningGetSkuByPageReq.getSerialNumber() + "&timeStamp=" + timestamp + "&appkey=GDWL";
                log.info("org_info_parm = " + parm);
                String org_info = HttpRequest.sendPost(this.apiuri, parm);
                log.info("org_info = " + org_info);
                JsonParser parse = new JsonParser();
                if (parse.parse(org_info).getAsJsonObject().get("result") != null && !parse.parse(org_info).getAsJsonObject().get("result").isJsonNull()) {
                    JsonObject jsonObject = parse.parse(org_info).getAsJsonObject().get("result").getAsJsonObject();
                    pagecount = jsonObject.get("pageCount").getAsInt();
                    for (JsonElement str : jsonObject.get("skuIds").getAsJsonArray()) {
                        Object[] obj = new Object[]{deliPageNum.getPage_num(), str.getAsString(), i, this.supplierCode};
                        sku_set_list.add(obj);
                    }
                    log.info("org_info = " + org_info);
                    if (sku_set_list.size() > 0) {
                        this.jdbcTemplate.batchUpdate("INSERT INTO EXTERNAL_SKU_SET (page_num,sku,page_no,SUPPLIER_CODE) VALUES (?,?,?,?)", sku_set_list);
                        this.jdbcTemplate.update("update UCC_COMMODITY_PAGE_NUM set curr_page_no = ?,total_page_count = ? where id = ?", new Object[]{i, pagecount, Integer.parseInt(map.get("id").toString())});
                    }
                }
                sku_set_list.clear();
            }
            this.jdbcTemplate.update("update UCC_COMMODITY_PAGE_NUM set flag = 1 where id = ?", new Object[]{Integer.parseInt(map.get("id").toString())});
        }
    }
}

