/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.atom.BO.UccDealCommodityReqBO;
import com.tydic.commodity.atom.BO.UccDealCommodityRespBO;
import com.tydic.commodity.atom.BO.UccDealPutawayApproveReqBO;
import com.tydic.commodity.atom.BO.UccDealPutawayApproveRespBO;
import com.tydic.commodity.atom.BO.UccDealSkuDetailReqBO;
import com.tydic.commodity.atom.BO.UccDealSkuDetailRespBO;
import com.tydic.commodity.atom.BO.UccDealSkuPriceReqBO;
import com.tydic.commodity.atom.BO.UccDealSkuPriceRespBO;
import com.tydic.commodity.atom.BO.UccDealSkuPropReqBO;
import com.tydic.commodity.atom.BO.UccDealSkuPropRspBO;
import com.tydic.commodity.atom.BO.UccGetSupplierCodeReqBO;
import com.tydic.commodity.atom.BO.UccGetSupplierCodeRespBO;
import com.tydic.commodity.atom.UccDealCommodityAtomService;
import com.tydic.commodity.atom.UccDealPutawayApproveAtomService;
import com.tydic.commodity.atom.UccDealSkuDetailAtomService;
import com.tydic.commodity.atom.UccDealSkuPriceAtomService;
import com.tydic.commodity.atom.UccDealSkuPropAtomService;
import com.tydic.commodity.atom.UccGetSupplierCodeAtomService;
import com.tydic.commodity.busi.UccDealAddBySkuBusiService;
import com.tydic.commodity.busi.bo.UccDealAddBySkuReqBO;
import com.tydic.commodity.busi.bo.UccDealAddBySkuRespBO;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class UccDealAddBySkuBusiServiceImpl
implements UccDealAddBySkuBusiService {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static final String SUCCESS_RESP_CODE = "0000";
    private static final String ERROR_RESP_CODE = "8888";
    private static final Logger log = LoggerFactory.getLogger(UccDealAddBySkuBusiServiceImpl.class);
    @Autowired
    private UccGetSupplierCodeAtomService uccGetSupplierCodeAtomService;
    @Autowired
    private UccDealSkuDetailAtomService uccDealSkuDetailAtomService;
    @Autowired
    private UccDealSkuPriceAtomService uccDealSkuPriceAtomService;
    @Autowired
    @Qualifier(value="uccDealSkuPropAtomService")
    private UccDealSkuPropAtomService uccDealSkuPropAtomService;
    @Autowired
    @Qualifier(value="uccDealCommodityAtomService")
    private UccDealCommodityAtomService uccDealCommodityAtomService;
    @Autowired
    private UccDealPutawayApproveAtomService uccDealPutawayApproveAtomService;

    @Override
    public UccDealAddBySkuRespBO dealAddBySku(UccDealAddBySkuReqBO uccDealAddBySkuReqBO) {
        UccDealAddBySkuRespBO uccDealAddBySkuRespBO = new UccDealAddBySkuRespBO();
        try {
            UccGetSupplierCodeReqBO uccGetSupplierCodeReqBO = new UccGetSupplierCodeReqBO();
            uccGetSupplierCodeReqBO.setJdbcTemplate(this.jdbcTemplate);
            uccGetSupplierCodeReqBO.setSupplierId(uccDealAddBySkuReqBO.getSupplierId());
            UccGetSupplierCodeRespBO uccGetSupplierCodeRespBO = this.uccGetSupplierCodeAtomService.dealGetSupplierCode(uccGetSupplierCodeReqBO);
            if (!SUCCESS_RESP_CODE.equals(uccGetSupplierCodeRespBO.getRespCode())) {
                uccDealAddBySkuRespBO.setRespDesc("\u83b7\u53d6\u4f9b\u5e94\u5546\u7f16\u7801\u5931\u8d25");
                uccDealAddBySkuRespBO.setRespCode(ERROR_RESP_CODE);
                return uccDealAddBySkuRespBO;
            }
            String supplierCode = uccGetSupplierCodeRespBO.getSupplierCode();
            UccDealSkuDetailReqBO uccDealSkuDetailReqBO = new UccDealSkuDetailReqBO();
            uccDealSkuDetailReqBO.setJdbcTemplate(this.jdbcTemplate);
            uccDealSkuDetailReqBO.setSkuCodeList(uccDealAddBySkuReqBO.getSkuList());
            uccDealSkuDetailReqBO.setSupplierCode(supplierCode);
            UccDealSkuDetailRespBO uccDealSkuDetailRespBO = this.uccDealSkuDetailAtomService.dealSkuDetail(uccDealSkuDetailReqBO);
            if (!SUCCESS_RESP_CODE.equals(uccDealSkuDetailRespBO.getRespCode())) {
                uccDealAddBySkuRespBO.setRespDesc("\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u5931\u8d25");
                uccDealAddBySkuRespBO.setRespCode(ERROR_RESP_CODE);
                return uccDealAddBySkuRespBO;
            }
            UccDealSkuPriceReqBO uccDealSkuPriceReqBO = new UccDealSkuPriceReqBO();
            uccDealSkuPriceReqBO.setJdbcTemplate(this.jdbcTemplate);
            uccDealSkuPriceReqBO.setSkuCodeList(uccDealAddBySkuReqBO.getSkuList());
            uccDealSkuPriceReqBO.setSupplierCode(supplierCode);
            UccDealSkuPriceRespBO uccDealSkuPriceRespBO = this.uccDealSkuPriceAtomService.dealSkuPrice(uccDealSkuPriceReqBO);
            if (!SUCCESS_RESP_CODE.equals(uccDealSkuPriceRespBO.getRespCode())) {
                uccDealAddBySkuRespBO.setRespDesc("\u83b7\u53d6\u5546\u54c1\u4ef7\u683c\u5931\u8d25");
                uccDealAddBySkuRespBO.setRespCode(ERROR_RESP_CODE);
                return uccDealAddBySkuRespBO;
            }
            UccDealSkuPropReqBO uccDealSkuPropReqBO = new UccDealSkuPropReqBO();
            uccDealSkuPropReqBO.setJdbcTemplate(this.jdbcTemplate);
            uccDealSkuPropReqBO.setSkuListStr(this.buildSkuIdList(uccDealAddBySkuReqBO.getSkuList()));
            uccDealSkuPropReqBO.setSupplierCode(supplierCode);
            UccDealSkuPropRspBO uccDealSkuPropRspBO = this.uccDealSkuPropAtomService.dealSkuProp(uccDealSkuPropReqBO);
            if (!SUCCESS_RESP_CODE.equals(uccDealSkuPropRspBO.getRespCode())) {
                uccDealAddBySkuRespBO.setRespDesc("\u5904\u7406\u5c5e\u6027\u5931\u8d25");
                uccDealAddBySkuRespBO.setRespCode(ERROR_RESP_CODE);
                return uccDealAddBySkuRespBO;
            }
            UccDealCommodityReqBO uccDealCommodityReqBO = new UccDealCommodityReqBO();
            uccDealCommodityReqBO.setJdbcTemplate(this.jdbcTemplate);
            uccDealCommodityReqBO.setSkuListStr(this.buildSkuIdList(uccDealAddBySkuReqBO.getSkuList()));
            uccDealCommodityReqBO.setSupplierCode(supplierCode);
            UccDealCommodityRespBO uccDealCommodityRespBO = this.uccDealCommodityAtomService.dealCommodity(uccDealCommodityReqBO);
            if (!SUCCESS_RESP_CODE.equals(uccDealCommodityRespBO.getRespCode())) {
                uccDealAddBySkuRespBO.setRespDesc("\u5904\u7406\u5546\u54c1\u5931\u8d25");
                uccDealAddBySkuRespBO.setRespCode(ERROR_RESP_CODE);
                return uccDealAddBySkuRespBO;
            }
            UccDealPutawayApproveReqBO uccDealPutawayApproveReqBO = new UccDealPutawayApproveReqBO();
            uccDealPutawayApproveReqBO.setJdbcTemplate(this.jdbcTemplate);
            uccDealPutawayApproveReqBO.setSkuListStr(this.buildSkuIdList(uccDealAddBySkuReqBO.getSkuList()));
            uccDealPutawayApproveReqBO.setSupplierCode(supplierCode);
            UccDealPutawayApproveRespBO uccDealPutawayApproveRespBO = this.uccDealPutawayApproveAtomService.dealPutawayApprove(uccDealPutawayApproveReqBO);
            if (!SUCCESS_RESP_CODE.equals(uccDealPutawayApproveRespBO.getRespCode())) {
                uccDealAddBySkuRespBO.setRespDesc("\u5904\u7406\u5546\u54c1\u5ba1\u6279\u5931\u8d25");
                uccDealAddBySkuRespBO.setRespCode(ERROR_RESP_CODE);
                return uccDealAddBySkuRespBO;
            }
            uccDealAddBySkuRespBO.setCommodityInfoCheckReqBOList(uccDealPutawayApproveRespBO.getCommodityInfoCheckReqBOList());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u5904\u7406\u5546\u54c1\u65b0\u589e\u6d88\u606f\u5931\u8d25!");
        }
        uccDealAddBySkuRespBO.setRespCode(SUCCESS_RESP_CODE);
        uccDealAddBySkuRespBO.setRespDesc("\u5904\u7406\u5546\u54c1\u65b0\u589e\u6d88\u606f\u6210\u529f");
        return uccDealAddBySkuRespBO;
    }

    private String buildSkuIdList(List<String> skuList) {
        StringBuilder builder = new StringBuilder();
        if (CollectionUtils.isEmpty(skuList)) {
            return null;
        }
        if (skuList.size() == 1) {
            builder.append("'");
            builder.append(skuList.get(0));
            builder.append("'");
        } else {
            for (int i = 0; i < skuList.size(); ++i) {
                if (i != skuList.size() - 1) {
                    builder.append("'");
                    builder.append(skuList.get(i));
                    builder.append("'");
                    builder.append(",");
                    continue;
                }
                builder.append("'");
                builder.append(skuList.get(i));
                builder.append("'");
            }
        }
        return builder.toString();
    }
}

