/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.atom.BO.UccDealLinkedMallSkuPropReqBO;
import com.tydic.commodity.atom.BO.UccDealLinkedMallSkuPropRspBO;
import com.tydic.commodity.atom.BO.UccGetItemDetailBO;
import com.tydic.commodity.atom.BO.UccGetItemDetailRespBO;
import com.tydic.commodity.atom.BO.UccUpdateLinkedMallSkuPropAtomReqBO;
import com.tydic.commodity.atom.BO.UccUpdateLinkedMallSkuPropAtomRspBO;
import com.tydic.commodity.atom.UccDealLinkedMallSkuPropAtomService;
import com.tydic.commodity.atom.UccUpdateLinkedMallSkuPropAtomService;
import com.tydic.commodity.busi.UccUpdateLinkedMallSkuInfoBusiService;
import com.tydic.commodity.busi.bo.UccUpdateLinkedMallSkuInfoReqBO;
import com.tydic.commodity.busi.bo.UccUpdateLinkedMallSkuInfoRspBO;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.utils.DBUtils;
import com.tydic.commodity.utils.HttpTool;
import com.tydic.commodity.utils.SignUtil;
import com.tydic.commodity.utils.SupplierInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccUpdateLinkedMallSkuInfoBusiServiceImpl
implements UccUpdateLinkedMallSkuInfoBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccUpdateLinkedMallSkuInfoBusiServiceImpl.class);
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    private UccDealLinkedMallSkuPropAtomService uccDealLinkedmallSkuPropAtomService;
    @Autowired
    private UccUpdateLinkedMallSkuPropAtomService uccUpdateLinkedMallSkuPropAtomService;
    private static final String SUCCESS_RESP_CODE = "0000";
    private static final String ERROR_RESP_CODE = "8888";
    private static final Long APP_KEY = 56231899L;
    private static final String APP_SECRET = "da9d575d25824ef191298a104023f825";
    @Value(value="${TM_QRY_COMMD_URL}")
    private String url;

    @Override
    public UccUpdateLinkedMallSkuInfoRspBO updateProperties(UccUpdateLinkedMallSkuInfoReqBO reqBo) {
        UccUpdateLinkedMallSkuInfoRspBO rspBo = new UccUpdateLinkedMallSkuInfoRspBO();
        if (!StringUtils.hasText((String)reqBo.getExtItemId())) {
            throw new BusinessException(ERROR_RESP_CODE, "extItemId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long supplierShopId = 10025L;
        if (null != reqBo.getSupplierShopId()) {
            supplierShopId = reqBo.getSupplierShopId();
        }
        SupplierInfo supplierInfo = DBUtils.getSupplierInfo(this.jdbcTemplate, supplierShopId);
        Long commodityId = null != reqBo.getCommodityId() ? reqBo.getCommodityId() : (Long)this.jdbcTemplate.queryForObject("SELECT commodity_id FROM ucc_commodity WHERE ext_sku_id = ?", Long.class, new Object[]{reqBo.getExtItemId()});
        UccGetItemDetailBO uccGetItemDetailBO = this.getItemDetail(Long.valueOf(reqBo.getExtItemId()));
        if (null == uccGetItemDetailBO) {
            throw new BusinessException(ERROR_RESP_CODE, "\u5904\u7406\u8be6\u60c5\u5931\u8d25");
        }
        UccDealLinkedMallSkuPropReqBO uccDealSkuPropReqBO = new UccDealLinkedMallSkuPropReqBO();
        uccDealSkuPropReqBO.setJdbcTemplate(this.jdbcTemplate);
        uccDealSkuPropReqBO.setUccGetItemDetailBO(uccGetItemDetailBO);
        uccDealSkuPropReqBO.setSupplierShopId(supplierShopId);
        UccDealLinkedMallSkuPropRspBO uccDealSkuPropRspBO = this.uccDealLinkedmallSkuPropAtomService.dealSkuProp(uccDealSkuPropReqBO);
        if (!SUCCESS_RESP_CODE.equals(uccDealSkuPropRspBO.getRespCode())) {
            throw new BusinessException(ERROR_RESP_CODE, "\u5904\u7406\u5c5e\u6027\u5931\u8d25");
        }
        UccUpdateLinkedMallSkuPropAtomReqBO skuPropAtomReqBo = new UccUpdateLinkedMallSkuPropAtomReqBO();
        skuPropAtomReqBo.setJdbcTemplate(this.jdbcTemplate);
        skuPropAtomReqBo.setCommodityId(commodityId);
        skuPropAtomReqBo.setSupplierShopId(supplierInfo.getSupplierShopId());
        skuPropAtomReqBo.setCommditySpecList(uccDealSkuPropRspBO.getCommditySpecList());
        skuPropAtomReqBo.setSkuSpecList(uccDealSkuPropRspBO.getSkuSpecList());
        UccUpdateLinkedMallSkuPropAtomRspBO skuPropAtomRspBo = this.uccUpdateLinkedMallSkuPropAtomService.updateSkuProp(skuPropAtomReqBo);
        if (!SUCCESS_RESP_CODE.equals(skuPropAtomRspBo.getRespCode())) {
            throw new BusinessException(ERROR_RESP_CODE, "\u66f4\u65b0\u5c5e\u6027\u5931\u8d25");
        }
        List sceneIdList = this.jdbcTemplate.queryForList("SELECT c.SCENE_ID FROM ucc_commodity a \nLEFT JOIN ucc_r_catalog_commodity_type b ON a.COMMODITY_TYPE_ID = b.COMMODITY_TYPE_ID \nLEFT JOIN ucc_guide_catalog c ON b.GUIDE_CATALOG_ID = c.GUIDE_CATALOG_ID \nWHERE COMMODITY_ID = ?", Long.class, new Object[]{commodityId});
        rspBo.setSceneIdList(sceneIdList);
        rspBo.setRespCode(SUCCESS_RESP_CODE);
        rspBo.setRespDesc("\u66f4\u65b0\u5c5e\u6027\u6210\u529f");
        return rspBo;
    }

    public UccGetItemDetailBO getItemDetail(Long itemId) {
        UccGetItemDetailRespBO uccGetItemDetailRespBO;
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("appKey", APP_KEY);
        params.put("itemId", itemId);
        String respJson = this.sendHttp(this.url, params);
        if (!StringUtils.isEmpty((Object)respJson) && SUCCESS_RESP_CODE.equals((uccGetItemDetailRespBO = (UccGetItemDetailRespBO)JSONObject.parseObject((String)respJson, UccGetItemDetailRespBO.class)).getCode())) {
            return uccGetItemDetailRespBO.getData().getItem();
        }
        return null;
    }

    public String sendHttp(String url, Map<String, Object> postParm) {
        String signMp = "";
        try {
            signMp = SignUtil.getSignMp(postParm, APP_SECRET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        postParm.put("sign", signMp);
        String respJson = HttpTool.sendPostJson(url, JSON.toJSONString(postParm));
        return respJson;
    }
}

